/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.util;

import java.lang.reflect.Method;
import java.util.ArrayList;

public class ClassUtil {
    private ClassUtil() {
    }

    public static <T> Class<T> byName(Class<T> cls, String name) {
        try {
            Class<?> c = Class.forName(name);
            if (cls.isAssignableFrom(c)) {
                return c;
            }
            throw new IllegalStateException("The class '" + name + "' is not of type " + cls);
        }
        catch (ClassNotFoundException x) {
            x.printStackTrace();
            return null;
        }
    }

    public static <T> T instanceByName(Class<T> cls, String name) {
        try {
            Class<?> c = Class.forName(name);
            if (!cls.isAssignableFrom(c)) {
                throw new IllegalStateException("The class '" + name + "' is not of type " + cls);
            }
            return (T)c.newInstance();
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public static <T> Method[] findMethod(Class<T> cls, String method) {
        Method[] mar;
        ArrayList<Method> res = new ArrayList<Method>();
        for (Method m : mar = cls.getMethods()) {
            if (!m.getName().equals(method)) continue;
            res.add(m);
        }
        return res.toArray(new Method[res.size()]);
    }
}

