/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import to.etc.iocular.Container;
import to.etc.iocular.web.WebConfiguration;

public class Iocular {
    private static ServletContext m_appContext;
    private static final ThreadLocal<HttpSession> m_currentSession;
    private static final ThreadLocal<HttpServletRequest> m_currentRequest;
    private static final ThreadLocal<Container> m_requestContainer;

    private Iocular() {
    }

    public static final synchronized ServletContext getApplication() {
        if (m_appContext == null) {
            throw new IllegalStateException("The application context is not yet set. Have you configured WebApplicationListener as a Servlet Listener in web.xml?");
        }
        return m_appContext;
    }

    static final synchronized void _setApplication(ServletContext ctx, Container c) {
        if (m_appContext != null) {
            throw new IllegalStateException("The application context is *already* set - internal error?");
        }
        m_appContext = ctx;
    }

    public static final HttpSession getCurrentSession() {
        HttpSession ses = m_currentSession.get();
        if (ses == null) {
            throw new IllegalStateException("The 'current session' is unknown. Have you configured WebApplicationListener as a Servlet Listener in web.xml?");
        }
        return ses;
    }

    public static final HttpServletRequest getCurrentRequest() {
        HttpServletRequest req = m_currentRequest.get();
        if (req == null) {
            throw new IllegalStateException("The 'current request' is unknown. Have you configured WebApplicationListener as a Servlet Listener in web.xml?");
        }
        return req;
    }

    static final void _setRequest(HttpServletRequest req, Container c) {
        m_currentRequest.set(req);
        m_currentSession.set(req.getSession(true));
        m_requestContainer.set(c);
    }

    public static final Container findApplicationContainer(ServletContext ctx) {
        return (Container)ctx.getAttribute("appContainer");
    }

    public static final WebConfiguration getConfiguration(ServletContext ctx) {
        WebConfiguration wc = (WebConfiguration)ctx.getAttribute("webAppConfig");
        if (wc == null) {
            throw new IllegalStateException("No web configuration: Have you configured WebApplicationListener as a Servlet Listener in web.xml?");
        }
        return wc;
    }

    public static final Container findSessionContainer(HttpSession ses) {
        return (Container)ses.getAttribute("sessionContainer");
    }

    public static final Container findRequestContainer(HttpServletRequest ses) {
        return (Container)ses.getAttribute("requestContainer");
    }

    public static final Container getRequestContainer() {
        Container c = m_requestContainer.get();
        if (c == null) {
            throw new IllegalStateException("No request executing");
        }
        return c;
    }

    static {
        m_currentSession = new ThreadLocal();
        m_currentRequest = new ThreadLocal();
        m_requestContainer = new ThreadLocal();
    }
}

