/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.iocular.Container;
import to.etc.iocular.container.BasicContainer;
import to.etc.iocular.util.ClassUtil;
import to.etc.iocular.web.DefaultWebConfigurator;
import to.etc.iocular.web.Iocular;
import to.etc.iocular.web.WebConfiguration;
import to.etc.iocular.web.WebConfigurator;

public class WebApplicationListener
implements ServletContextListener,
HttpSessionListener,
ServletRequestListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebApplicationListener.class);

    public void contextInitialized(ServletContextEvent cxe) {
        try {
            LOG.debug("Starting web application.");
            WebApplicationListener.createConfiguration(cxe.getServletContext());
            LOG.debug("Starting web application succeeded.");
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent cxe) {
        LOG.info("Terminating web application.");
        Container c = Iocular.findApplicationContainer(cxe.getServletContext());
        if (c != null) {
            c.destroy();
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        LOG.debug("Session created");
        this.createSessionContainer(se.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Container createSessionContainer(HttpSession hs) {
        HttpSession httpSession = hs;
        synchronized (httpSession) {
            Container c = Iocular.findSessionContainer(hs);
            if (c != null) {
                return c;
            }
            WebConfiguration wc = Iocular.getConfiguration(hs.getServletContext());
            c = Iocular.findApplicationContainer(hs.getServletContext());
            BasicContainer bc = new BasicContainer(wc.getSessionDefinition(), c);
            bc.start();
            hs.setAttribute("sessionContainer", (Object)bc);
            return bc;
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        LOG.info("Session destroyed");
        Container c = Iocular.findSessionContainer(se.getSession());
        if (c != null) {
            c.destroy();
        }
    }

    public void requestInitialized(ServletRequestEvent e) {
        LOG.debug("Request entered");
        HttpServletRequest req = (HttpServletRequest)e.getServletRequest();
        WebConfiguration wc = Iocular.getConfiguration(e.getServletContext());
        Container sc = this.createSessionContainer(req.getSession(true));
        if (sc == null) {
            throw new IllegalStateException("No session container found!?");
        }
        BasicContainer bc = new BasicContainer(wc.getRequestDefinition(), sc);
        bc.start();
        req.setAttribute("requestContainer", (Object)bc);
        Iocular._setRequest((HttpServletRequest)e.getServletRequest(), bc);
    }

    public void requestDestroyed(ServletRequestEvent e) {
        LOG.debug("Request destroyed");
        Container c = Iocular.findRequestContainer((HttpServletRequest)e.getServletRequest());
        if (c != null) {
            c.destroy();
        }
    }

    public static WebConfiguration createConfiguration(ServletContext ctx) throws Exception {
        WebConfiguration conf = (WebConfiguration)ctx.getAttribute("webAppConfig");
        if (conf != null) {
            return conf;
        }
        String cn = ctx.getInitParameter("configurator-class");
        WebConfigurator wc = cn != null ? ClassUtil.instanceByName(WebConfigurator.class, cn) : new DefaultWebConfigurator();
        conf = wc.createConfiguration(ctx);
        Container c = WebApplicationListener.createAppContainer(conf);
        Iocular._setApplication(ctx, c);
        ctx.setAttribute("appContainer", (Object)c);
        ctx.setAttribute("webAppConfig", (Object)conf);
        return conf;
    }

    private static Container createAppContainer(WebConfiguration wc) {
        BasicContainer bc = new BasicContainer(wc.getApplicationDefinition(), null);
        bc.start();
        return bc;
    }
}

