/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.comet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import to.etc.webapp.ajax.comet.CometContext;
import to.etc.webapp.ajax.comet.ContinuationImpl;

public class GenericCometServlet
extends HttpServlet {
    private static final int WAIT_TIMEOUT = 120000;
    private Class<? extends CometContext> m_contextClass;

    public void init() throws ServletException {
        super.init();
        try {
            System.out.println("GenericCometServlet: initializing");
            String cn = this.getServletConfig().getInitParameter("class");
            if (cn == null) {
                throw new UnavailableException("Missing servlet parameter 'class', which should indicate the class implementing CometContext to handle comet requests to this servlet");
            }
            Class<?> cl = null;
            try {
                cl = Class.forName(cn);
            }
            catch (Exception x) {
                throw new UnavailableException("The class '" + cn + " cannot be loaded: " + x);
            }
            if (!CometContext.class.isAssignableFrom(cl)) {
                throw new UnavailableException("The class '" + cn + "' does not implement " + CometContext.class.getName());
            }
            try {
                cl.newInstance();
            }
            catch (Exception x) {
                throw new UnavailableException("The class '" + cn + "' does not allow me to create instances: " + x);
            }
            this.m_contextClass = cl;
            System.out.println("GenericCometServlet: init has completed");
        }
        catch (ServletException x) {
            x.printStackTrace();
            throw x;
        }
        catch (RuntimeException x) {
            x.printStackTrace();
            throw x;
        }
    }

    protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.handle(arg0, arg1);
    }

    protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.handle(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ContinuationImpl ci = new ContinuationImpl();
        CometContext ctx = null;
        try {
            ctx = this.m_contextClass.newInstance();
            ctx.begin(this, req, ci);
        }
        catch (Exception x) {
            this.handleException(x);
            throw new RuntimeException(x);
        }
        long stime = System.currentTimeMillis();
        long etime = ci.getTimeout();
        if (etime < 0L || etime > 120000L) {
            etime = 120000L;
        }
        etime += stime;
        boolean timeout = true;
        while (etime > stime) {
            long wtime = etime - stime;
            ContinuationImpl continuationImpl = ci;
            synchronized (continuationImpl) {
                if (ci.hasCompleted()) {
                    timeout = false;
                    break;
                }
                try {
                    ci.wait(wtime);
                }
                catch (Exception x) {
                    break;
                }
            }
            stime = System.currentTimeMillis();
        }
        try {
            ctx.respond(res, timeout);
        }
        catch (Exception x) {
            this.handleException(x);
        }
    }

    protected void handleException(Exception x) throws ServletException, IOException {
        x.printStackTrace();
        if (x instanceof RuntimeException) {
            throw (RuntimeException)x;
        }
        if (x instanceof ServletException) {
            throw (ServletException)((Object)x);
        }
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        throw new ServletException(x.toString(), (Throwable)x);
    }

    public void destroy() {
        System.out.println("GenericCometServlet: destroy called");
        super.destroy();
    }
}

