/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.eventmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.webapp.ajax.eventmanager.AjaxEventFilter;
import to.etc.webapp.ajax.eventmanager.AjaxEventFilterFactory;
import to.etc.webapp.ajax.eventmanager.EventCometContext;
import to.etc.webapp.ajax.eventmanager.QueuedEvent;

public class AjaxEventManager {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxEventManager.class);
    private static final int MIN_LINGER = 300;
    private static final AjaxEventManager m_instance = new AjaxEventManager();
    private boolean m_initialized;
    private Timer m_timer = new Timer(true);
    private int m_nextMessageNumber = 1;
    private int m_firstMessageNumber = 1;
    private QueuedEvent[] m_eventQueue = new QueuedEvent[1024];
    private int m_qput_ix;
    private int m_qget_ix;
    private int m_qlength;
    private final long m_expiry = 60000L;
    private final int m_maxevents = 20;
    private final long m_browserTimeout = 20000L;
    private int m_key;
    private Map<String, Set<EventCometContext>> m_channelMap = new HashMap<String, Set<EventCometContext>>();
    private final Map<String, Set<AjaxEventFilterFactory>> m_eventFilters = new HashMap<String, Set<AjaxEventFilterFactory>>();
    private static final AjaxEventFilter[] NO_FILTERS = new AjaxEventFilter[0];

    public static AjaxEventManager getInstance() {
        AjaxEventManager ajaxEventManager = m_instance;
        synchronized (ajaxEventManager) {
            int tries = 5;
            while (tries-- > 0) {
                if (AjaxEventManager.m_instance.m_initialized) {
                    return m_instance;
                }
                System.out.println("AjaxEventManager: waiting for initialization");
                try {
                    m_instance.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new IllegalStateException("The Ajax Event Manager did not initialize in a reasonable amount of time");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        AjaxEventManager ajaxEventManager = m_instance;
        synchronized (ajaxEventManager) {
            if (AjaxEventManager.m_instance.m_initialized) {
                throw new IllegalStateException("Already initialized");
            }
            m_instance.init();
            AjaxEventManager.m_instance.m_initialized = true;
            m_instance.notifyAll();
        }
    }

    private void init() {
        this.m_key = (int)(System.currentTimeMillis() + System.nanoTime() & Integer.MAX_VALUE);
        this.m_nextMessageNumber = 1;
        this.m_firstMessageNumber = 1;
    }

    private synchronized QueuedEvent putEvent(String channel, Object data) {
        int id;
        long ts = System.currentTimeMillis();
        this.expire(ts - 60000L);
        if (this.m_qlength >= this.m_eventQueue.length) {
            int sz = this.m_eventQueue.length * 2;
            QueuedEvent[] ar = new QueuedEvent[sz];
            int elen = this.m_eventQueue.length - this.m_qget_ix;
            if (elen > 0) {
                System.arraycopy(this.m_eventQueue, this.m_qget_ix, ar, 0, elen);
            }
            System.arraycopy(this.m_eventQueue, 0, ar, elen, this.m_qput_ix);
            this.m_qget_ix = 0;
            this.m_qput_ix = this.m_qlength;
            this.m_eventQueue = ar;
        }
        ++this.m_qlength;
        if ((id = this.m_nextMessageNumber++) >= Integer.MAX_VALUE) {
            id = 1;
            this.m_nextMessageNumber = 1;
        }
        QueuedEvent e = new QueuedEvent(id, ts, channel, data);
        this.m_eventQueue[this.m_qput_ix++] = e;
        if (this.m_qput_ix >= this.m_eventQueue.length) {
            this.m_qput_ix = 0;
        }
        return e;
    }

    private synchronized List<QueuedEvent> getEventsSince(int startingeventid, int max, Set<String> channels) {
        this.expire(System.currentTimeMillis() - 60000L);
        if (startingeventid < this.m_firstMessageNumber || startingeventid >= this.m_nextMessageNumber) {
            return null;
        }
        int delta = startingeventid - this.m_firstMessageNumber;
        if (this.m_eventQueue == null) {
            throw new IllegalStateException("Eventqueue NULL??");
        }
        if (channels == null) {
            throw new IllegalStateException("Channels null????");
        }
        ArrayList<QueuedEvent> list = null;
        int ix = this.m_qget_ix + delta;
        if (ix >= this.m_eventQueue.length) {
            ix -= this.m_eventQueue.length;
        }
        int len = this.m_qlength - delta;
        while (len-- > 0) {
            QueuedEvent e;
            if ((e = this.m_eventQueue[ix++]) == null) {
                throw new IllegalStateException("NULL EVENT encountered??");
            }
            if (channels.contains(e.getChannel())) {
                if (list == null) {
                    list = new ArrayList<QueuedEvent>();
                }
                list.add(e);
                if (--max <= 0) break;
            }
            if (ix < this.m_eventQueue.length) continue;
            ix = 0;
        }
        return list;
    }

    private synchronized void expire(long ts) {
        if (this.m_eventQueue == null) {
            throw new IllegalStateException("Eventqueue NULL??");
        }
        while (this.m_qlength > 0) {
            QueuedEvent e = this.m_eventQueue[this.m_qget_ix];
            if (e == null) {
                throw new IllegalStateException("NULL EVENT encountered??");
            }
            if (e.getEventTS() > ts) {
                return;
            }
            ++this.m_qget_ix;
            if (this.m_qget_ix >= this.m_eventQueue.length) {
                this.m_qget_ix = 0;
            }
            --this.m_qlength;
            ++this.m_firstMessageNumber;
            if (this.m_firstMessageNumber < Integer.MAX_VALUE) continue;
            this.m_firstMessageNumber = 1;
        }
    }

    private synchronized void registerWaiting(EventCometContext ectx, long timeout) {
        Set<String> channels = ectx.getChannels();
        for (String ch : channels) {
            Set<EventCometContext> wset = this.m_channelMap.get(ch);
            if (wset == null) {
                wset = new HashSet<EventCometContext>();
                this.m_channelMap.put(ch, wset);
            }
            wset.add(ectx);
        }
        this.schedule(ectx, timeout);
    }

    private synchronized void schedule(final EventCometContext ectx, long timeout) {
        TimerTask tt = ectx.getTimerTask();
        if (tt != null) {
            tt.cancel();
        }
        if (timeout <= 0L) {
            timeout = 100L;
        }
        tt = new TimerTask(){

            @Override
            public void run() {
                AjaxEventManager.this.handleTimeout(ectx);
            }
        };
        ectx.setTimerTask(tt);
        this.m_timer.schedule(tt, timeout);
    }

    private synchronized void deregisterChannels(EventCometContext ectx) {
        Set<String> channels = ectx.getChannels();
        for (String ch : channels) {
            Set<EventCometContext> wset = this.m_channelMap.get(ch);
            if (wset == null) continue;
            wset.remove(ectx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTimeout(EventCometContext ectx) {
        boolean sendcompletion = false;
        AjaxEventManager ajaxEventManager = this;
        synchronized (ajaxEventManager) {
            if (ectx.hasCompleted()) {
                return;
            }
            int nextid = this.m_nextMessageNumber;
            if (ectx.getEventCount() == 0) {
                ectx.setBrowserTimeout(nextid);
            } else {
                ectx.setCompletedOK();
            }
            this.deregisterChannels(ectx);
            if (ectx.acceptForCompletion()) {
                sendcompletion = true;
            }
        }
        if (sendcompletion) {
            ectx.sendResponse();
        }
    }

    synchronized void removeWaiting(EventCometContext ectx) {
        TimerTask tt = ectx.getTimerTask();
        if (tt != null) {
            tt.cancel();
        }
        if (!ectx.hasCompleted()) {
            if (ectx.getEventCount() == 0) {
                ectx.setBrowserTimeout(this.m_nextMessageNumber);
            } else {
                ectx.setCompletedOK();
            }
        }
        this.deregisterChannels(ectx);
        ectx.waitForZeroLock();
    }

    /*
     * Exception decompiling
     */
    void registerWaiter(EventCometContext ectx, int nexteventid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized Set<AjaxEventFilterFactory> getEventFilters(String channel) {
        Set<AjaxEventFilterFactory> filterSet = this.m_eventFilters.get(channel);
        if (filterSet == null) {
            return null;
        }
        return new TreeSet<AjaxEventFilterFactory>(filterSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AjaxEventFilter[] createEventFilters(String channel) {
        Set<AjaxEventFilterFactory> fset = this.getEventFilters(channel);
        if (fset == null || fset.size() == 0) {
            return null;
        }
        AjaxEventFilter[] far = new AjaxEventFilter[fset.size()];
        boolean okay = false;
        try {
            int ix = 0;
            for (AjaxEventFilterFactory ff : fset) {
                far[ix++] = ff.createAjaxEventFilter();
            }
            okay = true;
            AjaxEventFilter[] ajaxEventFilterArray = far;
            return ajaxEventFilterArray;
        }
        finally {
            if (!okay) {
                this.releaseEventFilters(far);
            }
        }
    }

    private void releaseEventFilters(AjaxEventFilter[] far) {
        if (far == null) {
            return;
        }
        for (AjaxEventFilter ef : far) {
            try {
                if (ef == null) continue;
                ef.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public synchronized void registerEventFilter(String channel, AjaxEventFilterFactory ajaxEventFilterFactory) {
        Set<AjaxEventFilterFactory> wset = this.m_eventFilters.get(channel);
        if (wset == null) {
            wset = new HashSet<AjaxEventFilterFactory>();
            this.m_eventFilters.put(channel, wset);
        }
        wset.add(ajaxEventFilterFactory);
    }

    private Object filterEvent(AjaxEventFilter[] filters, EventCometContext ctx, Object res) {
        for (AjaxEventFilter ef : filters) {
            if (ef == null) continue;
            try {
                Object tres = ef.filterEvent(ctx, res);
                if (tres == null) {
                    throw new IllegalStateException("The event filter " + ef + " returned null!?!");
                }
                res = tres;
            }
            catch (Exception x) {
                LOG.error("Exception in AjaxEventFilter " + ef, (Throwable)x);
                x.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(String channel, Object data) {
        QueuedEvent e;
        ArrayList<EventCometContext> doset = new ArrayList<EventCometContext>();
        AjaxEventManager ajaxEventManager = this;
        synchronized (ajaxEventManager) {
            e = this.putEvent(channel, data);
            Set<EventCometContext> cset = this.m_channelMap.get(channel);
            if (cset == null) {
                return;
            }
            for (EventCometContext cc : cset) {
                if (!cc.lock()) continue;
                doset.add(cc);
            }
            if (doset.size() == 0) {
                return;
            }
        }
        Object[] results = new Object[doset.size()];
        AjaxEventFilter[] filters = null;
        try {
            filters = this.createEventFilters(channel);
            int j = doset.size();
            while (--j >= 0) {
                EventCometContext ctx = (EventCometContext)doset.get(j);
                Object res = data;
                if (filters != null) {
                    res = this.filterEvent(filters, ctx, res);
                }
                results[j] = res;
            }
        }
        finally {
            this.releaseEventFilters(filters);
            filters = null;
        }
        ArrayList<EventCometContext> clist = new ArrayList<EventCometContext>(doset.size());
        AjaxEventManager ajaxEventManager2 = this;
        synchronized (ajaxEventManager2) {
            int i = doset.size();
            while (--i >= 0) {
                EventCometContext ctx = (EventCometContext)doset.get(i);
                ctx.unlock();
                if (!ctx.hasCompleted()) {
                    if (!ctx.append(e.createCopy(results[i]))) {
                        throw new IllegalStateException("!? Programmer error - context does not accept event!?");
                    }
                    if (ctx.getEventCount() >= 20 || ctx.getLingerTime() < 300) {
                        ctx.setCompletedOK();
                        ctx.getTimerTask().cancel();
                        this.deregisterChannels(ctx);
                    } else if (!ctx.isLingering()) {
                        this.schedule(ctx, ctx.getLingerTime());
                    }
                }
                if (!ctx.acceptForCompletion()) continue;
                clist.add(ctx);
            }
        }
        for (EventCometContext ectx : clist) {
            ectx.sendResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.m_timer.cancel();
        this.m_timer = null;
        ArrayList<EventCometContext> list = new ArrayList<EventCometContext>();
        AjaxEventManager ajaxEventManager = this;
        synchronized (ajaxEventManager) {
            for (Set<EventCometContext> ctx : this.m_channelMap.values()) {
                list.addAll(ctx);
            }
            this.m_channelMap = null;
        }
        for (EventCometContext c : list) {
            try {
                c.sendResponse();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

