/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.eventmanager;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import to.etc.util.IndentWriter;
import to.etc.webapp.ajax.comet.CometContext;
import to.etc.webapp.ajax.comet.Continuation;
import to.etc.webapp.ajax.eventmanager.AjaxEventManager;
import to.etc.webapp.ajax.eventmanager.QueuedEvent;
import to.etc.webapp.ajax.renderer.JSONParser;
import to.etc.webapp.ajax.renderer.json.JSONRegistry;
import to.etc.webapp.ajax.renderer.json.JSONRenderer;
import to.etc.xml.XmlWriter;

public class EventCometContext
implements CometContext {
    static JSONRegistry m_registry = new JSONRegistry();
    private Continuation m_co;
    private String m_remoteUser;
    private Set<String> m_channels;
    private List<QueuedEvent> m_eventList;
    private int m_key;
    private int m_lingerTime = 1000;
    private TimerTask m_timerTask;
    private CompletionState m_completionState = CompletionState.csWAITING;
    private boolean m_lingering;
    private EventResult m_result;
    private int m_lockCount;
    private HttpServletRequest m_httpServletRequest;

    public HttpServletRequest getHttpServletRequest() {
        return this.m_httpServletRequest;
    }

    @Override
    public void begin(HttpServlet slet, HttpServletRequest req, Continuation cont) throws Exception {
        this.m_httpServletRequest = req;
        this.m_co = cont;
        String json = req.getParameter("json");
        if (json == null) {
            throw new ServletException("Missing servlet parameter 'json' containing the event subscription");
        }
        Object o = JSONParser.parseJSON(json);
        if (!(o instanceof Map)) {
            throw new ServletException("Expecting an 'object' as the top-level JSON element");
        }
        Map map = (Map)o;
        if ((o = map.get("key")) == null || !(o instanceof Number)) {
            throw new ServletException("Missing 'key' field");
        }
        int key = ((Number)o).intValue();
        o = map.get("nexteventid");
        if (o == null || !(o instanceof Number)) {
            throw new ServletException("Missing 'nexteventid' field");
        }
        int nexteventid = ((Number)o).intValue();
        o = map.get("lingertime");
        if (o != null) {
            if (!(o instanceof Number)) {
                throw new ServletException("'lingertime' must be an integer.");
            }
            this.m_lingerTime = ((Number)o).intValue();
        }
        if ((o = map.get("remoteUser")) == null && (o = req.getRemoteUser()) == null) {
            throw new ServletException("The COMET request does not contain the remoteUser field.");
        }
        if (!(o instanceof String)) {
            throw new ServletException("'remoteUser' must be a String.");
        }
        this.m_remoteUser = (String)o;
        HashSet<String> channels = new HashSet<String>();
        o = map.get("channels");
        if (o == null || !(o instanceof List)) {
            throw new ServletException("The 'channels' field must be an array of strings");
        }
        for (Object co : (List)o) {
            if (!(co instanceof String)) {
                throw new ServletException("The 'channels' field must be an array of strings");
            }
            channels.add((String)co);
        }
        if (channels.size() == 0) {
            throw new ServletException("The 'channels' field cannot be empty");
        }
        this.m_channels = channels;
        this.m_key = key;
        AjaxEventManager.getInstance().registerWaiter(this, nexteventid);
    }

    boolean lock() {
        if (this.m_completionState != CompletionState.csWAITING) {
            return false;
        }
        ++this.m_lockCount;
        return true;
    }

    void unlock() {
        if (this.m_lockCount <= 0) {
            throw new IllegalStateException("Bad lock count");
        }
        AjaxEventManager.getInstance().notifyAll();
        --this.m_lockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForZeroLock() {
        AjaxEventManager m;
        AjaxEventManager ajaxEventManager = m = AjaxEventManager.getInstance();
        synchronized (ajaxEventManager) {
            while (true) {
                if (this.m_lockCount < 0) {
                    throw new IllegalStateException("Lockcount < 0: object has been released!!");
                }
                if (this.m_lockCount == 0) {
                    this.m_lockCount = -1;
                    return;
                }
                try {
                    m.wait();
                }
                catch (InterruptedException x) {
                    return;
                }
            }
        }
    }

    @Override
    public void respond(HttpServletResponse resp, boolean timeout) throws Exception {
        if (timeout) {
            AjaxEventManager.getInstance().removeWaiting(this);
        }
        if (this.m_result == null) {
            throw new IllegalStateException("Activated but response is not defined!?");
        }
        this.renderJSON(resp, this.m_result);
    }

    private void renderJSON(HttpServletResponse response, Object res) throws Exception {
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        PrintWriter w = response.getWriter();
        XmlWriter xw = new XmlWriter((Writer)w);
        JSONRenderer xr = new JSONRenderer(m_registry, (IndentWriter)xw, true);
        xr.render(res);
    }

    void sendResponse() {
        this.m_co.resume();
    }

    void append(List<QueuedEvent> list) {
        if (this.m_eventList == null) {
            this.m_eventList = new ArrayList<QueuedEvent>(list);
        } else {
            this.m_eventList.addAll(list);
        }
    }

    boolean append(QueuedEvent e) {
        if (this.m_eventList == null) {
            this.m_eventList = new ArrayList<QueuedEvent>();
            this.m_eventList.add(e);
            return true;
        }
        if (this.m_eventList.size() == 0) {
            this.m_eventList.add(e);
            return true;
        }
        if (this.m_eventList.get(this.m_eventList.size() - 1).getEventID() >= e.getEventID()) {
            return false;
        }
        this.m_eventList.add(e);
        return true;
    }

    int getEventCount() {
        return this.m_eventList == null ? 0 : this.m_eventList.size();
    }

    boolean setKey(int key) {
        boolean wassame = key == this.m_key;
        this.m_key = key;
        return wassame;
    }

    Set<String> getChannels() {
        return this.m_channels;
    }

    void setRegistrationExpired(int nexteventid) {
        if (this.m_completionState != CompletionState.csWAITING) {
            throw new IllegalStateException("Completion state is alread " + (Object)((Object)this.m_completionState));
        }
        if (this.m_eventList != null && this.m_eventList.size() > 0) {
            throw new IllegalStateException("EXPIRING a context what HAS events pending!?!");
        }
        this.m_completionState = CompletionState.csBADKEY;
        this.m_result = new EventResult(this.m_key, nexteventid, "EXPIRED", null);
    }

    private void sendEvents(int nexteventid) {
        if (this.m_eventList == null) {
            throw new IllegalStateException("sendEvents() called without events present!?");
        }
        this.m_result = new EventResult(this.m_key, nexteventid, "EVENTS", this.m_eventList);
        this.m_eventList = null;
    }

    private void sendEvents() {
        if (this.m_eventList == null) {
            throw new IllegalStateException("sendEvents() called without events present!?");
        }
        this.sendEvents(this.m_eventList.get(this.m_eventList.size() - 1).getEventID() + 1);
    }

    int getLingerTime() {
        return this.m_lingerTime;
    }

    TimerTask getTimerTask() {
        return this.m_timerTask;
    }

    void setTimerTask(TimerTask timerTask) {
        this.m_timerTask = timerTask;
    }

    boolean isLingering() {
        return this.m_lingering;
    }

    void setLingering(boolean lingering) {
        this.m_lingering = lingering;
    }

    public String getRemoteUser() {
        return this.m_remoteUser;
    }

    void setCompletedOK() {
        if (this.m_completionState != CompletionState.csWAITING) {
            throw new IllegalStateException("The completion state is ALREADY set to " + (Object)((Object)this.m_completionState));
        }
        this.m_completionState = CompletionState.csOKAY;
        this.sendEvents();
    }

    void setBrowserTimeout(int nexteventid) {
        if (this.m_completionState != CompletionState.csWAITING) {
            throw new IllegalStateException("Programmer error: completion state is not WAITING but " + (Object)((Object)this.m_completionState));
        }
        this.m_completionState = CompletionState.csTIMEOUT;
        this.m_result = new EventResult(this.m_key, nexteventid, "TIMEOUT", null);
    }

    boolean hasCompleted() {
        return this.m_completionState != CompletionState.csWAITING;
    }

    boolean acceptForCompletion() {
        if (this.m_completionState == CompletionState.csWAITING || this.m_completionState == CompletionState.csFINISHED || this.m_lockCount > 0) {
            return false;
        }
        this.m_completionState = CompletionState.csFINISHED;
        return true;
    }

    public static class EventResult {
        private final String m_status;
        private final int m_key;
        private final int m_nexteventid;
        private final List<QueuedEvent> m_eventlist;

        public EventResult(int key, int nexteventid, String status, List<QueuedEvent> eventlist) {
            this.m_key = key;
            this.m_nexteventid = nexteventid;
            this.m_status = status;
            this.m_eventlist = eventlist;
        }

        public String getStatus() {
            return this.m_status;
        }

        public int getKey() {
            return this.m_key;
        }

        public int getNexteventid() {
            return this.m_nexteventid;
        }

        public List<QueuedEvent> getEventlist() {
            return this.m_eventlist;
        }
    }

    static enum CompletionState {
        csWAITING,
        csOKAY,
        csTIMEOUT,
        csBADKEY,
        csFINISHED;

    }
}

