/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import to.etc.util.StringTool;
import to.etc.webapp.ajax.renderer.ObjectRenderer;
import to.etc.webapp.ajax.renderer.RenderMethodException;

public class ClassMemberRenderer {
    public static final String INVALID = "(invalid)";
    private final Method m_method;
    private final String m_name;

    ClassMemberRenderer(Method m, String name) {
        this.m_method = m;
        this.m_name = name;
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getMemberValue(Object val) throws RenderMethodException {
        try {
            return this.m_method.invoke(val, (Object[])null);
        }
        catch (Exception x) {
            if (x instanceof InvocationTargetException && x.getCause() instanceof Exception) {
                x = (Exception)x.getCause();
            }
            throw new RenderMethodException(this.m_method, "Class member getter call '" + this.m_method.toString() + "' failed with " + StringTool.getExceptionMessage((Throwable)x), x);
        }
    }

    public int render(ObjectRenderer or, Object val, int count) throws Exception {
        Object retval = this.getMemberValue(val);
        if (retval == INVALID) {
            return count;
        }
        if (or.isKnownObject(retval)) {
            return count;
        }
        or.renderObjectBeforeItem(count, val, this.m_name, this.m_method.getReturnType());
        or.renderObjectMember(retval, this.m_name, this.m_method.getReturnType());
        or.renderObjectAfterItem(count, val, this.m_name, this.m_method.getReturnType());
        return count + 1;
    }
}

