/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import to.etc.lexer.ReaderTokenizerBase;
import to.etc.webapp.ajax.renderer.JSONParserException;

public class JSONParser
extends ReaderTokenizerBase {
    public JSONParser(Reader r) {
        super((Object)"JSON Source", r);
        this.setReturnNewline(false);
        this.setReturnWhitespace(false);
    }

    public Object parse() throws Exception {
        this.nextToken();
        return this.parseItem();
    }

    protected int scanString() throws IOException {
        int c;
        int qc = this.LA();
        this.accept();
        this.startToken();
        block9: while ((c = this.LA()) != qc) {
            if (c == -1) {
                throw new JSONParserException("Unexpected EOF in string constant");
            }
            if (c == 10) {
                throw new JSONParserException("Unexpected newline in string constant");
            }
            if (c == 92) {
                this.accept();
                c = this.LA();
                switch (c) {
                    default: {
                        throw new JSONParserException("Unexpected string escape sequence \\" + (char)c);
                    }
                    case 34: 
                    case 39: 
                    case 47: 
                    case 92: {
                        this.copy();
                        continue block9;
                    }
                    case 98: {
                        this.append('\b');
                        this.accept();
                        continue block9;
                    }
                    case 102: {
                        this.append('\f');
                        this.accept();
                        continue block9;
                    }
                    case 110: {
                        this.append('\n');
                        this.accept();
                        continue block9;
                    }
                    case 114: {
                        this.append('\r');
                        this.accept();
                        continue block9;
                    }
                    case 116: {
                        this.append('\t');
                        this.accept();
                        continue block9;
                    }
                    case 117: 
                }
                this.accept();
                int val = 0;
                for (int i = 0; i < 4; ++i) {
                    c = this.LA();
                    int d = Character.digit(c, 16);
                    if (d == -1) {
                        throw new JSONParserException("Invalid hex digit " + (char)c + "in string unicode escape sequence");
                    }
                    val = val * 16 + d;
                    this.accept();
                }
                this.append(val);
                continue;
            }
            this.copy();
        }
        this.accept();
        return -2;
    }

    public Object parseItem() throws Exception {
        int token = this.getLastToken();
        switch (token) {
            default: {
                throw new JSONParserException("Unexpected token '" + this.getCopied() + "' in input");
            }
            case 123: {
                return this.parseObject();
            }
            case 91: {
                return this.parseArray();
            }
            case -1: {
                return null;
            }
            case -5: {
                if (this.getCopied().equals("undefined") || this.getCopied().equals("null")) {
                    this.nextToken();
                    return null;
                }
                if (this.getCopied().equals("true")) {
                    this.nextToken();
                    return Boolean.TRUE;
                }
                if (this.getCopied().equals("false")) {
                    this.nextToken();
                    return Boolean.FALSE;
                }
                throw new JSONParserException("Unexpected identifier '" + this.getCopied() + "'");
            }
            case -4: {
                throw new JSONParserException("Unexpected IP address '" + this.getCopied() + "'");
            }
            case -3: {
                return this.parseNumber();
            }
            case -2: {
                String txt = this.getCopied();
                this.nextToken();
                return txt;
            }
            case 45: 
        }
        token = this.nextToken();
        if (token != -3) {
            throw new JSONParserException("Unexpected token '" + this.getCopied() + "' after '-' sign; expecting a number");
        }
        Number v = this.parseNumber();
        return -v.longValue();
    }

    private Number parseNumber() throws Exception {
        String copied = this.getCopied();
        Number res = copied.contains(".") || copied.contains("e") || copied.contains("E") ? (Number)Double.valueOf(copied) : (Number)Long.decode(copied);
        this.nextToken();
        return res;
    }

    private Object parseKey() throws Exception {
        int token = this.getLastToken();
        switch (token) {
            default: {
                throw new JSONParserException("Unexpected token '" + this.getCopied() + "' in input");
            }
            case 123: {
                throw new JSONParserException("An object cannot be the key of an object item");
            }
            case 91: {
                throw new JSONParserException("An array cannot be the key of an object item");
            }
            case -1: {
                throw new JSONParserException("Unexpected EOF while parsing an object key");
            }
            case -4: {
                throw new JSONParserException("Unexpected IP address '" + this.getCopied() + "' in input");
            }
            case -3: {
                return this.parseNumber();
            }
            case -5: 
            case -2: 
        }
        String txt = this.getCopied();
        this.nextToken();
        return txt;
    }

    private Object parseObject() throws Exception {
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        this.nextToken();
        while (true) {
            if (this.getLastToken() == 125) {
                this.nextToken();
                return res;
            }
            Object v = this.parseKey();
            if (!(v instanceof Number) && !(v instanceof String)) {
                throw new JSONParserException("Invalid 'key' object for object notation: " + v);
            }
            if (this.getLastToken() != 58) {
                throw new JSONParserException("Expecting a ':' after the key value");
            }
            this.nextToken();
            Object val = this.parseItem();
            if (null != res.put(v, val)) {
                throw new JSONParserException("Duplicate 'key' value: '" + v + "'");
            }
            if (this.getLastToken() == 125) {
                this.nextToken();
                return res;
            }
            if (this.getLastToken() != 44) {
                throw new JSONParserException("Expecting a ',' or a '}' after an object item:value pair, but I got an '" + this.getCopied() + "'");
            }
            this.nextToken();
        }
    }

    private Object parseArray() throws Exception {
        this.nextToken();
        ArrayList<Object> res = new ArrayList<Object>();
        while (true) {
            if (this.getLastToken() == 93) {
                this.nextToken();
                return res;
            }
            Object val = this.parseItem();
            res.add(val);
            if (this.getLastToken() == 93) {
                this.nextToken();
                return res;
            }
            if (this.getLastToken() != 44) {
                throw new JSONParserException("Expecting a ',' or a ']' after an array value, but I got an '" + this.getCopied() + "'");
            }
            this.nextToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseJSON(String in, Class<?> totype) throws Exception {
        StringReader r = new StringReader(in);
        try {
            Object object = JSONParser.parseJSON(r, totype);
            return object;
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Object parseJSON(Reader r, Class<?> totype) throws Exception {
        throw new IllegalStateException("Not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseJSON(String in) throws Exception {
        StringReader r = new StringReader(in);
        try {
            Object object = JSONParser.parseJSON(r);
            return object;
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Object parseJSON(Reader in) throws Exception {
        JSONParser p = new JSONParser(in);
        return p.parse();
    }

    public static void main(String[] args) {
        try {
            File src = new File("./test.json");
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(src), "utf-8");
            Object val = JSONParser.parseJSON(r);
            System.out.println("Parsed ok, result is " + val);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

