/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.util.IndentWriter;
import to.etc.util.StringTool;
import to.etc.webapp.ajax.renderer.ItemRenderer;
import to.etc.webapp.ajax.renderer.RenderRegistry;

public abstract class ObjectRenderer {
    private static Logger LOG = LoggerFactory.getLogger(ObjectRenderer.class);
    private final RenderRegistry m_registry;
    private final IndentWriter m_writer;
    private final Set<Object> m_parentSet = new HashSet<Object>();
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public ObjectRenderer(RenderRegistry r, IndentWriter w) {
        this.m_registry = r;
        this.m_writer = w;
    }

    public final IndentWriter getWriter() {
        return this.m_writer;
    }

    public final RenderRegistry getRegistry() {
        return this.m_registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(Object o) throws Exception {
        try {
            long ts = System.nanoTime();
            this.renderRoot(o);
            ts = System.nanoTime() - ts;
            LOG.debug("renderer completed in " + StringTool.strNanoTime((long)ts));
        }
        finally {
            this.m_parentSet.clear();
        }
    }

    protected void renderRoot(Object root) throws Exception {
        this.renderSub(root);
    }

    protected boolean isKnownObject(Object o) {
        return this.m_parentSet.contains(o);
    }

    protected void renderSub(Object o) throws Exception {
        if (LOG.isDebugEnabled() && o != null) {
            LOG.debug("sub: type=" + o.getClass().getCanonicalName() + ": " + o);
        }
        if (this.m_parentSet.contains(o)) {
            return;
        }
        this.m_parentSet.add(o);
        this.renderPrimitive(o);
        this.m_parentSet.remove(o);
    }

    private void renderPrimitive(Object o) throws Exception {
        Class<?> cl = o == null ? null : o.getClass();
        ItemRenderer ir = this.m_registry.makeRenderer(cl);
        ir.render(this, o);
    }

    public void print(byte[] bar) throws IOException {
        int len = bar.length;
        if (len == 0) {
            return;
        }
        char[] buf = new char[128];
        int ix = 0;
        int off = 0;
        while (ix < len) {
            if (off >= 128) {
                this.getWriter().write(buf);
                off = 0;
            }
            byte v = bar[ix++];
            int v1 = v & 0xF;
            buf[off++] = HEX[v1];
            v1 = v >> 4 & 0xF;
            buf[off++] = HEX[v1];
        }
        if (off > 0) {
            this.getWriter().write(buf, 0, off);
        }
    }

    @Deprecated
    public void renderListStart(Collection<?> l, String name) throws Exception {
    }

    @Deprecated
    public void renderListEnd(Collection<?> l, String name) throws Exception {
    }

    public void renderArrayStart(Object l) throws Exception {
    }

    public void renderArrayEnd(Object l) throws Exception {
    }

    public void renderMapStart(Map<?, ?> l) throws Exception {
    }

    public void renderMapEnd(Map<?, ?> l) throws Exception {
    }

    public void renderMapEntry(Object key, Object value, int itemnr, int maxitemnr) throws Exception {
    }

    public abstract void renderObjectStart(Object var1) throws Exception;

    public abstract void renderObjectEnd(Object var1) throws Exception;

    protected void renderArrayElement(Object o, Class<?> declaredType, int ix) throws Exception {
        this.renderSub(o);
    }

    protected void renderObjectMember(Object o, String name, Class<?> declaredType) throws Exception {
        this.renderSub(o);
    }

    protected void renderObjectBeforeItem(int count, Object o, String name, Class<?> declaredType) throws Exception {
    }

    protected void renderObjectAfterItem(int count, Object o, String name, Class<?> declaredType) throws Exception {
    }
}

