/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import to.etc.webapp.ajax.renderer.ClassMemberRenderer;
import to.etc.webapp.ajax.renderer.ClassRenderer;
import to.etc.webapp.ajax.renderer.ItemRenderer;
import to.etc.webapp.ajax.renderer.ObjectRenderer;
import to.etc.webapp.ajax.renderer.Unrenderable;

public abstract class RenderRegistry {
    private final Map<Class<?>, ItemRenderer> m_map = new HashMap();
    private final List<FixPair> m_fixedList = new ArrayList<FixPair>();
    private final Set<String> m_ignoredMethodSet = new HashSet<String>();
    private final Set<Class<?>> m_ignoredTypeSet = new HashSet();
    private final Set<String> m_ignoredPackageSet = new HashSet<String>();
    private final Map<Class<?>, ItemRenderer> m_arrayRendererMap = new HashMap();
    private static final ItemRenderer ARRAYRENDERER = new ItemRenderer(){

        @Override
        public void render(ObjectRenderer or, Object val) throws Exception {
            Class<?> dt = val.getClass().getComponentType();
            Object[] l = (Object[])val;
            or.renderArrayStart(l);
            int ix = 0;
            for (Object o : l) {
                or.renderArrayElement(o, dt, ix++);
            }
            or.renderArrayEnd(l);
        }
    };
    private static final ItemRenderer PRIMITIVE_ARRAYRENDERER = new ItemRenderer(){

        @Override
        public void render(ObjectRenderer or, Object val) throws Exception {
            Class<?> dt = val.getClass().getComponentType();
            or.renderArrayStart(val);
            int len = Array.getLength(val);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(val, i);
                or.renderArrayElement(o, dt, i);
            }
            or.renderArrayEnd(val);
        }
    };

    public ItemRenderer makePrimitiveArrayRenderer(Class<?> cl) {
        ItemRenderer ir = this.m_arrayRendererMap.get(cl.getComponentType());
        if (ir != null) {
            return ir;
        }
        return PRIMITIVE_ARRAYRENDERER;
    }

    public RenderRegistry() {
        this.addIgnoredMethod("getClass");
        this.addIgnoredMethod("hashCode");
        this.addIgnoredMethod("getCallbacks");
        this.addIgnoredType(Void.TYPE);
        this.addIgnoredType(Class.class);
        this.addIgnoredType(Class[].class);
        this.addIgnoredPackage("org.hibernate.");
        this.registerBase(Collection.class, new ItemRenderer(){

            @Override
            public void render(ObjectRenderer or, Object val) throws Exception {
                Collection l = (Collection)val;
                or.renderArrayStart(l);
                int ix = 0;
                for (Object o : l) {
                    or.renderArrayElement(o, Object.class, ix++);
                }
                or.renderArrayEnd(l);
            }
        });
        this.registerBase(Map.class, new ItemRenderer(){

            @Override
            public void render(ObjectRenderer or, Object val) throws Exception {
                Map m = (Map)val;
                or.renderMapStart(m);
                int size = m.size();
                int count = 0;
                for (Map.Entry me : m.entrySet()) {
                    or.renderMapEntry(me.getKey(), me.getValue(), count, size);
                    ++count;
                }
                or.renderMapEnd(m);
            }
        });
    }

    public synchronized ItemRenderer findRenderer(Class<?> cl) {
        return this.m_map.get(cl);
    }

    public synchronized void register(Class<?> cl, ItemRenderer r) {
        this.m_map.put(cl, r);
    }

    public synchronized void registerBase(Class<?> bc, ItemRenderer r) {
        this.m_fixedList.add(new FixPair(bc, r));
    }

    public synchronized void addIgnoredMethod(String name) {
        this.m_ignoredMethodSet.add(name);
    }

    public synchronized void addIgnoredPackage(String name) {
        this.m_ignoredPackageSet.add(name);
    }

    public synchronized void addIgnoredType(Class<?> cl) {
        this.m_ignoredTypeSet.add(cl);
    }

    public synchronized void addArrayRenderer(Class<?> primitive, ItemRenderer r) {
        this.m_arrayRendererMap.put(primitive, r);
    }

    public synchronized boolean isIgnoredType(Class<?> c) {
        for (Class<?> tcl : this.m_ignoredTypeSet) {
            if (!tcl.isAssignableFrom(c)) continue;
            return true;
        }
        String cn = c.getName();
        for (String ign : this.m_ignoredPackageSet) {
            if (!cn.startsWith(ign)) continue;
            return true;
        }
        return false;
    }

    private synchronized ItemRenderer findFixed(Class<?> bc) {
        for (FixPair p : this.m_fixedList) {
            if (!p.getBaseclass().isAssignableFrom(bc)) continue;
            return p.getRenderer();
        }
        return null;
    }

    public synchronized ItemRenderer makeRenderer(Class<?> cl) {
        ItemRenderer ir = this.m_map.get(cl);
        if (ir != null) {
            return ir;
        }
        if (cl.isArray()) {
            if (!cl.getComponentType().isPrimitive()) {
                return ARRAYRENDERER;
            }
            return this.makePrimitiveArrayRenderer(cl);
        }
        ir = this.findFixed(cl);
        if (ir == null) {
            ir = this.makeClassRenderer(cl);
        }
        this.m_map.put(cl, ir);
        return ir;
    }

    protected ItemRenderer makeClassRenderer(Class<?> cl) {
        Method[] ar;
        ArrayList<ClassMemberRenderer> ml = new ArrayList<ClassMemberRenderer>();
        for (Method m : ar = cl.getMethods()) {
            String name;
            int mod;
            if (m.isAnnotationPresent(Unrenderable.class) || !Modifier.isPublic(mod = m.getModifiers()) || Modifier.isStatic(mod) || m.getParameterTypes().length != 0 || this.m_ignoredMethodSet.contains(name = m.getName())) continue;
            int nlen = name.length();
            int slen = 0;
            if (nlen > 3 && name.startsWith("get")) {
                slen = 3;
            } else if (nlen > 3 && name.startsWith("has")) {
                slen = 3;
            } else {
                if (nlen <= 2 || !name.startsWith("is")) continue;
                slen = 2;
            }
            Class<?> rt = m.getReturnType();
            if (this.isIgnoredType(rt)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(m.getName(), slen, m.getName().length());
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            ml.add(new ClassMemberRenderer(m, sb.toString()));
        }
        ClassRenderer cr = new ClassRenderer(ml.toArray(new ClassMemberRenderer[ml.size()]));
        return cr;
    }

    private static class FixPair {
        private final Class<?> m_baseclass;
        private final ItemRenderer m_renderer;

        FixPair(Class<?> cl, ItemRenderer r) {
            this.m_baseclass = cl;
            this.m_renderer = r;
        }

        public Class<?> getBaseclass() {
            return this.m_baseclass;
        }

        public ItemRenderer getRenderer() {
            return this.m_renderer;
        }
    }
}

