/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer.json;

import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import to.etc.util.StringTool;
import to.etc.webapp.ajax.renderer.RenderRegistry;
import to.etc.webapp.ajax.renderer.json.JSONArrayRenderer;
import to.etc.webapp.ajax.renderer.json.JSONItemRenderer;
import to.etc.webapp.ajax.renderer.json.JSONRenderer;

public class JSONRegistry
extends RenderRegistry {
    public JSONRegistry() {
        this.register(null, new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer r, Object val) throws Exception {
                r.getWriter().print("null");
            }
        });
        this.addArrayRenderer(Integer.TYPE, new JSONArrayRenderer(30){

            @Override
            public void render(JSONRenderer r, Object val, int ix) throws Exception {
                int v = Array.getInt(val, ix);
                r.printInt(v);
            }
        });
        this.addArrayRenderer(Byte.TYPE, new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer r, Object val) throws Exception {
                r.print((byte[])val);
            }
        });
        JSONItemRenderer r = new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer rr, Object val) throws Exception {
                Number n = (Number)val;
                rr.getWriter().print(n.toString());
            }
        };
        this.register(Integer.class, r);
        this.register(Integer.TYPE, r);
        this.register(Long.class, r);
        this.register(Long.TYPE, r);
        this.register(Double.class, r);
        this.register(Double.TYPE, r);
        r = new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer rr, Object val) throws Exception {
                Boolean v = (Boolean)val;
                rr.getWriter().print(v.toString());
            }
        };
        this.register(Boolean.TYPE, r);
        this.register(Boolean.class, r);
        this.register(String.class, new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer rd, Object val) throws Exception {
                StringTool.strToJavascriptString((Appendable)rd.getWriter(), (String)((String)val), (boolean)false);
            }
        });
        this.registerBase(Date.class, new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer rr, Object val) throws Exception {
                rr.renderDate((Date)val);
            }
        });
        this.registerBase(Calendar.class, new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer rr, Object val) throws Exception {
                rr.renderDate(((Calendar)val).getTime());
            }
        });
        this.registerBase(Enum.class, new JSONItemRenderer(){

            @Override
            public void render(JSONRenderer rd, Object val) throws Exception {
                Enum e = (Enum)val;
                StringTool.strToJavascriptString((Appendable)rd.getWriter(), (String)e.toString(), (boolean)false);
            }
        });
    }
}

