/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer.json;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import to.etc.util.IndentWriter;
import to.etc.webapp.ajax.renderer.ObjectRenderer;
import to.etc.webapp.ajax.renderer.json.JSONRegistry;

public class JSONRenderer
extends ObjectRenderer {
    private final boolean m_advanced;

    public JSONRenderer(JSONRegistry r, IndentWriter w, boolean advanced) {
        super(r, w);
        this.m_advanced = advanced;
    }

    @Override
    protected void renderRoot(Object root) throws Exception {
        super.renderRoot(root);
    }

    @Override
    public void renderObjectStart(Object o) throws Exception {
        IndentWriter w = this.getWriter();
        w.println("{");
        w.inc();
    }

    @Override
    public void renderObjectEnd(Object o) throws Exception {
        IndentWriter w = this.getWriter();
        w.forceNewline();
        w.dec();
        w.print("}");
    }

    @Override
    protected void renderObjectBeforeItem(int count, Object o, String name, Class<?> declaredType) throws Exception {
        if (count != 0) {
            this.getWriter().println(",");
        }
    }

    @Override
    public void renderArrayStart(Object ar) throws Exception {
        this.getWriter().println("[");
        this.getWriter().inc();
    }

    @Override
    public void renderArrayEnd(Object ar) throws Exception {
        this.getWriter().dec();
        this.getWriter().print("]");
    }

    @Override
    protected void renderArrayElement(Object o, Class<?> declaredType, int ix) throws Exception {
        if (ix > 0) {
            this.getWriter().print(",");
        }
        if (this.isKnownObject(o)) {
            this.getWriter().println("null /*was duplicate object ref*/");
        } else {
            this.renderSub(o);
        }
    }

    @Override
    public void renderMapStart(Map<?, ?> l) throws Exception {
        this.getWriter().print("{\n");
        this.getWriter().inc();
    }

    @Override
    public void renderMapEnd(Map<?, ?> l) throws Exception {
        this.getWriter().dec();
        this.getWriter().print("}");
    }

    @Override
    public void renderMapEntry(Object key, Object value, int itemnr, int maxitemnr) throws Exception {
        if (key instanceof String && JSONRenderer.isReservedWord((String)key)) {
            key = "_" + key;
        }
        this.renderSub(key);
        this.getWriter().print(": ");
        this.renderSub(value);
        if (itemnr + 1 < maxitemnr) {
            this.getWriter().print(",");
        }
    }

    private static boolean isReservedWord(String k) {
        return k.equals("function");
    }

    public void printInt(int i) throws IOException {
        this.getWriter().print(Integer.toString(i));
    }

    @Override
    protected void renderObjectMember(Object o, String name, Class<?> declaredType) throws Exception {
        IndentWriter w = this.getWriter();
        if (JSONRenderer.isReservedWord(name)) {
            name = "_" + name;
        }
        w.print(name);
        w.print(": ");
        this.renderSub(o);
    }

    public void renderDate(Date dt) throws Exception {
        if (!this.m_advanced) {
            this.getWriter().print(Long.toString(dt.getTime()));
            return;
        }
        this.getWriter().print("new Date(");
        this.getWriter().print(Long.toString(dt.getTime()));
        this.getWriter().print(")");
    }
}

