/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import to.etc.webapp.ajax.renderer.StructuredWriter;
import to.etc.webapp.ajax.renderer.json.JSONRenderer;

public class JSONStructuredWriter
extends StructuredWriter {
    private static final byte REC = 1;
    private static final byte LIST = 2;
    private int m_lvl = 0;
    private final byte[] m_type = new byte[50];
    private final JSONRenderer m_r;

    public JSONStructuredWriter(JSONRenderer r) {
        super((Writer)r.getWriter());
        this.m_r = r;
    }

    @Override
    public void end() throws IOException {
        if (this.m_lvl <= 0) {
            throw new IllegalStateException("Underflow.");
        }
        byte type = this.m_type[this.m_lvl--];
        switch (type) {
            case 2: {
                this.m_r.getWriter().dec();
                this.m_r.getWriter().forceNewline();
                this.append("],");
                break;
            }
            case 1: {
                this.m_r.getWriter().dec();
                this.m_r.getWriter().forceNewline();
                this.append("},");
            }
        }
    }

    @Override
    public void field(String name, String value) throws Exception {
        this.m_r.getWriter().forceNewline();
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.m_r.render(name);
        this.append(':');
        this.m_r.render(value);
        this.append(",\n");
    }

    @Override
    public void field(String name, boolean value) throws Exception {
        this.m_r.getWriter().forceNewline();
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.m_r.render(name);
        this.append(':');
        this.append(value ? "true" : "false");
        this.append(",\n");
    }

    @Override
    public void field(String name, Date value) throws Exception {
        this.m_r.getWriter().forceNewline();
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.m_r.render(name);
        this.append(':');
        this.m_r.render(value);
        this.append(",\n");
    }

    @Override
    public void field(String name, Number value) throws Exception {
        this.m_r.getWriter().forceNewline();
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.m_r.render(name);
        this.append(':');
        this.m_r.render(value);
        this.append(",\n");
    }

    @Override
    public void list(String name) throws Exception {
        byte type = this.m_type[this.m_lvl];
        if (type == 1) {
            this.m_r.render(name);
            this.append(": [\n");
        } else {
            this.append("[\n");
        }
        this.m_r.getWriter().inc();
        this.m_type[++this.m_lvl] = 2;
    }

    @Override
    public void record(String name) throws Exception {
        byte type = this.m_type[this.m_lvl];
        if (type == 1) {
            this.m_r.render(name);
            this.append(": {\n");
        } else {
            this.append("{\n");
        }
        this.m_r.getWriter().inc();
        this.m_type[++this.m_lvl] = 1;
    }

    @Override
    public void close() throws IOException {
        while (this.m_lvl > 0) {
            byte type = this.m_type[this.m_lvl--];
            switch (type) {
                case 2: {
                    this.append("\n]");
                    this.m_r.getWriter().dec();
                    break;
                }
                case 1: {
                    this.append("\n}");
                    this.m_r.getWriter().dec();
                }
            }
        }
        this.append("\n");
    }

    @Override
    public void flush() throws IOException {
    }
}

