/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import to.etc.webapp.ajax.renderer.StructuredWriter;
import to.etc.webapp.ajax.renderer.xml.XmlRenderer;
import to.etc.xml.XmlWriter;

public class XMLStructuredWriter
extends StructuredWriter {
    private static final byte REC = 1;
    private static final byte LIST = 2;
    private int m_lvl = 0;
    private final byte[] m_type = new byte[50];
    private final XmlRenderer m_r;

    public XMLStructuredWriter(XmlRenderer r) {
        super((Writer)r.getWriter());
        this.m_r = r;
    }

    public XmlWriter xw() {
        return this.m_r.xw();
    }

    @Override
    public void end() throws IOException {
        if (this.m_lvl <= 0) {
            throw new IllegalStateException("Underflow.");
        }
        byte type = this.m_type[this.m_lvl--];
        switch (type) {
            case 1: 
            case 2: {
                this.xw().tagendnl();
            }
        }
    }

    @Override
    public void field(String name, String value) throws Exception {
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.xw().tagfull(name, value);
    }

    @Override
    public void field(String name, boolean value) throws Exception {
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.xw().tagfull(name, value);
    }

    @Override
    public void field(String name, Date value) throws Exception {
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.xw().tagfull(name, value);
    }

    @Override
    public void field(String name, Number value) throws Exception {
        byte type = this.m_type[this.m_lvl];
        if (type != 1) {
            throw new IllegalStateException("A field is valid in a record only (field=" + name + ", value=" + value + ")");
        }
        this.xw().tagfull(name, value);
    }

    @Override
    public void list(String name) throws Exception {
        this.xw().tag(name);
        this.m_type[++this.m_lvl] = 2;
    }

    @Override
    public void record(String name) throws Exception {
        this.xw().tag(name);
        this.m_type[++this.m_lvl] = 1;
    }

    @Override
    public void close() throws IOException {
        while (this.m_lvl > 0) {
            this.end();
        }
    }

    @Override
    public void flush() throws IOException {
    }
}

