/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer.xml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import to.etc.webapp.ajax.renderer.RenderRegistry;
import to.etc.webapp.ajax.renderer.xml.TostringRenderer;
import to.etc.webapp.ajax.renderer.xml.XmlItemRenderer;
import to.etc.webapp.ajax.renderer.xml.XmlRenderer;
import to.etc.xml.DomTools;

public class XmlRegistry
extends RenderRegistry {
    private final Map<Class<?>, String> m_xmlTypeMap = new HashMap();

    public XmlRegistry() {
        this.register(null, new XmlItemRenderer(){

            @Override
            public void render(XmlRenderer r, Object val) throws Exception {
                r.xw().tagonly("null", new String[0]);
            }
        });
        TostringRenderer r = new TostringRenderer();
        this.register(Integer.class, r);
        this.register(Integer.TYPE, r);
        this.register(String.class, r);
        this.register(Long.class, r);
        this.register(Long.TYPE, r);
        this.register(Double.class, r);
        this.register(Double.TYPE, r);
        this.register(Float.class, r);
        this.register(Float.TYPE, r);
        this.register(Short.class, r);
        this.register(Short.TYPE, r);
        this.register(Byte.class, r);
        this.register(Byte.TYPE, r);
        this.register(Boolean.class, r);
        this.register(Boolean.TYPE, r);
        this.registerBase(Date.class, new XmlItemRenderer(){

            @Override
            public void render(XmlRenderer rr, Object val) throws Exception {
                rr.xw().cdata(DomTools.dateEncode((Date)((Date)val)));
            }
        });
        this.registerType(Boolean.class, "xsi:boolean");
        this.registerType(Boolean.TYPE, "xsi:boolean");
        this.registerType(Integer.class, "xsi:int");
        this.registerType(Integer.TYPE, "xsi:int");
        this.registerType(Long.class, "xsi:int");
        this.registerType(Long.TYPE, "xsi:int");
        this.registerType(Short.class, "xsi:int");
        this.registerType(Short.TYPE, "xsi:int");
        this.registerType(Double.class, "xsi:double");
        this.registerType(Double.TYPE, "xsi:double");
        this.registerType(Float.class, "xsi:float");
        this.registerType(Float.TYPE, "xsi:float");
        this.registerType(BigDecimal.class, "xsi:decimal");
        this.registerType(BigInteger.class, "xsi:decimal");
        this.registerType(BigDecimal.class, "xsi:decimal");
        this.registerType(String.class, "xsi:string");
    }

    public synchronized void registerType(Class<?> cl, String name) {
        this.m_xmlTypeMap.put(cl, name);
    }

    public synchronized String findType(Class<?> cl) {
        String type;
        Class<?>[] ifes = cl.getInterfaces();
        if (ifes.length > 0) {
            for (Class<?> ifa : ifes) {
                type = this.m_xmlTypeMap.get(ifa);
                if (type == null) continue;
                return type;
            }
        }
        for (cl = cl.getSuperclass(); cl != null; cl = cl.getSuperclass()) {
            type = this.m_xmlTypeMap.get(cl);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public synchronized String getType(Class<?> cl) {
        String type = this.m_xmlTypeMap.get(cl);
        if (type != null) {
            return type;
        }
        type = this.findType(cl);
        if (type == null) {
            if (cl.isArray()) {
                type = "xsi:list";
            } else if (Collection.class.isAssignableFrom(cl)) {
                type = "xsi:list";
            } else if (Map.class.isAssignableFrom(cl)) {
                type = "xsi:map";
            }
        }
        if (type == null) {
            type = cl.getCanonicalName();
            int pos = type.lastIndexOf(46);
            if (pos != -1) {
                type = type.substring(pos + 1);
            }
            type = "java:" + type;
            this.m_xmlTypeMap.put(cl, type);
        }
        return type;
    }
}

