/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.ajax.renderer.xml;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import to.etc.util.IndentWriter;
import to.etc.webapp.ajax.renderer.ObjectRenderer;
import to.etc.webapp.ajax.renderer.xml.XmlRegistry;
import to.etc.xml.XmlWriter;

public class XmlRenderer
extends ObjectRenderer {
    public XmlRenderer(XmlRegistry r, XmlWriter w) {
        super(r, (IndentWriter)w);
    }

    public XmlWriter xw() {
        return (XmlWriter)this.getWriter();
    }

    @Override
    protected void renderRoot(Object root) throws Exception {
        this.xw().println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        if (root == null) {
            this.xw().tagnl("result", new String[0]);
        } else {
            this.xw().tagnl("result", new String[]{"type", this.getTypeName(root.getClass())});
        }
        super.renderRoot(root);
        this.xw().tagendnl();
    }

    public void xmlTag(String name, Class<?> type, String val) throws IOException {
        this.xmlTag(type, name);
        this.xw().cdata(val);
        this.xw().tagendnl();
    }

    public void xmlFullTag(String name, String type, String val) throws IOException {
        XmlWriter w = this.xw();
        w.tag(name, new String[]{"type", type});
        this.xw().cdata(val);
        this.xw().tagendnl();
    }

    public String getTypeName(Class<?> type) {
        if (type == null) {
            return null;
        }
        return ((XmlRegistry)this.getRegistry()).getType(type);
    }

    public void xmlTag(Class<?> type, String name) throws IOException {
        String tyname;
        XmlWriter w = this.xw();
        if (type != null && (tyname = this.getTypeName(type)) != null) {
            w.tag(name, new String[]{"type", tyname});
            return;
        }
        w.tag(name, ">");
    }

    @Override
    public void renderObjectEnd(Object o) throws Exception {
    }

    @Override
    public void renderObjectStart(Object o) throws Exception {
        this.xw().forceNewline();
    }

    @Override
    protected void renderObjectMember(Object o, String name, Class<?> declaredType) throws Exception {
        Class<?> type = o == null ? declaredType : o.getClass();
        this.xmlTag(type, name);
        this.renderSub(o);
        this.xw().tagendnl();
    }

    @Override
    public void renderListStart(Collection<?> l, String name) throws Exception {
        this.xw().tagnl(name, new String[]{"type", "xsi:list"});
    }

    @Override
    public void renderListEnd(Collection<?> l, String name) throws Exception {
        this.xw().tagendnl();
    }

    @Override
    public void renderArrayStart(Object ar) throws Exception {
    }

    @Override
    public void renderArrayEnd(Object ar) throws Exception {
    }

    @Override
    protected void renderArrayElement(Object o, Class<?> declaredType, int ix) throws Exception {
        Class<?> type = o == null ? declaredType : o.getClass();
        this.xw().forceNewline();
        this.xmlTag(type, "item");
        this.renderSub(o);
        this.xw().tagendnl();
    }

    @Override
    public void renderMapStart(Map<?, ?> l) throws Exception {
    }

    @Override
    public void renderMapEnd(Map<?, ?> l) throws Exception {
    }

    @Override
    public void renderMapEntry(Object key, Object value, int itemnr, int maxitemnr) throws Exception {
        this.xw().tagnl("item", new String[0]);
        this.xmlTag(key.getClass(), "key");
        this.renderSub(key);
        this.xw().tagendnl();
        this.xmlTag(value == null ? null : value.getClass(), "value");
        this.renderSub(value);
        this.xw().tagendnl();
        this.xw().tagendnl();
    }
}

