/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.core;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import to.etc.util.FileTool;
import to.etc.util.StringTool;

public final class ServerTools {
    private static final String BASECODES = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$_";
    private static String m_myhostname;
    private static Properties m_mimemap_p;
    private static HashMap<String, String> m_mimestr_ht;
    private static long m_us_count;
    private static int m_us_ts;

    private ServerTools() {
    }

    public static File findConfigFileByName(ServletContext ctx, String basename) throws Exception {
        String p;
        File f = new File(basename);
        if (f.exists()) {
            return f;
        }
        int fix = FileTool.findFilenameExtension((String)basename);
        if (fix == -1 && (f = new File(basename = basename + ".properties")).exists()) {
            return f;
        }
        if (ctx != null && (f = new File(p = ctx.getRealPath("/WEB-INF/" + basename))).exists()) {
            return f;
        }
        f = StringTool.findFileOnEnv((String)basename, (String)"java.class.path");
        return f;
    }

    public static synchronized String getMyHostname() {
        if (m_myhostname != null) {
            return m_myhostname;
        }
        try {
            InetAddress ad = InetAddress.getLocalHost();
            m_myhostname = ad.getHostName();
        }
        catch (Exception x) {
            m_myhostname = "unknown.hostname";
        }
        return m_myhostname;
    }

    public static synchronized String getMimeString(String mime) {
        ServerTools.initMimeMap();
        mime = mime.toLowerCase();
        String r = m_mimestr_ht.get(mime);
        if (r != null) {
            return r;
        }
        m_mimestr_ht.put(mime, mime);
        return mime;
    }

    public static String getExtMimeType(String ext) {
        ServerTools.initMimeMap();
        return m_mimemap_p.getProperty(ext.toLowerCase());
    }

    public static String getMimeType(String fn) {
        ServerTools.initMimeMap();
        int xi = fn.lastIndexOf(46);
        if (xi == -1) {
            return null;
        }
        String ext = fn.substring(xi + 1).toLowerCase();
        return m_mimemap_p.getProperty(ext);
    }

    public static String getMimeExtension(String mimetype) {
        for (Map.Entry<Object, Object> me : m_mimemap_p.entrySet()) {
            if (!mimetype.equalsIgnoreCase((String)me.getValue())) continue;
            return (String)me.getKey();
        }
        return null;
    }

    public static synchronized void addMime(String ext, String mime) {
        ServerTools.initMimeMap();
        m_mimemap_p.setProperty(ext, mime);
    }

    public static synchronized void initMimeMap() {
        if (m_mimemap_p != null) {
            return;
        }
        String[] premimes = new String[]{"aif", "audio/x-aiff", "aiff", "audio/x-aiff", "aifc", "audio/x-aiff", "ai", "application/postscript", "au", "audio/basic", "asc", "text/plain", "avi", "video/x-msvideo", "bin", "application/octet-stream", "bcpio", "application/x-bcpio", "bmp", "image/bmp", "cab", "application/x-cabinet", "class", "application/octet-stream", "cpt", "application/mac-compactpro", "css", "text/css", "cpio", "application/x-cpio", "csh", "application/x-csh", "cdf", "application/x-netcdf", "dms", "application/octet-stream", "doc", "application/msword", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "dcr", "application/x-director", "dir", "application/x-director", "dxr", "application/x-director", "dvi", "application/x-dvi", "dwt", "application/x-dreamweaver-tpl", "dwf", "application/x-dwf", "exe", "application/octet-stream", "eps", "application/postscript", "etx", "text/x-setext", "fla", "application/x-shockwave-flash", "gtar", "application/x-gtar", "gif", "image/gif", "gz", "application/octet-stream", "hqx", "application/mac-binhex40", "html", "text/html", "htm", "text/html", "hdf", "application/x-hdf", "ief", "image/ief", "ice", "x-conference/x-cooltalk", "ico", "image/x-icon", "js", "application/x-javascript", "jpeg", "image/jpeg", "jpg", "image/jpeg", "jpe", "image/jpeg", "kar", "audio/midi", "latex", "application/x-latex", "lha", "application/octet-stream", "lhz", "application/octet-stream", "mid", "audio/midi", "mpeg", "video/mpeg", "mpg", "video/mpeg", "mpe", "video/mpeg", "mov", "video/quicktime", "movie", "video/x-sgi-movie", "mpga", "audio/mpeg", "mp2", "audio/mpeg", "mp3", "audio/mpeg", "man", "application/x-troff-man", "me", "application/x-troff-me", "ms", "application/x-troff-ms", "nc", "application/x-netcdf", "oda", "application/oda", "pdf", "application/pdf", "ps", "application/postscript", "ppt", "application/postscript", "pptx", "application/vnd.ms-powerpoint", "png", "image/png", "pgn", "application/x-chess-pgn", "pnm", "image/x-portable-anymap", "pbm", "image/x-portable-bitmap", "pgm", "image/x-portable-graymap", "ppm", "image/x-portable-pixmap", "properties", "application/x-properties", "qt", "video/quicktime", "rtf", "application/rtf", "ram", "audio/x-pn-realaudio", "rm", "audio/x-pn-realaudio", "rpm", "audio/x-pn-realaudio-plugin", "ra", "audio/x-realaudio", "ras", "image/x-cmu-raster", "rgb", "image/x-rgb", "rtx", "text/richtext", "rtf", "text/rtf", "smi", "application/smil", "smil", "application/smil", "skp", "application/x-koan", "skd", "application/x-koan", "skt", "application/x-koan", "skm", "application/x-koan", "src", "application/x-wais-source", "sh", "application/x-sh", "shar", "application/x-shar", "swf", "application/x-shockwave-flash", "sit", "application/x-stuffit", "spl", "application/x-futuresplash", "sv4cpio", "application/x-sv4cpio", "sv4crc", "application/x-sv4crc", "snd", "audio/basic", "sgml", "text/sgml", "sgm", "text/sgml", "tgz", "application/octet-stream", "tar", "application/x-tar", "tcl", "application/x-tcl", "tex", "application/x-tex", "texinfo", "application/x-texinfo", "texi", "application/x-texinfo", "t", "application/x-troff", "tld", "application/x-tld", "tr", "application/x-troff", "roff", "application/x-troff", "tiff", "image/tiff", "tif", "image/tiff", "txt", "text/plain", "tsv", "text/tab-separated-values", "ustar", "application/x-ustar", "vcd", "application/x-cdlink", "vrml", "model/vrml", "wav", "audio/x-wav", "wrl", "model/vrml", "xls", "application/vnd.ms-excel", "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xbm", "image/x-xbitmap", "xpm", "image/x-xpixmax", "xwd", "image/x-xwindowdump", "xml", "text/xml", "zip", "application/zip", "z", "application/octet-stream"};
        m_mimemap_p = new Properties();
        for (int i = 0; i < premimes.length; i += 2) {
            m_mimemap_p.put(premimes[i], ServerTools.getMimeString(premimes[i + 1]));
        }
    }

    public static synchronized void loadMimeMap(File fn) throws Exception {
        ServerTools.initMimeMap();
        try (FileInputStream is = new FileInputStream(fn);){
            m_mimemap_p.load(is);
        }
    }

    public static Properties getMimeMap() {
        ServerTools.initMimeMap();
        return m_mimemap_p;
    }

    public static final String makeTimeString() {
        GregorianCalendar c = new GregorianCalendar();
        int i = c.get(5);
        char[] b = new char[11];
        b[0] = (char)(i / 10 + 48);
        b[1] = (char)(i % 10 + 48);
        b[2] = 33;
        i = c.get(11);
        b[3] = (char)(i / 10 + 48);
        b[4] = (char)(i % 10 + 48);
        b[5] = 58;
        i = c.get(12);
        b[6] = (char)(i / 10 + 48);
        b[7] = (char)(i % 10 + 48);
        b[8] = 58;
        i = c.get(13);
        b[9] = (char)(i / 10 + 48);
        b[10] = (char)(i % 10 + 48);
        return new String(b);
    }

    private static synchronized long getUniq() {
        return ++m_us_count;
    }

    public static String getUniqueString() {
        char[] cc = new char[14];
        int ix = 0;
        int v = m_us_ts;
        while (ix < 4) {
            int dv = v & 0x3F;
            cc[ix++] = BASECODES.charAt(dv);
            v >>= 6;
        }
        long lv = ServerTools.getUniq();
        while (ix < 14) {
            int dv = (int)(lv & 0x3FL);
            cc[ix++] = BASECODES.charAt(dv);
            lv >>= 6;
        }
        return new String(cc);
    }

    public static void generateExpiryHeader(HttpServletResponse res, int exp) {
        if (exp > 0) {
            GregorianCalendar c = new GregorianCalendar();
            c.add(13, exp);
            res.setDateHeader("Expires", c.getTime().getTime());
        }
    }

    public static void generateNoCache(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, must-revalidate, no-store");
        response.setHeader("Expires", "Mon, 8 Aug 2006 10:00:00 GMT");
    }

    public static long getLong(HttpServletRequest req, String name) throws ServletException {
        String s = req.getParameter(name);
        if (s != null && (s = s.trim()).length() > 0) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception x) {
                throw new ServletException("The value '" + s + "' for the request parameter '" + name + "' is not a valid long integer");
            }
        }
        throw new ServletException("Missing value for request parameter '" + name + "'");
    }

    public static int getInt(HttpServletRequest req, String name) throws ServletException {
        String s = req.getParameter(name);
        if (s != null && (s = s.trim()).length() > 0) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception x) {
                throw new ServletException("The value '" + s + "' for the request parameter '" + name + "' is not a valid integer");
            }
        }
        throw new ServletException("Missing value for request parameter '" + name + "'");
    }

    public static int getInt(HttpServletRequest req, String name, int dflt) throws ServletException {
        String s = req.getParameter(name);
        if (s == null) {
            return dflt;
        }
        if ((s = s.trim()).length() == 0) {
            return dflt;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            throw new ServletException("The value '" + s + "' for the request parameter '" + name + "' is not a valid integer");
        }
    }

    static {
        m_mimestr_ht = new HashMap(511);
        m_us_count = 0L;
        m_us_ts = (int)(System.currentTimeMillis() % 1234567L);
    }
}

