/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public class ServiceException
extends Exception {
    private String m_url;
    private String m_method;
    private String m_queryString;
    private Map<String, String[]> m_parameters;
    private Map<String, String[]> m_headers;
    private String m_servletPath;
    private String m_remoteAddress;
    private String m_remoteUser;
    private HttpServlet m_servlet;

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceException(String message) {
        super(message);
    }

    public boolean hasContext() {
        return this.m_method != null;
    }

    public void init(HttpServletRequest req) {
        this.m_url = req.getRequestURI();
        this.m_queryString = req.getQueryString();
        this.m_method = req.getMethod();
        this.m_servletPath = req.getServletPath();
        this.m_remoteAddress = req.getRemoteHost();
        this.m_remoteUser = req.getRemoteUser();
        this.m_parameters = new HashMap<String, String[]>(req.getParameterMap());
        this.m_headers = new HashMap<String, String[]>();
        ArrayList al = new ArrayList();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration ve = req.getHeaders(name);
            while (ve.hasMoreElements()) {
                al.add(ve.nextElement());
            }
            this.m_headers.put(name, al.toArray(new String[al.size()]));
            al.clear();
        }
    }

    public Map<String, String[]> getHeaders() {
        return this.m_headers;
    }

    public void setHeaders(Map<String, String[]> headers) {
        this.m_headers = headers;
    }

    public String getMethod() {
        return this.m_method;
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public Map<String, String[]> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.m_parameters = parameters;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public void setQueryString(String queryString) {
        this.m_queryString = queryString;
    }

    public String getRemoteAddress() {
        return this.m_remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.m_remoteAddress = remoteAddress;
    }

    public String getRemoteUser() {
        return this.m_remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.m_remoteUser = remoteUser;
    }

    public String getServletPath() {
        return this.m_servletPath;
    }

    public void setServletPath(String servlet) {
        this.m_servletPath = servlet;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void setServlet(HttpServlet servlet) {
        this.m_servlet = servlet;
    }

    public HttpServlet getServlet() {
        return this.m_servlet;
    }
}

