/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.eventmanager;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.webapp.eventmanager.AppEventBase;
import to.etc.webapp.eventmanager.AppEventListener;
import to.etc.webapp.eventmanager.IEventMarshaller;
import to.etc.webapp.eventmanager.ListenerType;
import to.etc.webapp.testsupport.TestDataSourceStub;

public class VpEventManager
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(VpEventManager.class);
    private static final long DELETEINTERVAL = 600000L;
    private static final long POLLINTERVAL = 1000L;
    @Nullable
    private static VpEventManager m_instance;
    @Nullable
    private static ThreadLocal<VpEventManager> m_testInstances;
    @Nonnull
    private DataSource m_ds;
    @Nonnull
    private String m_tableName;
    @Nonnull
    private IEventMarshaller m_eventMarshaller;
    private long m_upid = -1L;
    private String m_serverName;
    private long m_ts_nextdelete;
    private long m_delete_upid;
    private boolean m_stop;
    private Thread m_handlerThread;
    private final TreeSet<Long> m_localEvents = new TreeSet();
    private final Map<String, List<Item>> m_listenerList = new HashMap<String, List<Item>>();
    private DbType m_dbtype;
    private long m_lastHandled;

    private VpEventManager(@Nonnull DataSource ds, @Nonnull String tableName, @Nonnull IEventMarshaller eventMarshaller) {
        this.m_ds = ds;
        this.m_tableName = tableName;
        this.m_eventMarshaller = eventMarshaller;
        try {
            this.m_serverName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception x) {
            this.m_serverName = "unknown";
        }
    }

    public static synchronized VpEventManager getInstance() {
        VpEventManager em;
        ThreadLocal<VpEventManager> tl = m_testInstances;
        if (null != tl) {
            em = tl.get();
            if (null == em) {
                em = VpEventManager.initDummyEventManagerForTest();
                tl.set(em);
            }
        } else {
            em = m_instance;
        }
        if (null == em) {
            throw new IllegalStateException("The VpEventManager has not been initialized");
        }
        return em;
    }

    private static VpEventManager initDummyEventManagerForTest() {
        IEventMarshaller dummyEM = new IEventMarshaller(){

            @Override
            public <T extends AppEventBase> T unmarshalEvent(String varchar) throws Exception {
                return null;
            }

            @Override
            public String marshalEvent(AppEventBase event) throws Exception {
                return "";
            }
        };
        return new VpEventManager(new TestDataSourceStub(), "sys_vp_events", dummyEM);
    }

    public static synchronized void initialize(DataSource ds, String tableName, @Nonnull IEventMarshaller eventMarshaller) throws Exception {
        ThreadLocal<VpEventManager> tl = m_testInstances;
        if (null != tl) {
            throw new IllegalStateException("The VpEventManager has already been initialized for TEST mode");
        }
        if (m_instance != null) {
            return;
        }
        VpEventManager em = new VpEventManager(ds, tableName, eventMarshaller);
        em.init();
        m_instance = em;
    }

    public static synchronized void initializeForTest() {
        if (m_instance != null) {
            throw new IllegalStateException("The VpEventManager has already been initialized for PRODUCTION mode");
        }
        ThreadLocal<VpEventManager> tl = m_testInstances;
        if (null == tl) {
            m_testInstances = tl = new ThreadLocal();
        }
    }

    public static synchronized boolean inJUnitTestMode() {
        return m_testInstances != null;
    }

    private void log(String s) {
        LOG.debug(s);
    }

    private void exception(Throwable t, String s) {
        LOG.error(s, t);
        System.out.println("VpEventManager: EXCEPTION " + s);
        t.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread ht;
        VpEventManager vpEventManager = this;
        synchronized (vpEventManager) {
            ht = this.m_handlerThread;
            if (ht == null) {
                return;
            }
            this.m_stop = true;
            this.notifyAll();
        }
        try {
            ht.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ht.isAlive()) {
            this.log("The event manager's thread failed to die!?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection dbc) {
        Statement ps = null;
        try {
            String seq;
            String tbl;
            String name = dbc.getMetaData().getDatabaseProductName().toLowerCase();
            if (name.contains("oracle")) {
                this.m_dbtype = DbType.ORACLE;
            } else if (name.contains("postgres")) {
                this.m_dbtype = DbType.POSTGRES;
            } else {
                throw new IllegalStateException("Unsupported database type: " + name);
            }
            switch (this.m_dbtype) {
                default: {
                    throw new IllegalStateException("Unhandled DBTYPE: " + (Object)((Object)this.m_dbtype));
                }
                case ORACLE: {
                    tbl = "create table " + this.m_tableName + "( upid numeric(20,0) not null primary key, utime date not null, evname varchar(80) not null, server varchar(32) not null, obj varchar2(4000 char))";
                    seq = "create sequence " + this.m_tableName + "_SQ start with 1 increment by 1";
                    break;
                }
                case POSTGRES: {
                    tbl = "create table " + this.m_tableName + "( upid numeric(20,0) not null primary key, utime date not null, evname varchar(80) not null, server varchar(32) not null, obj varchar(4000))";
                    seq = "create sequence " + this.m_tableName + "_SQ start with 1 increment by 1";
                }
            }
            ps = dbc.prepareStatement(tbl);
            ps.executeUpdate();
            ps.close();
            ps = dbc.prepareStatement(seq);
            ps.executeUpdate();
        }
        catch (Exception x) {
            String msg = x.toString().toLowerCase();
            if (msg.contains("ora-00955")) {
                return;
            }
            if (msg.contains("exist")) {
                return;
            }
            System.out.println("SystemEventManager: table creation exception " + x + ", if this is just because the table already exists there is no problem.");
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() throws Exception {
        Connection dbc = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            dbc = this.m_ds.getConnection();
            this.createTable(dbc);
            ps = dbc.prepareStatement("select max(upid) from " + this.m_tableName);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new IllegalStateException("?? Cannot get max update number");
            }
            this.m_upid = rs.getLong(1);
            this.m_delete_upid = 0L;
            this.m_ts_nextdelete = System.currentTimeMillis() + 600000L;
            this.checkPendingDeletes(dbc);
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{rs, ps, dbc});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{rs, ps, dbc});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!DeveloperOptions.getBool((String)"domui.eventmanager", (boolean)true) || DeveloperOptions.isBackGroundDisabled()) {
            return;
        }
        if (VpEventManager.inJUnitTestMode()) {
            return;
        }
        VpEventManager vpEventManager = m_instance;
        synchronized (vpEventManager) {
            if (this.m_handlerThread != null) {
                return;
            }
            this.m_handlerThread = new Thread(this);
            this.m_handlerThread.setName("SystemEventManager");
            this.m_handlerThread.setDaemon(true);
            this.m_handlerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPendingDeletes(Connection dbc) throws Exception {
        long deleteupid = 0L;
        VpEventManager vpEventManager = this;
        synchronized (vpEventManager) {
            if (this.m_delete_upid >= this.m_upid) {
                return;
            }
            long ts = System.currentTimeMillis();
            if (ts < this.m_ts_nextdelete) {
                return;
            }
            this.m_ts_nextdelete = ts + 600000L;
            deleteupid = this.m_delete_upid;
            this.m_delete_upid = this.m_upid;
        }
        Statement ps = null;
        try {
            String sql = "delete from " + this.m_tableName + " where upid < ? or utime < ?";
            ps = dbc.prepareStatement(sql);
            ps.setLong(1, deleteupid);
            Date offsetDate = new Date(System.currentTimeMillis() - 600000L);
            ps.setDate(2, offsetDate);
            LOG.debug(sql + " | " + deleteupid + ", " + offsetDate);
            ps.executeUpdate();
            dbc.commit();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanNewEvents(List<AppEventBase> al, Set<Long> localeventset) throws Exception {
        long upid;
        Connection dbc = this.m_ds.getConnection();
        ResultSet rs = null;
        Statement ps = null;
        VpEventManager vpEventManager = this;
        synchronized (vpEventManager) {
            upid = this.m_upid;
        }
        try {
            String sql = "select upid,evname,utime,server,obj from " + this.m_tableName + " where upid > ? order by upid";
            LOG.debug(sql);
            ps = dbc.prepareStatement(sql);
            ps.setLong(1, upid);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.readEventObject(rs, al);
            }
            if (al.size() > 0) {
                VpEventManager vpEventManager2 = this;
                synchronized (vpEventManager2) {
                    Long v;
                    Iterator<Long> it = this.m_localEvents.iterator();
                    while (it.hasNext() && (v = it.next()) <= upid) {
                        it.remove();
                        localeventset.add(v);
                    }
                }
            }
            this.checkPendingDeletes(dbc);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEventObject(ResultSet rs, List<AppEventBase> al) throws Exception {
        long upid = rs.getLong(1);
        VpEventManager vpEventManager = this;
        synchronized (vpEventManager) {
            if (upid > this.m_upid) {
                this.m_upid = upid;
            }
        }
        Timestamp ts = rs.getTimestamp(3);
        String server = rs.getString(4);
        String objectString = rs.getString(5);
        try {
            Object act = this.m_eventMarshaller.unmarshalEvent(objectString);
            if (act == null) {
                this.log("Event " + upid + " skipped: the embedded object is null");
                return;
            }
            Object e = act;
            ((AppEventBase)e).setServer(server);
            ((AppEventBase)e).setTimestamp(ts);
            ((AppEventBase)e).setUpid(upid);
            al.add((AppEventBase)e);
        }
        catch (Exception x) {
            this.log("Event " + upid + ": serialization got exception " + x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvents(List<AppEventBase> list, Set<Long> localeventset) {
        for (int i = 0; i < list.size(); ++i) {
            AppEventBase ae = list.get(i);
            this.callListeners(ae, false, localeventset.contains(ae.getUpid()));
            VpEventManager vpEventManager = this;
            synchronized (vpEventManager) {
                this.m_lastHandled = ae.getUpid();
                this.notifyAll();
                continue;
            }
        }
    }

    private void scanOnce() {
        try {
            ArrayList<AppEventBase> list = new ArrayList<AppEventBase>();
            HashSet<Long> localeventset = new HashSet<Long>();
            this.scanNewEvents(list, localeventset);
            if (list.size() == 0) {
                return;
            }
            this.log("Forwarding " + list.size() + " events.");
            this.handleEvents(list, localeventset);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean warn;
        while (true) {
            block22: {
                VpEventManager vpEventManager = this;
                // MONITORENTER : vpEventManager
                if (!this.m_stop) break block22;
                this.log("event manager terminates due to STOP request");
                // MONITOREXIT : vpEventManager
                boolean warn2 = false;
                VpEventManager vpEventManager2 = this;
                // MONITORENTER : vpEventManager2
                this.m_handlerThread = null;
                if (!this.m_stop) {
                    warn2 = true;
                }
                // MONITOREXIT : vpEventManager2
                if (!warn2) return;
                this.log("Handler thread EXITED!?");
                return;
            }
            this.wait(1000L);
            if (!this.m_stop) break block23;
            // MONITOREXIT : vpEventManager
            warn = false;
            VpEventManager vpEventManager = this;
            break;
        }
        {
            catch (Throwable t) {
                t.printStackTrace();
                boolean warn3 = false;
                VpEventManager vpEventManager = this;
                // MONITORENTER : vpEventManager
                this.m_handlerThread = null;
                if (!this.m_stop) {
                    warn3 = true;
                }
                // MONITOREXIT : vpEventManager
                if (!warn3) return;
                this.log("Handler thread EXITED!?");
                return;
            }
        }
        {
            block23: {
                // MONITORENTER : vpEventManager
                this.m_handlerThread = null;
                if (!this.m_stop) {
                    warn = true;
                }
                // MONITOREXIT : vpEventManager
                if (!warn) return;
                this.log("Handler thread EXITED!?");
                return;
            }
            // MONITOREXIT : vpEventManager
            this.scanOnce();
            continue;
        }
        catch (Throwable throwable) {
            boolean warn4 = false;
            VpEventManager vpEventManager = this;
            // MONITORENTER : vpEventManager
            this.m_handlerThread = null;
            if (!this.m_stop) {
                warn4 = true;
            }
            // MONITOREXIT : vpEventManager
            if (!warn4) throw throwable;
            this.log("Handler thread EXITED!?");
            throw throwable;
        }
    }

    @Nonnull
    private static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendEventMain(@Nonnull Connection dbc, @Nonnull AppEventBase ae, boolean commit, boolean isimmediate) throws Exception {
        long l;
        ResultSet rs = null;
        PreparedStatement ps = null;
        boolean ac = dbc.getAutoCommit();
        boolean ok = false;
        try {
            if (ac) {
                dbc.setAutoCommit(false);
            }
            if (!(rs = (ps = dbc.prepareStatement("select " + this.m_tableName + "_SQ.nextval from dual")).executeQuery()).next()) {
                throw new SQLException("No result from select-from-sequence!?");
            }
            long id = rs.getLong(1);
            rs.close();
            ps.close();
            ae.setUpid(id);
            ae.setTimestamp(VpEventManager.now());
            ae.setServer(this.m_serverName);
            if (isimmediate) {
                VpEventManager vpEventManager = this;
                synchronized (vpEventManager) {
                    this.m_localEvents.add(id);
                }
            }
            ps = dbc.prepareStatement("insert into " + this.m_tableName + "(upid,evname,utime,server,obj) values(?,?,?,?,?)");
            ps.setLong(1, id);
            ps.setString(2, ae.getClass().getCanonicalName());
            ps.setTimestamp(3, (Timestamp)ae.getTimestamp());
            ps.setString(4, ae.getServer());
            ps.setString(5, this.m_eventMarshaller.marshalEvent(ae));
            ps.executeUpdate();
            ps.close();
            rs.close();
            ps.close();
            if (commit) {
                dbc.commit();
            }
            ok = true;
            l = id;
        }
        catch (Throwable throwable) {
            try {
                if (!ok) {
                    dbc.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ac && commit) {
                    dbc.setAutoCommit(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileTool.closeAll((Object[])new Object[]{rs, ps});
            throw throwable;
        }
        try {
            if (!ok) {
                dbc.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ac && commit) {
                dbc.setAutoCommit(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileTool.closeAll((Object[])new Object[]{rs, ps});
        return l;
    }

    private synchronized void addListener(@Nonnull Class<?> cl, @Nonnull ListenerType lt, @Nonnull AppEventListener<?> listener, boolean weak) {
        List<Item> l = this.m_listenerList.get(cl.getName());
        if (l == null) {
            l = new ArrayList<Item>(5);
            this.m_listenerList.put(cl.getName(), l);
        }
        int i = l.size();
        while (--i >= 0) {
            Item it = l.get(i);
            if (it.m_obj instanceof Reference) {
                Reference r = (Reference)it.m_obj;
                if (r.get() == listener) {
                    return;
                }
                if (r.get() != null) continue;
                l.remove(i);
                continue;
            }
            if (it.m_obj != listener) continue;
            return;
        }
        if (weak) {
            l.add(new Item(lt, new WeakReference(listener)));
        } else {
            l.add(new Item(lt, listener));
        }
    }

    public synchronized void removeListener(@Nonnull Class<?> cl, @Nonnull AppEventListener<?> listener) {
        List<Item> l = this.m_listenerList.get(cl.getName());
        if (l == null) {
            return;
        }
        int i = l.size();
        while (--i >= 0) {
            Item it = l.get(i);
            if (it.m_obj instanceof Reference) {
                Reference r = (Reference)it.m_obj;
                if (r.get() == listener) {
                    l.remove(i);
                    return;
                }
                if (r.get() != null) continue;
                l.remove(i);
                continue;
            }
            if (it.m_obj != listener) continue;
            l.remove(i);
            return;
        }
    }

    private synchronized void getListeners(@Nonnull List<AppEventListener<AppEventBase>> list, @Nonnull AppEventBase ae, boolean ateventtime, boolean islocalevent) {
        Class<?> cl = ae.getClass();
        while (true) {
            List<Item> l;
            if ((l = this.m_listenerList.get(cl.getName())) != null) {
                int i = l.size();
                while (--i >= 0) {
                    Item it = l.get(i);
                    if (!ateventtime ? it.m_type == ListenerType.LOCALLY || it.m_type == ListenerType.IMMEDIATELY && islocalevent : it.m_type != ListenerType.IMMEDIATELY && it.m_type != ListenerType.LOCALLY) continue;
                    Object o = it.m_obj;
                    if (o instanceof Reference) {
                        Reference r = (Reference)o;
                        Object lsnr = r.get();
                        if (lsnr == null) {
                            l.remove(i);
                            continue;
                        }
                        list.add((AppEventListener)((Object)l));
                        continue;
                    }
                    list.add((AppEventListener)o);
                }
            }
            if (cl == AppEventBase.class) {
                return;
            }
            cl = cl.getSuperclass();
        }
    }

    private void callListeners(@Nonnull AppEventBase ae, boolean immediate, boolean islocalevent) {
        ArrayList<AppEventListener<AppEventBase>> list = new ArrayList<AppEventListener<AppEventBase>>();
        this.getListeners(list, ae, immediate, islocalevent);
        int i = list.size();
        while (--i >= 0) {
            AppEventListener l = (AppEventListener)list.get(i);
            try {
                l.handleEvent(ae);
            }
            catch (Exception x) {
                this.exception(x, "Event " + ae + " caused " + x + " in handler " + l);
            }
        }
    }

    public <T extends AppEventBase> void addListener(@Nonnull Class<T> cl, @Nonnull ListenerType lt, @Nonnull AppEventListener<T> listener) {
        this.addListener(cl, lt, listener, false);
    }

    public <T extends AppEventBase> void addWeakListener(@Nonnull Class<T> cl, @Nonnull ListenerType lt, @Nonnull AppEventListener<T> listener) {
        this.addListener(cl, lt, listener, true);
    }

    public <T extends AppEventBase> void removeWeakListener(@Nonnull Class<T> cl, @Nonnull AppEventListener<T> listener) {
        this.removeListener(cl, listener);
    }

    public void postEvent(@Nonnull Connection dbc, @Nonnull AppEventBase ae) throws Exception {
        if (!VpEventManager.inJUnitTestMode()) {
            this.sendEventMain(dbc, ae, true, true);
        }
        this.callListeners(ae, true, true);
    }

    public void postDelayedEvent(@Nonnull Connection dbc, @Nonnull AppEventBase ae) throws Exception {
        if (!VpEventManager.inJUnitTestMode()) {
            this.sendEventMain(dbc, ae, false, false);
        } else {
            this.callListeners(ae, true, true);
        }
    }

    public void postDelayedEvent(@Nonnull Connection dbc, @Nonnull List<? extends AppEventBase> ae) throws Exception {
        for (AppEventBase appEventBase : ae) {
            if (VpEventManager.inJUnitTestMode()) {
                this.callListeners(appEventBase, true, true);
                continue;
            }
            this.sendEventMain(dbc, appEventBase, false, false);
        }
    }

    public void postEvent(@Nonnull Connection dbc, @Nonnull List<? extends AppEventBase> aelist) throws Exception {
        if (!VpEventManager.inJUnitTestMode()) {
            for (AppEventBase appEventBase : aelist) {
                this.sendEventMain(dbc, appEventBase, false, true);
            }
        }
        dbc.commit();
        for (AppEventBase appEventBase : aelist) {
            this.callListeners(appEventBase, true, true);
        }
    }

    private synchronized long getLastHandled() {
        return this.m_lastHandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHandled(long value) throws Exception {
        if (this.getLastHandled() >= value) {
            return;
        }
        long ets = System.currentTimeMillis() + 60000L;
        do {
            VpEventManager vpEventManager = this;
            synchronized (vpEventManager) {
                if (this.m_lastHandled >= value) {
                    return;
                }
                this.wait(10000L);
            }
        } while (System.currentTimeMillis() < ets);
        throw new TimeoutException();
    }

    static enum DbType {
        ORACLE,
        POSTGRES;

    }

    private static class Item {
        public Object m_obj;
        public ListenerType m_type;

        public Item(ListenerType t, Object o) {
            this.m_type = t;
            this.m_obj = o;
        }
    }
}

