/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.mailer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.PoolManager;
import to.etc.dbutil.DbLockKeeper;
import to.etc.dbutil.GenericDB;
import to.etc.smtp.Address;
import to.etc.smtp.Message;
import to.etc.smtp.SmtpTransport;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.webapp.pendingoperations.IPollQueueTaskProvider;
import to.etc.webapp.pendingoperations.PollingWorkerQueue;
import to.etc.webapp.query.QDataContext;

public class BulkMailer {
    private static final Logger LOG = LoggerFactory.getLogger(BulkMailer.class);
    private static final BulkMailer m_instance = new BulkMailer();
    private SmtpTransport m_transport;
    private DataSource m_ds;
    private long m_ts_nextcleanup = 0L;
    private static final long DAY = 86400000L;

    public static BulkMailer getInstance() {
        return m_instance;
    }

    public static void initialize(DataSource ds, SmtpTransport t) throws Exception {
        try {
            DbLockKeeper.init((DataSource)ds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BulkMailer.getInstance().init(ds, t);
    }

    private synchronized void init(DataSource ds, SmtpTransport t) throws Exception {
        if (this.m_ds != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.m_ds = ds;
        this.m_transport = t;
        this.createTables();
        if (DeveloperOptions.getBool((String)"domui.mailer", (!DeveloperOptions.isDeveloperWorkstation() ? 1 : 0) != 0)) {
            PollingWorkerQueue.getInstance().registerProvider(new PollTaskProvider());
        }
    }

    private void createTables() throws Exception {
        Connection dbc = this.m_ds.getConnection();
        try {
            dbc.setAutoCommit(false);
            StringBuilder sb = new StringBuilder();
            GenericDB.runScriptResource((Connection)dbc, this.getClass(), (String)"bulkmailer.sql", (StringBuilder)sb);
            if (sb.length() > 0) {
                LOG.info(sb.toString());
            }
        }
        finally {
            try {
                dbc.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(@Nonnull Message m) throws Exception {
        boolean ok = false;
        Connection dbc = this.m_ds.getConnection();
        try {
            this.store(dbc, m);
            ok = true;
        }
        finally {
            try {
                if (!ok) {
                    dbc.rollback();
                }
            }
            catch (Exception exception) {}
            try {
                dbc.close();
            }
            catch (Exception exception) {}
        }
    }

    public void store(@Nonnull QDataContext dc, @Nonnull Message m) throws Exception {
        this.store(dc.getConnection(), m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(@Nonnull Connection dbc, @Nonnull Message m) throws Exception {
        PreparedStatement cs = null;
        Statement ps = null;
        ResultSet rs = null;
        ByteArrayOutputStream os = null;
        try {
            dbc.setAutoCommit(false);
            cs = dbc.prepareStatement("insert into sys_mail_messages(smm_id, smm_date, smm_subject, smm_from_address, smm_from_name) values(?, ?, ?, ?, ?)");
            int i = 1;
            long key = GenericDB.getFullSequenceID((Connection)dbc, (String)"sys_smm_seq");
            cs.setLong(i++, key);
            cs.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
            cs.setString(i++, StringTool.strTrunc((String)m.getSubject(), (int)240));
            cs.setString(i++, StringTool.strTrunc((String)m.getFrom().getEmail(), (int)128));
            cs.setString(i++, StringTool.strTrunc((String)m.getFrom().getName(), (int)64));
            cs.executeUpdate();
            cs.close();
            cs = null;
            os = new ByteArrayOutputStream();
            SmtpTransport.writeMime((OutputStream)os, (Message)m);
            os.close();
            byte[] data = os.toByteArray();
            GenericDB.setBlob((Connection)dbc, (String)"sys_mail_messages", (String)"smm_data", (String)("smm_id=" + key), (InputStream)new ByteArrayInputStream(data), (int)data.length);
            ps = dbc.prepareStatement("insert into sys_mail_recipients(smr_id, smr_address, smr_type, smr_date_posted, smr_retries, smr_nextretry, smr_state,smr_name,smm_id) values(?, ?, ?, ?, 0, ?, 'SEND', ?, ?)");
            for (Address a : m.getTo()) {
                this.writeRecipient((PreparedStatement)ps, dbc, a, key, DstType.TO);
            }
            for (Address a : m.getCc()) {
                this.writeRecipient((PreparedStatement)ps, dbc, a, key, DstType.CC);
            }
            for (Address a : m.getBcc()) {
                this.writeRecipient((PreparedStatement)ps, dbc, a, key, DstType.BCC);
            }
            ps.close();
            dbc.commit();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (cs != null) {
                    cs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                dbc.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeRecipient(PreparedStatement ps, Connection dbc, Address a, long key, DstType type) throws SQLException {
        long sq = GenericDB.getFullSequenceID((Connection)dbc, (String)"sys_smr_seq");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        int i = 1;
        ps.setLong(i++, sq);
        ps.setString(i++, StringTool.strTrunc((String)DeveloperOptions.getString((String)"debug.email", (String)a.getEmail()), (int)128));
        ps.setString(i++, type.name());
        ps.setTimestamp(i++, now);
        ps.setTimestamp(i++, now);
        ps.setString(i++, StringTool.strTrunc((String)a.getName(), (int)64));
        ps.setLong(i++, key);
        ps.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanMailRun() {
        Connection dbc = null;
        DbLockKeeper.LockHandle lock = null;
        FailLoc location = FailLoc.DATABASE;
        Statement ps = null;
        ResultSet rs = null;
        Statement ps2 = null;
        ResultSet rs2 = null;
        InputStream is = null;
        byte[] lastbody = null;
        long lastmsgid = -1L;
        String subject = null;
        String fromaddress = null;
        String fromname = null;
        Address froma = null;
        try {
            dbc = this.m_ds.getConnection();
            dbc.setAutoCommit(false);
            lock = DbLockKeeper.getInstance().lockNowait(this.getClass().getName());
            if (null == lock) {
                LOG.debug("Bulk mailer lock is taken - done");
                location = FailLoc.OKAY;
                return;
            }
            LOG.info("Scanning for email to send");
            long cts = System.currentTimeMillis();
            if (this.m_ts_nextcleanup == 0L) {
                this.m_ts_nextcleanup = cts;
            } else if (this.m_ts_nextcleanup < cts) {
                this.m_ts_nextcleanup = cts + 0x6DDD00L;
                this.cleanup(dbc);
            }
            ps = dbc.prepareStatement("select smr_id,smr_address,smr_type,smr_retries,smr_state,smr_name,smm_id,smr_lasterror,smr_nextretry from sys_mail_recipients where smr_state in ('RTRY', 'SEND') and smr_nextretry <= ? order by smm_id", 1003, 1008);
            ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            rs = ps.executeQuery();
            while (rs.next()) {
                Address a;
                String error;
                String email = rs.getString(2);
                int retries = rs.getInt(4);
                String name = rs.getString(6);
                long msgid = rs.getLong(7);
                if (lastmsgid != msgid) {
                    lastmsgid = msgid;
                    if (ps2 == null) {
                        ps2 = dbc.prepareStatement("select smm_subject, smm_from_address, smm_from_name, smm_data from sys_mail_messages where smm_id=?");
                    }
                    ps2.setLong(1, msgid);
                    rs2 = ps2.executeQuery();
                    if (!rs2.next()) {
                        throw new IllegalStateException("Cannot locate message record - integrity failure!?");
                    }
                    subject = rs2.getString(1);
                    fromaddress = rs2.getString(2);
                    fromname = rs2.getString(3);
                    froma = new Address(fromaddress, fromname);
                    is = rs2.getBinaryStream(4);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    FileTool.copyFile((OutputStream)baos, (InputStream)is);
                    baos.close();
                    is.close();
                    is = null;
                    lastbody = baos.toByteArray();
                    rs2.close();
                    rs2 = null;
                }
                if (null == (error = this.sendMessage(froma, a = name != null ? new Address(email, name) : new Address(email), subject, lastbody))) {
                    rs.updateString(5, RState.DONE.name());
                } else {
                    rs.updateString(8, StringTool.strTrunc((String)error, (int)128));
                    rs.updateInt(4, ++retries);
                    if (retries > 20) {
                        rs.updateString(5, RState.FATL.name());
                    } else {
                        rs.updateString(5, RState.RTRY.name());
                        long ft = retries < 5 ? 2L : (retries < 10 ? 60L : 480L);
                        rs.updateTimestamp(9, new Timestamp(System.currentTimeMillis() + (ft *= 60000L)));
                    }
                }
                rs.updateRow();
            }
            rs.close();
            rs = null;
            dbc.commit();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs2 != null) {
                    rs2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Connection dbc) {
        PreparedStatement ps = null;
        try {
            ps = dbc.prepareStatement("delete from sys_mail_recipients where (smr_state='DONE' and smr_nextretry<?) or (smr_nextretry < ?)");
            ps.setTimestamp(1, new Timestamp(System.currentTimeMillis() - 172800000L));
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis() - 604800000L));
            int rc = ps.executeUpdate();
            if (rc > 0) {
                System.out.println("bulkMail: deleted " + rc + " outdated recipients");
            }
            if (rc != 0) {
                ps.close();
                ps = dbc.prepareStatement("delete from sys_mail_messages m where not exists (select 1 from sys_mail_recipients r where r.smm_id=m.smm_id)");
                rc = ps.executeUpdate();
                if (rc > 0) {
                    System.out.println("bulkMail: deleted " + rc + " outdated message bodies");
                }
            }
        }
        catch (Exception x) {
            System.out.println("bulkMail: cannot cleanup recipients: " + x);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String sendMessage(Address froma, Address a, String subject, byte[] lastbody) {
        try {
            Message m = new Message();
            m.setFrom(froma);
            m.addTo(a);
            m.setSubject(subject);
            this.m_transport.send(m, (InputStream)new ByteArrayInputStream(lastbody));
            return null;
        }
        catch (Exception x) {
            x.printStackTrace();
            return x.toString();
        }
    }

    public static void main(String[] args) {
        try {
            ConnectionPool p = PoolManager.getInstance().definePool("pzlnew");
            DataSource ds = p.getUnpooledDataSource();
            PollingWorkerQueue.initialize();
            BulkMailer.initialize(ds, new SmtpTransport("localhost"));
            Message m = new Message();
            m.setFrom(new Address("jal@etc.to", "Frits Jalvingh"));
            m.addTo(new Address("jo.seaton@itris.nl", "Sea Joton"));
            m.addCc(new Address("marc.mol@itris.nl", "Morc Mal"));
            m.setSubject("[vp] Test email from the bulk mailer");
            m.setBody("Dit is een kleine test-email");
            m.setHtmlBody("<h1>Hello, world</h1>\n");
            BulkMailer.getInstance().store(m);
            Thread.sleep(60000L);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static enum FailLoc {
        OKAY,
        DATABASE,
        DBLOCK;

    }

    private final class PollTaskProvider
    implements IPollQueueTaskProvider {
        private long m_tsNext = System.currentTimeMillis() + 20000L;

        private PollTaskProvider() {
        }

        @Override
        public void initializeOnRegistration(PollingWorkerQueue pwq) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable getRunnableTask() throws Exception {
            long cts = System.currentTimeMillis();
            PollTaskProvider pollTaskProvider = this;
            synchronized (pollTaskProvider) {
                if (cts < this.m_tsNext) {
                    return null;
                }
                this.m_tsNext = cts + 60000L;
            }
            return new Runnable(){

                @Override
                public void run() {
                    BulkMailer.this.scanMailRun();
                }
            };
        }
    }

    private static enum RState {
        SEND,
        DONE,
        RTRY,
        FATL;

    }

    private static enum DstType {
        TO,
        CC,
        BCC;

    }
}

