/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.mailer;

import javax.annotation.Nonnull;
import to.etc.webapp.mailer.ITextLinkRenderer;
import to.etc.webapp.mailer.TextLinkInfo;
import to.etc.webapp.query.IIdentifyable;

public class LinkedText {
    private StringBuilder m_sb = new StringBuilder();

    public LinkedText() {
    }

    public LinkedText(String start) {
        this.m_sb.append(start);
    }

    @Nonnull
    public LinkedText append(char c) {
        if (c == '$') {
            this.m_sb.append("\\$");
        } else {
            this.m_sb.append(c);
        }
        return this;
    }

    @Nonnull
    public LinkedText append(@Nonnull CharSequence csq) {
        this.m_sb.append(csq);
        return this;
    }

    @Nonnull
    public LinkedText append(@Nonnull CharSequence csq, int start, int end) {
        this.m_sb.append(csq, start, end);
        return this;
    }

    @Nonnull
    public LinkedText link(@Nonnull String key, @Nonnull String id, @Nonnull String txt) {
        this.m_sb.append("$[");
        this.appendQ$(key);
        this.m_sb.append('$');
        this.appendQ$(id);
        this.m_sb.append('$');
        this.appendQ$(txt);
        this.m_sb.append(']');
        return this;
    }

    private void appendQ$(String key) {
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c == '$') {
                this.m_sb.append('\\');
            }
            this.m_sb.append(c);
        }
    }

    @Nonnull
    public LinkedText link(@Nonnull IIdentifyable<?> instance) {
        return this.link(instance, String.valueOf(instance));
    }

    @Nonnull
    public LinkedText link(@Nonnull IIdentifyable<?> instance, @Nonnull String linktext) {
        if (null == instance) {
            this.append("[null link to ").append(linktext).append("]");
            return this;
        }
        TextLinkInfo li = TextLinkInfo.getInfo(instance);
        if (null == li) {
            this.link(instance.getClass().getName(), String.valueOf(instance.getId()), linktext);
        } else {
            this.link(li.getLinkname(), String.valueOf(instance.getId()), linktext);
        }
        return this;
    }

    public String toString() {
        return this.m_sb.toString();
    }

    public void clear() {
        this.m_sb.setLength(0);
    }

    public static void decode(@Nonnull ITextLinkRenderer r, @Nonnull String in) {
        if (in == null) {
            in = "";
        }
        StringBuilder sb = new StringBuilder();
        int ix = 0;
        int len = in.length();
        while (ix < len) {
            char c;
            if ((c = in.charAt(ix++)) == '$' && ix < len && in.charAt(ix) == '[') {
                ++ix;
                if (sb.length() > 0) {
                    r.appendText(sb.toString());
                    sb.setLength(0);
                }
                ix = LinkedText.decodeKey(r, sb, ix, in, len);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            r.appendText(sb.toString());
        }
    }

    private static int decodeKey(@Nonnull ITextLinkRenderer r, @Nonnull StringBuilder sb, int ix, @Nonnull String in, int len) {
        int dol = 0;
        String type = null;
        String key = null;
        String text = null;
        sb.setLength(0);
        while (ix < len) {
            char c;
            if ((c = in.charAt(ix++)) == '\\' && ix < len) {
                sb.append(in.charAt(ix++));
                continue;
            }
            if (c == ']') {
                TextLinkInfo tli;
                text = sb.toString();
                sb.setLength(0);
                if (null == key) {
                    key = "?";
                }
                if (null == text) {
                    text = "?";
                }
                if (null == (tli = TextLinkInfo.getInfo(type))) {
                    r.appendText(text + " (key:" + key + ", type:" + type);
                } else {
                    r.appendLink(tli.getFullUrl(key), text);
                }
                return ix;
            }
            if (c == '$') {
                if (dol == 0) {
                    type = sb.toString();
                } else if (dol == 1) {
                    key = sb.toString();
                } else {
                    throw new IllegalStateException("Too many dollar separators");
                }
                sb.setLength(0);
                ++dol;
                continue;
            }
            sb.append(c);
        }
        throw new IllegalStateException("Missing link end indicator ']'");
    }
}

