/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.mailer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.OperationNotSupportedException;
import to.etc.smtp.Address;
import to.etc.smtp.IMailAttachment;
import to.etc.smtp.Message;
import to.etc.smtp.MimeWriter;
import to.etc.smtp.SmtpTransport;
import to.etc.util.ByteBufferInputStream;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.webapp.core.ServerTools;
import to.etc.webapp.mailer.BulkMailer;
import to.etc.webapp.mailer.ITextLinkRenderer;
import to.etc.webapp.mailer.LinkedText;
import to.etc.webapp.mailer.TextLinkInfo;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QDataContext;

public class MailHelper {
    private final StringBuilder m_text_sb = new StringBuilder();
    private final StringBuilder m_html_sb = new StringBuilder();
    private String m_subject;
    private Address m_from;
    @Nullable
    private ITextLinkRenderer m_linkRenderer;
    @Nullable
    private String m_applicationURL;
    @Nonnull
    private final List<Attachment> m_attachmentList = new ArrayList<Attachment>();
    @Nonnull
    private final List<Address> m_to = new ArrayList<Address>();
    private int m_attindex = 1;
    @Nullable
    private String m_lastImgKey;
    private boolean m_init;
    private int m_htmlLen = 0;
    private static final int MAXLINE = 78;
    private File m_root;

    public void setRoot(File root) {
        this.m_root = root;
    }

    private void init() {
        if (this.m_init) {
            return;
        }
        this.m_text_sb.setLength(0);
        this.m_html_sb.setLength(0);
        this.m_attachmentList.clear();
        this.m_attindex = 0;
        this.m_html_sb.append("<html><head>");
        this.m_html_sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        this.m_html_sb.append("</head>");
        this.m_html_sb.append("<body>");
        this.m_init = true;
        this.addGreeting();
    }

    public void start(Address to, String subject) {
        this.m_htmlLen = 0;
        this.setSubject(subject);
        this.addTo(to);
    }

    @Nonnull
    private ITextLinkRenderer getLinkRenderer() {
        ITextLinkRenderer linkRenderer = this.m_linkRenderer;
        if (null == linkRenderer) {
            linkRenderer = this.m_linkRenderer = new ITextLinkRenderer(){

                @Override
                public void appendText(@Nonnull String text) {
                    MailHelper.this.appendVerbatim(text);
                }

                @Override
                public void appendLink(@Nonnull String rurl, @Nonnull String text) {
                    String appurl = MailHelper.this.getApplicationURL();
                    if (null == appurl) {
                        throw new IllegalStateException("To render LinkedText-like links you must set applicationURL or linkRenderer.");
                    }
                    MailHelper.this.link(appurl + rurl, text);
                }
            };
        }
        return linkRenderer;
    }

    private void htmlWrap(@Nonnull String seg) {
        int len = seg.length();
        if (this.m_htmlLen + len >= 78) {
            this.internalNL();
        }
        this.m_html_sb.append(seg);
        this.m_htmlLen += len;
    }

    public void htmlTag(String tag, String ... attrs) {
        this.htmlWrap("<" + tag);
        for (int i = 0; i < attrs.length; i += 2) {
            this.htmlAttr(attrs[i], attrs[i + 1]);
        }
        this.htmlWrap(">");
    }

    private void htmlAttr(String name, String value) {
        this.htmlWrap(" " + name + "=");
        this.htmlWrap("\"" + value + "\"");
    }

    public void htmlEndTag(String tag) {
        this.htmlWrap("</" + tag + ">");
    }

    public void htmlText(String text) {
        int ix = 0;
        int eix = text.length();
        int six = 0;
        while (ix < eix) {
            char c = text.charAt(ix);
            if (!Character.isWhitespace(c)) {
                ++ix;
                continue;
            }
            boolean wrapped = false;
            int sz = ix - six;
            if (sz > 0) {
                if (this.m_htmlLen + sz >= 78) {
                    this.m_htmlLen = 0;
                    this.m_html_sb.append("\r\n");
                    wrapped = true;
                }
                this.m_htmlLen += sz;
                this.m_html_sb.append(text, six, ix);
            }
            ++ix;
            if (c == '\r') {
                if (ix < eix && text.charAt(ix) == '\n') {
                    ++ix;
                }
                if (!wrapped) {
                    this.internalNL();
                }
            } else if (c == '\n') {
                if (!wrapped) {
                    this.internalNL();
                }
            } else {
                this.m_html_sb.append(c);
                ++this.m_htmlLen;
            }
            six = ix;
        }
        int sz = ix - six;
        if (sz > 0) {
            if (this.m_htmlLen + sz >= 78) {
                this.internalNL();
            }
            this.m_htmlLen += sz;
            this.m_html_sb.append(text, six, ix);
        }
    }

    private void internalNL() {
        this.m_html_sb.append("\r\n");
        this.m_htmlLen = 0;
    }

    @Nonnull
    public MailHelper append(@Nonnull String s) {
        this.init();
        ITextLinkRenderer r = this.getLinkRenderer();
        LinkedText.decode(r, s);
        return this;
    }

    public void appendVerbatim(@Nonnull String s) {
        this.init();
        this.m_text_sb.append(s);
        String html = StringTool.htmlStringize((String)s);
        this.htmlText(html);
    }

    @Nonnull
    public MailHelper ttl(@Nonnull String s) {
        this.init();
        this.htmlTag("h2", new String[0]);
        this.append(s);
        this.m_text_sb.append("\n");
        int i = s.length();
        while (--i >= 0) {
            this.m_text_sb.append('=');
        }
        this.m_text_sb.append("\n");
        this.htmlEndTag("h2");
        this.htmlText("\r\n");
        return this;
    }

    @Nonnull
    public MailHelper i(String s) {
        this.init();
        this.htmlTag("i", new String[0]);
        this.append(s);
        this.htmlEndTag("i");
        return this;
    }

    @Nonnull
    public MailHelper b(String s) {
        this.init();
        this.htmlTag("b", new String[0]);
        this.append(s);
        this.htmlEndTag("b");
        return this;
    }

    @Nonnull
    public MailHelper nl() {
        this.init();
        this.m_text_sb.append("\r\n");
        this.htmlTag("br/", new String[0]);
        this.htmlText("\r\n");
        return this;
    }

    @Nonnull
    public MailHelper pre(String content) {
        this.init();
        this.htmlTag("pre", new String[0]);
        this.append(content);
        this.htmlEndTag("pre");
        this.htmlText("\r\n");
        return this;
    }

    @Nonnull
    public MailHelper link(@Nonnull String url, @Nonnull String text) {
        this.init();
        this.m_text_sb.append(text);
        this.m_text_sb.append(" (");
        this.m_text_sb.append(url);
        this.m_text_sb.append(")");
        this.htmlTag("a", "href", url);
        this.htmlText(StringTool.htmlStringize((String)text));
        this.htmlEndTag("a");
        return this;
    }

    @Nonnull
    public MailHelper link(@Nonnull String text, @Nonnull IIdentifyable<?> inst) {
        this.init();
        TextLinkInfo info = TextLinkInfo.getInfo(inst);
        if (info == null) {
            this.append(text).append(" (").append(String.valueOf(inst)).append(")");
        } else {
            this.getLinkRenderer().appendLink(info.getFullUrl(String.valueOf(inst.getId())), text);
        }
        return this;
    }

    @Nonnull
    public MailHelper linkNoText(String url, String text) {
        this.init();
        this.m_text_sb.append(url);
        this.htmlTag("a", "href", url);
        this.htmlText(StringTool.htmlStringize((String)text));
        this.htmlEndTag("a");
        return this;
    }

    @Nonnull
    public MailHelper image(String name, String mime, File source) throws Exception {
        String imgkey = name + "-" + this.m_attindex++;
        this.image(new Attachment(mime, imgkey, source), name);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MailHelper image(String name, Class<?> resourceClass, String resourceName) throws Exception {
        String ext = FileTool.getFileExtension((String)resourceName);
        String mime = ServerTools.getExtMimeType(ext);
        InputStream is = resourceClass.getResourceAsStream(resourceName);
        if (null == is) {
            throw new IllegalArgumentException("Resource " + resourceClass + ":" + resourceName + " not found on the classpath");
        }
        try {
            byte[][] bufs = FileTool.loadByteBuffers((InputStream)is);
            String imgkey = name + "-" + this.m_attindex++;
            this.image(new Attachment(mime, imgkey, bufs), name);
            MailHelper mailHelper = this;
            return mailHelper;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MailHelper image(@Nonnull String name, @Nonnull String mime, @Nonnull String rurl) throws Exception {
        byte[][] buf;
        InputStream is = this.m_root != null ? new FileInputStream(new File(this.m_root, rurl)) : this.getApplicationResource(rurl);
        try {
            buf = FileTool.loadByteBuffers((InputStream)is);
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{is});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{is});
        String s = MimeWriter.generateContentID();
        this.image(new Attachment(mime, s, buf), name);
        return this;
    }

    @Nonnull
    public MailHelper image(@Nonnull String name, @Nonnull String rurl) throws Exception {
        String ext = FileTool.getFileExtension((String)rurl);
        String mime = ServerTools.getExtMimeType(ext);
        return this.image(name, mime, rurl);
    }

    @Nonnull
    public String addImage(@Nonnull String name, @Nonnull String rurl) throws Exception {
        this.image(name, rurl);
        String s = this.m_lastImgKey;
        if (s == null) {
            throw new IllegalStateException("Last image not set");
        }
        return s;
    }

    public MailHelper image(@Nonnull Attachment a, @Nonnull String name) throws Exception {
        this.init();
        this.m_text_sb.append("(see attached image ");
        this.m_text_sb.append(a.m_ident);
        this.m_text_sb.append(") ");
        this.htmlTag("img", "src", "cid:" + a.m_ident);
        this.m_attachmentList.add(a);
        return this;
    }

    public void send() throws Exception {
        this.sendInternal(null);
    }

    public void send(@Nonnull SmtpTransport transport) throws Exception {
        this.sendInternal(transport);
    }

    public void send(@Nonnull QDataContext dc) throws Exception {
        this.sendInternal(dc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendInternal(@Nullable Object through) throws Exception {
        this.addTrailer();
        this.htmlEndTag("body");
        this.htmlEndTag("html");
        if (DeveloperOptions.getBool((String)"email.send", (boolean)true)) {
            String alt = DeveloperOptions.getString((String)"email.debug");
            if (alt != null) {
                ArrayList<Address> replaced = new ArrayList<Address>();
                for (Address address : this.getTo()) {
                    String name = address.getName();
                    if (name == null) {
                        name = address.getEmail().replace('@', '-');
                    }
                    replaced.add(new Address(alt, name));
                }
                this.getTo().clear();
                for (Address address : replaced) {
                    this.addTo(address);
                }
            }
            if (this.m_from == null) {
                throw new IllegalStateException("No 'from' specified.");
            }
            Message m = new Message();
            m.setFrom(this.m_from);
            for (Address address : this.m_to) {
                m.addTo(address);
            }
            m.setSubject(this.getSubject());
            m.setBody(this.getTextBuffer().toString());
            m.setHtmlBody(this.getHtmlBuffer().toString());
            for (IMailAttachment iMailAttachment : this.getAttachmentList()) {
                m.addAttachment(iMailAttachment);
            }
            if (through instanceof SmtpTransport) {
                ((SmtpTransport)through).send(m);
                return;
            } else if (through instanceof QDataContext) {
                BulkMailer.getInstance().store((QDataContext)through, m);
                return;
            } else {
                if (null != through) throw new IllegalStateException("Unknown store method");
                BulkMailer.getInstance().store(m);
            }
            return;
        } else {
            System.out.println("MAIL: on " + new Date() + " should send to: ");
            for (Address a : this.getTo()) {
                System.out.println("\t" + a.getName() + " [" + a.getEmail() + "]");
            }
            System.out.println("\tSUBJECT: " + this.getSubject());
            System.out.println(this.getTextBuffer().toString());
            System.out.println("--- html ---");
            System.out.println(this.getHtmlBuffer().toString());
            System.out.println("--- end ---");
        }
    }

    @Nonnull
    public StringBuilder getHtmlBuffer() {
        this.init();
        return this.m_html_sb;
    }

    @Nonnull
    public StringBuilder getTextBuffer() {
        this.init();
        return this.m_text_sb;
    }

    @Nonnull
    public List<Attachment> getAttachmentList() {
        return Collections.unmodifiableList(this.m_attachmentList);
    }

    @Nonnull
    public List<Address> getTo() {
        return this.m_to;
    }

    public MailHelper addTo(@Nonnull Address a) {
        this.m_to.add(a);
        return this;
    }

    @Nonnull
    public MailHelper addTo(@Nonnull String email) {
        this.m_to.add(new Address(email));
        return this;
    }

    @Nonnull
    public MailHelper setFrom(@Nonnull String from) {
        this.m_from = new Address(from, from);
        return this;
    }

    @Nonnull
    public MailHelper setFrom(@Nonnull Address from) {
        this.m_from = from;
        return this;
    }

    @Nullable
    public String getSubject() {
        return this.m_subject;
    }

    @Nonnull
    public MailHelper setSubject(@Nonnull String subject) {
        this.m_subject = subject;
        return this;
    }

    public void setLinkRenderer(@Nonnull ITextLinkRenderer linkRenderer) {
        this.m_linkRenderer = linkRenderer;
    }

    public void setApplicationURL(@Nonnull String applicationURL) {
        if (!applicationURL.endsWith("/")) {
            applicationURL = applicationURL + "/";
        }
        this.m_applicationURL = applicationURL;
    }

    @Nullable
    public String getApplicationURL() {
        return this.m_applicationURL;
    }

    protected void addGreeting() {
    }

    protected void addTrailer() throws Exception {
    }

    @Nonnull
    protected InputStream getApplicationResource(@Nonnull String name) throws Exception {
        throw new OperationNotSupportedException("Override getApplicationResource(String)");
    }

    private static class Attachment
    implements IMailAttachment {
        @Nonnull
        public final String m_mime;
        @Nonnull
        public final String m_ident;
        @Nullable
        public final File m_source;
        @Nullable
        private final byte[][] m_buffers;

        public Attachment(@Nonnull String mime, @Nonnull String ident, @Nonnull File source) {
            this.m_mime = mime;
            this.m_ident = ident;
            this.m_source = source;
            this.m_buffers = null;
        }

        public Attachment(@Nonnull String mime, @Nonnull String ident, @Nonnull byte[][] data) {
            this.m_mime = mime;
            this.m_ident = ident;
            this.m_buffers = data;
            this.m_source = null;
        }

        @Nonnull
        public String getIdent() {
            return this.m_ident;
        }

        @Nonnull
        public InputStream getInputStream() throws Exception {
            if (this.m_source != null) {
                return new FileInputStream(this.m_source);
            }
            return new ByteBufferInputStream(this.m_buffers);
        }

        @Nonnull
        public String getMime() {
            return this.m_mime;
        }
    }
}

