/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.mailer;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import to.etc.util.StringTool;
import to.etc.webapp.query.IIdentifyable;

@Immutable
public final class TextLinkInfo {
    private static final Map<String, TextLinkInfo> m_map = new HashMap<String, TextLinkInfo>();
    @Nonnull
    private final String m_rurl;
    @Nonnull
    private final String m_linkname;
    @Nullable
    private final Class<?> m_targetClass;

    TextLinkInfo(@Nonnull String linkname, @Nonnull String rurl, @Nullable Class<?> tgtclass) {
        if (!rurl.contains("{id}")) {
            throw new IllegalArgumentException("The RURL must contain a {id} text where the parameter(s) for the link are to be placed.");
        }
        this.m_rurl = rurl;
        this.m_targetClass = tgtclass;
        this.m_linkname = linkname;
    }

    @Nonnull
    public String getRurl() {
        return this.m_rurl;
    }

    @Nullable
    public Class<?> getTargetClass() {
        return this.m_targetClass;
    }

    @Nonnull
    public String getLinkname() {
        return this.m_linkname;
    }

    public static void register(@Nonnull Class<? extends IIdentifyable<?>> dataclass, @Nonnull String rurl) {
        TextLinkInfo.register(dataclass, dataclass.getName(), rurl);
    }

    public static void register(@Nonnull Class<? extends IIdentifyable<?>> dataclass, @Nonnull String linkname, @Nonnull String rurl) {
        TextLinkInfo li = new TextLinkInfo(linkname, rurl, dataclass);
        if (null != m_map.put(linkname, li)) {
            throw new IllegalStateException("Duplicate link definition: " + linkname + " class=" + dataclass);
        }
    }

    public static void register(@Nonnull String linkname, @Nonnull String rurl) {
        TextLinkInfo li = new TextLinkInfo(linkname, rurl, null);
        if (null != m_map.put(linkname, li)) {
            throw new IllegalStateException("Duplicate link definition: " + linkname + " (no data class)");
        }
    }

    @Nullable
    public static synchronized TextLinkInfo getInfo(String linkName) {
        TextLinkInfo tli = m_map.get(linkName);
        return tli;
    }

    @Nullable
    public static synchronized TextLinkInfo getInfo(@Nullable IIdentifyable<?> instance) {
        if (null == instance) {
            return null;
        }
        Class<?> clz = instance.getClass();
        TextLinkInfo best = null;
        for (TextLinkInfo tl : m_map.values()) {
            Class<?> targetClass = tl.getTargetClass();
            if (targetClass == null || !targetClass.isAssignableFrom(clz)) continue;
            if (best == null) {
                best = tl;
                continue;
            }
            Class<?> bestTargetClass = best.getTargetClass();
            if (null == bestTargetClass) {
                throw new IllegalStateException(best + ": not a class based target");
            }
            if (!bestTargetClass.isAssignableFrom(targetClass)) continue;
            best = tl;
        }
        return best;
    }

    @Nonnull
    public String getFullUrl(@Nonnull String key) {
        String repl = StringTool.encodeURLEncoded((String)key);
        return this.m_rurl.replace("{id}", repl);
    }
}

