/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.nls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.nls.BundleBase;
import to.etc.webapp.nls.IBundle;
import to.etc.webapp.nls.NlsContext;
import to.etc.webapp.nls.NlsMessageProvider;

public final class BundleRef
extends BundleBase
implements IBundle {
    private ClassLoader m_loader;
    @Nullable
    private final String m_bundleKey;
    private NlsMessageProvider m_parent;
    private static Map<Class<?>, Map<String, BundleRef>> m_cachedMap = new HashMap();
    private final Map<Object, Object> m_map = new HashMap<Object, Object>();
    public static final BundleRef DUMMY = new BundleRef();

    private BundleRef() {
        this.m_bundleKey = null;
    }

    BundleRef(@Nonnull String key) {
        this.m_bundleKey = key;
    }

    private BundleRef(@Nullable Class<?> base, @Nonnull String name) {
        this.m_loader = null == base ? null : base.getClassLoader();
        this.m_bundleKey = BundleRef.calcAbsName(base, name);
    }

    private BundleRef(@Nonnull NlsMessageProvider mp) {
        this.m_bundleKey = null;
        this.m_parent = mp;
    }

    public static BundleRef createWrapper(@Nonnull NlsMessageProvider mp) {
        return new BundleRef(mp);
    }

    @Nonnull
    public static synchronized BundleRef create(@Nonnull Class<?> clz, @Nonnull String name) {
        BundleRef ref;
        Map<String, BundleRef> refMap = m_cachedMap.get(clz);
        if (refMap == null) {
            refMap = new HashMap<String, BundleRef>(3);
            m_cachedMap.put(clz, refMap);
        } else {
            ref = refMap.get(name);
            if (ref != null) {
                return ref;
            }
        }
        ref = new BundleRef(clz, name);
        refMap.put(name, ref);
        return ref;
    }

    private static String calcAbsName(Class<?> clz, String name) {
        if (clz == null) {
            return name;
        }
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        if (name.endsWith(".properties")) {
            throw new IllegalArgumentException("Message bundle name may not include the .properties extension");
        }
        String s = clz.getName();
        int pos = s.lastIndexOf(46);
        if (pos == -1) {
            return name;
        }
        return s.substring(0, pos + 1) + name;
    }

    private synchronized ResourceBundle[] getBundleList(Locale loc) {
        ResourceBundle[] r = (ResourceBundle[])this.m_map.get(loc);
        if (r == null) {
            r = this.loadBundleList(loc);
            this.m_map.put(loc, r);
        }
        return r;
    }

    public boolean exists() {
        if (this.m_parent != null) {
            return true;
        }
        return this.getBundleList(Locale.US).length != 0;
    }

    @Override
    public String findMessage(@Nonnull Locale loc, @Nonnull String code) {
        ResourceBundle[] b;
        if (this.m_parent != null) {
            return this.m_parent.findMessage(loc, code);
        }
        for (ResourceBundle rb : b = this.getBundleList(loc)) {
            try {
                return rb.getString(code);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    private synchronized ResourceBundle[] loadBundleList(Locale loc) {
        ArrayList<ResourceBundle> rb = new ArrayList<ResourceBundle>();
        this.tryKey(rb, this.mkSubKey(loc.getLanguage(), loc.getCountry(), loc.getVariant(), NlsContext.getDialect()));
        this.tryKey(rb, this.mkSubKey(loc.getLanguage(), loc.getCountry(), loc.getVariant(), null));
        this.tryKey(rb, this.mkSubKey(loc.getLanguage(), loc.getCountry(), null, NlsContext.getDialect()));
        this.tryKey(rb, this.mkSubKey(loc.getLanguage(), loc.getCountry(), null, null));
        this.tryKey(rb, this.mkSubKey(loc.getLanguage(), null, null, NlsContext.getDialect()));
        this.tryKey(rb, this.mkSubKey(loc.getLanguage(), null, null, null));
        this.tryKey(rb, this.mkSubKey(null, null, null, NlsContext.getDialect()));
        this.tryKey(rb, this.mkSubKey(null, null, null, null));
        return rb.toArray(new ResourceBundle[rb.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void tryKey(List<ResourceBundle> res, String key) {
        String rp;
        ResourceBundle b = (ResourceBundle)this.m_map.get(key);
        if (b != null) {
            res.add(b);
            return;
        }
        ClassLoader ldr = this.m_loader == null ? this.getClass().getClassLoader() : this.m_loader;
        InputStream is = ldr.getResourceAsStream(rp = (this.m_bundleKey + key).replace('.', '/') + ".properties");
        if (is == null) {
            return;
        }
        try {
            PropertyResourceBundle prb = new PropertyResourceBundle(is);
            this.m_map.put(key, prb);
            res.add(prb);
        }
        catch (IOException x) {
            System.err.println("Can't load propertyResourceBundle: " + rp);
            x.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private String mkSubKey(String lang, String country, String variant, String dialect) {
        StringBuilder sb = new StringBuilder(16);
        if (dialect != null) {
            sb.append('_');
            sb.append(dialect);
        }
        if (lang != null) {
            sb.append('_');
            sb.append(lang);
        }
        if (country != null) {
            sb.append('_');
            sb.append(country);
        }
        if (variant != null) {
            sb.append('_');
            sb.append(variant);
        }
        return sb.toString();
    }

    public static synchronized void internalClear() {
        m_cachedMap.clear();
    }

    @Nonnull
    public String getBundleKey() {
        String key = this.m_bundleKey;
        if (null == key) {
            throw new IllegalStateException("Bundle without key");
        }
        return key;
    }
}

