/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.nls;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import to.etc.webapp.nls.BundleBase;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.IBundle;
import to.etc.webapp.nls.NlsMessageProvider;

@Immutable
public class BundleStack
extends BundleBase
implements IBundle {
    @Nonnull
    private final NlsMessageProvider[] m_bundleStack;

    public BundleStack(@Nonnull NlsMessageProvider[] bundleStack) {
        this.m_bundleStack = bundleStack;
    }

    public BundleStack(@Nonnull List<? extends NlsMessageProvider> reflist) {
        this.m_bundleStack = reflist.toArray(new NlsMessageProvider[reflist.size()]);
    }

    @Nullable
    public static BundleStack createStack(Class<?> clz) {
        String pn;
        if (null == clz || clz.isInterface()) {
            throw new IllegalArgumentException(clz + " invalid - cannot be null or interface");
        }
        ArrayList<BundleRef> res = new ArrayList<BundleRef>();
        for (Class<?> cur = clz; cur != null && !(pn = cur.getPackage().getName()).startsWith("java.") && !pn.startsWith("javax."); cur = cur.getSuperclass()) {
            String cn = cur.getName();
            int pos = cn.lastIndexOf(46);
            BundleRef br = BundleRef.create(clz, cn = cn.substring(pos + 1));
            if (br.exists()) {
                res.add(br);
            }
            if ((br = BundleRef.create(clz, "messages")).exists()) {
                res.add(br);
            }
            String pkg = clz.getPackage().getName().replace('.', '/');
            do {
                if ((pos = pkg.lastIndexOf(47)) < 0) {
                    pos = 0;
                }
                pkg = pkg.substring(0, pos);
                br = BundleRef.create(clz, "/" + pkg + "/messages");
                if (!br.exists()) continue;
                res.add(br);
            } while (pos != 0);
        }
        if (res.size() == 0) {
            return null;
        }
        return new BundleStack(res);
    }

    @Override
    public String findMessage(@Nonnull Locale loc, @Nonnull String code) {
        for (int i = 0; i < this.m_bundleStack.length; ++i) {
            String msg = this.m_bundleStack[i].findMessage(loc, code);
            if (null == msg) continue;
            return msg;
        }
        return null;
    }
}

