/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.nls;

import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsContext;

public class CodeException
extends RuntimeException {
    @Nonnull
    private final BundleRef m_bundle;
    @Nonnull
    private final String m_code;
    @Nonnull
    private final Object[] m_parameters;

    public CodeException(@Nonnull BundleRef bundle, @Nonnull String code, Object ... parameters) {
        if (bundle == null || code == null) {
            throw new IllegalArgumentException("Bundle or code cannot be null");
        }
        this.m_bundle = bundle;
        this.m_code = code;
        this.m_parameters = parameters;
    }

    public CodeException(@Nonnull Throwable t, @Nonnull BundleRef bundle, @Nonnull String code, Object ... parameters) {
        super(t);
        if (bundle == null || code == null) {
            throw new IllegalArgumentException("Bundle or code cannot be null");
        }
        this.m_bundle = bundle;
        this.m_code = code;
        this.m_parameters = parameters;
    }

    @Nonnull
    public BundleRef getBundle() {
        return this.m_bundle;
    }

    @Nonnull
    public String getCode() {
        return this.m_code;
    }

    @Nullable
    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public String getMessage() {
        Locale loc = NlsContext.getLocale();
        String msg = this.m_bundle.getString(this.m_code);
        MessageFormat temp = new MessageFormat(msg, loc);
        return temp.format(this.m_parameters);
    }
}

