/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.nls;

import java.text.DateFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsCodeTable;

public final class NlsContext {
    private static Map<String, BundleRef> m_refMap = new HashMap<String, BundleRef>();
    private static String m_dialect;
    private static Locale m_defaultCurrencyLocale;
    private static final ThreadLocal<Locale> m_currentLocale;
    private static final ThreadLocal<Locale> m_currencyLocale;
    private static final ThreadLocal<Currency> m_currency;

    private NlsContext() {
    }

    public static Locale getDefault() {
        return Locale.getDefault();
    }

    public static synchronized void setDefaultCurrencyLocale(Locale defaultCurrencyLocale) {
        m_defaultCurrencyLocale = defaultCurrencyLocale;
    }

    public static synchronized Locale getDefaultCurrencyLocale() {
        return m_defaultCurrencyLocale == null ? NlsContext.getDefault() : m_defaultCurrencyLocale;
    }

    public static Locale getCurrencyLocale() {
        Locale loc = m_currencyLocale.get();
        return loc == null ? NlsContext.getDefaultCurrencyLocale() : loc;
    }

    public static void setCurrencyLocale(Locale loc) {
        m_currencyLocale.set(loc);
        m_currency.set(Currency.getInstance(loc));
    }

    public static Currency getCurrency() {
        Currency c = m_currency.get();
        if (c != null) {
            return c;
        }
        c = Currency.getInstance(NlsContext.getCurrencyLocale());
        m_currency.set(c);
        return c;
    }

    public static String getCurrencySymbol() {
        Currency c = NlsContext.getCurrency();
        String s = c.getSymbol(NlsContext.getLocale());
        if ("EUR".equals(s)) {
            s = "\u20ac";
        }
        return s;
    }

    public static synchronized String getDialect() {
        return m_dialect;
    }

    public static synchronized void setDialect(String dialect) {
        m_dialect = dialect;
    }

    public static Locale getLocale() {
        Locale loc = m_currentLocale.get();
        if (loc == null) {
            return NlsContext.getDefault();
        }
        return loc;
    }

    public static void setLocale(Locale loc) {
        m_currentLocale.set(loc);
    }

    public static synchronized BundleRef getBundleRef(String bundlekey) {
        BundleRef r = m_refMap.get(bundlekey);
        if (r == null) {
            r = new BundleRef(bundlekey);
            m_refMap.put(bundlekey, r);
        }
        return r;
    }

    public static DateFormat getDateFormat(int style) {
        return DateFormat.getDateInstance(style, NlsContext.getLocale());
    }

    public static DateFormat getDateTimeFormat(int s1, int s2) {
        return DateFormat.getDateTimeInstance(s1, s2, NlsContext.getLocale());
    }

    public static NlsCodeTable createCodeTable(String name) {
        return new NlsCodeTable(name);
    }

    public static String getCodeDescription(String tablename, String code, String defmsg) {
        return defmsg;
    }

    static {
        m_currentLocale = new ThreadLocal();
        m_currencyLocale = new ThreadLocal();
        m_currency = new ThreadLocal();
    }
}

