/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.pendingoperations;

import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nonnull;
import to.etc.util.ILogSink;
import to.etc.util.IProgressListener;
import to.etc.util.Progress;
import to.etc.webapp.pendingoperations.IPendingJob;
import to.etc.webapp.pendingoperations.IPendingOperationExecutor;
import to.etc.webapp.pendingoperations.PendingOperation;
import to.etc.webapp.pendingoperations.PendingOperationState;
import to.etc.webapp.pendingoperations.PendingOperationTaskProvider;

public class PendingJobExecutor
implements Runnable {
    private final PendingOperation m_pendingOperation;
    private final ILogSink m_logSink;
    private static final long TIME_DELTA = 3000L;
    private static final int VALUE_DELTA = 20;
    private int m_lastUpdatePercent = 0;
    private Date m_lastUpdateTime;

    public PendingJobExecutor(PendingOperation pendingOperation, ILogSink sink) {
        this.m_pendingOperation = pendingOperation;
        this.m_logSink = sink;
    }

    public static void register() {
        PendingOperationTaskProvider.getInstance().registerPendingOperationType("PJEX", new IPendingOperationExecutor(){

            @Override
            public void executePendingOperation(@Nonnull PendingOperation po, @Nonnull ILogSink ls) throws Exception {
                new PendingJobExecutor(po, ls).run();
            }
        });
    }

    public static void registerOperation(String userid, String submitter, String desc, String externalId, IPendingJob operation) throws Exception {
        PendingOperation po = new PendingOperation();
        po.setCreationTime(new Date());
        po.setUserID(userid);
        po.setDescription(desc);
        po.setSubmitsource(submitter);
        po.setXid(externalId);
        po.setType("PJEX");
        PendingOperationTaskProvider.getInstance().saveOperation(po, operation);
    }

    public ILogSink getLogSink() {
        return this.m_logSink;
    }

    public PendingOperation getPendingOperation() {
        return this.m_pendingOperation;
    }

    @Override
    public void run() {
        try {
            IPendingJob j = (IPendingJob)this.m_pendingOperation.getSerializedObject();
            Progress p = this.prepareJobProgress();
            j.execute(this.m_logSink, this.m_pendingOperation, p);
        }
        catch (Exception x) {
            this.m_logSink.exception((Throwable)x, "in executing pending job");
            this.m_pendingOperation.setError(PendingOperationState.FATL, "Error: " + x);
        }
    }

    private Progress prepareJobProgress() {
        Progress p = new Progress("Job");
        p.setTotalWork(100.0);
        p.addListener(new IProgressListener(){

            private long deltaInMilliseconds(Date start, Date end) {
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(start);
                Calendar endCal = Calendar.getInstance();
                endCal.setTime(end);
                return endCal.getTimeInMillis() - startCal.getTimeInMillis();
            }

            private boolean doUpdate(Progress level) {
                return PendingJobExecutor.this.getLastUpdatePercent() == 0 || this.deltaInMilliseconds(PendingJobExecutor.this.getLastUpdateTime(), new Date()) > 3000L || level.getPercentage() - PendingJobExecutor.this.getLastUpdatePercent() > 20;
            }

            public void progressed(@Nonnull Progress level) throws Exception {
                if (this.doUpdate(level)) {
                    PendingJobExecutor.this.getPendingOperation().setProgressPath(level.getActionPath(3));
                    PendingJobExecutor.this.getPendingOperation().setProgressPercentage(level.getPercentage());
                    PendingOperationTaskProvider.getInstance().updateProgress(PendingJobExecutor.this.getPendingOperation());
                    PendingJobExecutor.this.setLastUpdatePercent(level.getPercentage());
                    PendingJobExecutor.this.setLastUpdateTime(new Date());
                }
            }
        });
        return p;
    }

    public int getLastUpdatePercent() {
        return this.m_lastUpdatePercent;
    }

    public void setLastUpdatePercent(int lastUpdatePercent) {
        this.m_lastUpdatePercent = lastUpdatePercent;
    }

    public Date getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.m_lastUpdateTime = lastUpdateTime;
    }

    public static synchronized void startOperation(String userid, String submitter, String desc, String externalId, IPendingJob operation) throws Exception {
        if (!PendingOperationTaskProvider.getInstance().isBusyWithJob(externalId)) {
            PendingJobExecutor.registerOperation(userid, submitter, desc, externalId, operation);
        }
    }
}

