/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.pendingoperations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import to.etc.util.ClassUtil;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.util.WrappedDatabaseInputStream;
import to.etc.webapp.pendingoperations.PendingOperationSerializationException;
import to.etc.webapp.pendingoperations.PendingOperationState;

public class PendingOperation {
    static final String[] FLDAR = new String[]{"spo_xident", "spo_issuing_server", "spo_date_created", "spo_must_execute_on_server", "spo_executing_server", "spo_last_execute_started", "spo_last_execute_completed", "spo_state", "spo_retries", "spo_date_next_try", "spo_order_groupname", "spo_order_timestamp", "spo_order_sub", "spo_type", "spo_arg1", "spo_arg2", "spo_lasterror", "spo_errorlog", "spo_userid", "spo_description", "spo_submitsource", "progress_path", "progress_percentage"};
    static final String FIELDS = "spo_id,spo_xident,spo_issuing_server,spo_date_created,spo_must_execute_on_server,spo_executing_server,spo_last_execute_started,spo_last_execute_completed,spo_state,spo_retries,spo_date_next_try,spo_order_groupname,spo_order_timestamp,spo_order_sub,spo_type,spo_arg1,spo_arg2,spo_lasterror, spo_errorlog, spo_userid,spo_description,spo_submitsource,progress_path,progress_percentage";
    private long m_id = -1L;
    private String m_xid;
    private String m_sourceServerID;
    private Date m_creationTime;
    private String m_mustExecuteOnServerID;
    private String m_executesOnServerID;
    private Date m_lastExecutionStart;
    private Date m_lastExecutionEnd;
    private int m_retries;
    private Date m_nextTryTime;
    private String m_orderGroup;
    private Date m_orderTime;
    private int m_orderIndex;
    private String m_type;
    private String m_arg1;
    private Properties m_properties;
    private String m_lastError;
    private String m_errorLog;
    private PendingOperationState m_state = PendingOperationState.RTRY;
    private String m_userID;
    private String m_description;
    private String m_submitsource;
    private Object m_serializedObject;
    private DataSource m_dataSource;
    private static String m_updateSQL;
    private static String m_insertSQL;
    private String m_progressPath;
    private int m_progressPercentage = 0;

    public long getId() {
        return this.m_id;
    }

    public void setId(long id) {
        this.m_id = id;
    }

    public String getXid() {
        return this.m_xid;
    }

    public void setXid(String xid) {
        this.m_xid = xid;
    }

    public String getSourceServerID() {
        return this.m_sourceServerID;
    }

    public void setSourceServerID(String sourceServerID) {
        this.m_sourceServerID = sourceServerID;
    }

    public Date getCreationTime() {
        return this.m_creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.m_creationTime = creationTime;
    }

    public String getMustExecuteOnServerID() {
        return this.m_mustExecuteOnServerID;
    }

    public void setMustExecuteOnServerID(String mustExecuteOnServerID) {
        this.m_mustExecuteOnServerID = mustExecuteOnServerID;
    }

    public String getExecutesOnServerID() {
        return this.m_executesOnServerID;
    }

    public void setExecutesOnServerID(String executesOnServerID) {
        this.m_executesOnServerID = executesOnServerID;
    }

    public Date getLastExecutionStart() {
        return this.m_lastExecutionStart;
    }

    public void setLastExecutionStart(Date lastExecutionStart) {
        this.m_lastExecutionStart = lastExecutionStart;
    }

    public Date getLastExecutionEnd() {
        return this.m_lastExecutionEnd;
    }

    public void setLastExecutionEnd(Date lastExecutionEnd) {
        this.m_lastExecutionEnd = lastExecutionEnd;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public Date getNextTryTime() {
        return this.m_nextTryTime;
    }

    public void setNextTryTime(Date nextTryTime) {
        this.m_nextTryTime = nextTryTime;
    }

    public String getOrderGroup() {
        return this.m_orderGroup;
    }

    public void setOrderGroup(String orderGroup) {
        this.m_orderGroup = orderGroup;
    }

    public Date getOrderTime() {
        return this.m_orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.m_orderTime = orderTime;
    }

    public int getOrderIndex() {
        return this.m_orderIndex;
    }

    public void setOrderIndex(int orderIndex) {
        this.m_orderIndex = orderIndex;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getArg1() {
        return this.m_arg1;
    }

    public void setArg1(String arg1) {
        this.m_arg1 = arg1;
    }

    public String getProperty(String name) {
        return this.m_properties == null ? null : this.m_properties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            if (this.m_properties != null) {
                this.m_properties.remove(name);
                if (this.m_properties.size() == 0) {
                    this.m_properties = null;
                }
            }
        } else {
            if (this.m_properties == null) {
                this.m_properties = new Properties();
            }
            this.m_properties.setProperty(name, value);
        }
    }

    public String getLastError() {
        return this.m_lastError;
    }

    public void setLastError(String lastError) {
        this.m_lastError = lastError;
    }

    public String getErrorLog() {
        return this.m_errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.m_errorLog = errorLog;
    }

    public PendingOperationState getState() {
        return this.m_state;
    }

    public void setState(PendingOperationState state) {
        this.m_state = state;
    }

    public String getUserID() {
        return this.m_userID;
    }

    public void setUserID(String userID) {
        this.m_userID = userID;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getSubmitsource() {
        return this.m_submitsource;
    }

    public void setSubmitsource(String submitsource) {
        this.m_submitsource = submitsource;
    }

    public String getProgressPath() {
        return this.m_progressPath;
    }

    public void setProgressPath(String progressPath) {
        this.m_progressPath = progressPath;
    }

    public int getProgressPercentage() {
        return this.m_progressPercentage;
    }

    public void setProgressPercentage(int progressPercentage) {
        this.m_progressPercentage = progressPercentage;
    }

    public Object getSerializedObject() throws SQLException {
        if (this.m_serializedObject == null) {
            Connection dbc = this.getDS().getConnection();
            try {
                this.loadSerialized(dbc);
            }
            finally {
                try {
                    dbc.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.m_serializedObject;
    }

    public void setSerializedObject(Object serializedObject) {
        this.m_serializedObject = serializedObject;
    }

    public InputStream getSerializedStream() throws SQLException {
        Connection dbc = this.getDS().getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        InputStream is = null;
        ps = dbc.prepareStatement("select spo_serialized from sys_pending_operations where spo_id=?");
        ps.setLong(1, this.m_id);
        rs = ps.executeQuery();
        if (!rs.next()) {
            throw new SQLException("sys_pending_operations.id=" + this.m_id + " is not found");
        }
        Blob b = rs.getBlob(1);
        if (b == null) {
            InputStream inputStream = null;
            return inputStream;
        }
        is = b.getBinaryStream();
        if (is == null) {
            InputStream inputStream = null;
            return inputStream;
        }
        WrappedDatabaseInputStream res = new WrappedDatabaseInputStream(dbc, (Statement)ps, rs, is);
        dbc = null;
        ps = null;
        rs = null;
        is = null;
        WrappedDatabaseInputStream wrappedDatabaseInputStream = res;
        return wrappedDatabaseInputStream;
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void initFromRS(ResultSet rs) throws SQLException {
        String pro;
        int f = 1;
        this.m_id = rs.getLong(f++);
        this.m_xid = rs.getString(f++);
        this.m_sourceServerID = rs.getString(f++);
        this.m_creationTime = rs.getTimestamp(f++);
        this.m_mustExecuteOnServerID = rs.getString(f++);
        this.m_executesOnServerID = rs.getString(f++);
        this.m_lastExecutionStart = rs.getTimestamp(f++);
        this.m_lastExecutionEnd = rs.getTimestamp(f++);
        this.m_state = PendingOperationState.valueOf(rs.getString(f++));
        this.m_retries = rs.getInt(f++);
        this.m_nextTryTime = rs.getTimestamp(f++);
        this.m_orderGroup = rs.getString(f++);
        this.m_orderTime = rs.getTimestamp(f++);
        this.m_orderIndex = rs.getInt(f++);
        this.m_type = rs.getString(f++);
        this.m_arg1 = rs.getString(f++);
        if ((pro = rs.getString(f++)) == null) {
            this.m_properties = null;
        } else {
            this.m_properties = new Properties();
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(pro.getBytes("iso-8859-1"));
                this.m_properties.load(baos);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        this.m_lastError = rs.getString(f++);
        this.m_errorLog = rs.getString(f++);
        this.m_userID = rs.getString(f++);
        this.m_description = rs.getString(f++);
        this.m_submitsource = rs.getString(f++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@Nonnull Connection dbc) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = dbc.prepareStatement("delete from sys_pending_operations where spo_id=?");
            ps.setLong(1, this.getId());
            ps.executeUpdate();
            this.setId(-1L);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Connection dbc) throws SQLException {
        Statement ps = null;
        try {
            if (this.m_id == -1L) {
                CallableStatement cs = dbc.prepareCall(m_insertSQL);
                ps = cs;
            } else {
                ps = dbc.prepareStatement(m_updateSQL);
            }
            if (this.m_state != PendingOperationState.EXEC) {
                this.m_executesOnServerID = null;
            }
            int f = 1;
            ps.setString(f++, this.m_xid);
            ps.setString(f++, this.m_sourceServerID);
            ps.setTimestamp(f++, this.m_creationTime == null ? null : new Timestamp(this.m_creationTime.getTime()));
            ps.setString(f++, this.m_mustExecuteOnServerID);
            ps.setString(f++, this.m_executesOnServerID);
            ps.setTimestamp(f++, this.m_lastExecutionStart == null ? null : new Timestamp(this.m_lastExecutionStart.getTime()));
            ps.setTimestamp(f++, this.m_lastExecutionEnd == null ? null : new Timestamp(this.m_lastExecutionEnd.getTime()));
            ps.setString(f++, this.m_state.name());
            ps.setInt(f++, this.m_retries);
            ps.setTimestamp(f++, this.m_nextTryTime == null ? null : new Timestamp(this.m_nextTryTime.getTime()));
            ps.setString(f++, this.m_orderGroup);
            ps.setTimestamp(f++, this.m_orderTime == null ? null : new Timestamp(this.m_orderTime.getTime()));
            ps.setInt(f++, this.m_orderIndex);
            ps.setString(f++, this.m_type);
            ps.setString(f++, this.m_arg1);
            String pro = null;
            if (this.m_properties != null && this.m_properties.size() != 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                try {
                    this.m_properties.store(baos, "-");
                    pro = new String(baos.toByteArray(), "iso-8859-1");
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
                if (pro == null || pro.length() > 4000) {
                    throw new IllegalStateException("Properties string is too long for PendingOperation. or it is null!?");
                }
            }
            ps.setString(f++, pro);
            ps.setString(f++, this.m_lastError);
            ps.setString(f++, this.m_errorLog);
            ps.setString(f++, this.m_userID);
            ps.setString(f++, this.m_description);
            ps.setString(f++, this.m_submitsource);
            ps.setString(f++, this.m_progressPath);
            ps.setInt(f++, this.m_progressPercentage);
            if (this.m_id != -1L) {
                ps.setLong(f++, this.m_id);
            } else {
                CallableStatement cs = (CallableStatement)ps;
                cs.registerOutParameter(f, 2);
            }
            int rc = ps.executeUpdate();
            if (rc != 1) {
                throw new SQLException("Update count incorrect: " + rc);
            }
            if (this.m_id == -1L) {
                CallableStatement cs = (CallableStatement)ps;
                this.m_id = cs.getLong(f);
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private DataSource getDS() {
        if (this.m_dataSource == null) {
            throw new IllegalStateException("No datasource known.");
        }
        return this.m_dataSource;
    }

    void setDS(DataSource ds) {
        this.m_dataSource = ds;
    }

    private Object loadSerialized(Connection dbc) throws SQLException {
        if (this.m_serializedObject != null) {
            return this.m_serializedObject;
        }
        if (this.m_id == -1L) {
            throw new IllegalStateException("Cannot load a LOB from a record that is not stored");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        InputStream is = null;
        try {
            ps = dbc.prepareStatement("select spo_serialized from sys_pending_operations where spo_id=?");
            ps.setLong(1, this.m_id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("sys_pending_operations.id=" + this.m_id + " is not found");
            }
            Blob b = rs.getBlob(1);
            if (b == null) {
                Object var6_6 = null;
                return var6_6;
            }
            is = b.getBinaryStream();
            if (is == null) {
                Object var6_7 = null;
                return var6_7;
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            Object object = this.m_serializedObject = ois.readObject();
            return object;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStream(Connection dbc, InputStream is) throws SQLException, IOException {
        dbc.setAutoCommit(false);
        if (this.m_id == -1L) {
            throw new IllegalStateException("Cannot store a LOB in a record that is not stored");
        }
        Statement ps = null;
        ResultSet rs = null;
        OutputStream os = null;
        try {
            ps = dbc.prepareStatement("update sys_pending_operations set spo_serialized=" + (is == null ? "null" : "empty_blob()") + " where spo_id=?");
            ps.setLong(1, this.m_id);
            int rc = ps.executeUpdate();
            if (rc != 1) {
                throw new SQLException("Update count <> 1: " + rc);
            }
            if (is == null) {
                return;
            }
            ps.close();
            ps = dbc.prepareStatement("select spo_serialized from sys_pending_operations where spo_id=? for update of spo_serialized");
            ps.setLong(1, this.m_id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Cannot re-find sys_pending_operations.id=" + this.m_id);
            }
            Blob tb = rs.getBlob(1);
            os = (OutputStream)ClassUtil.callObjectMethod((Object)tb, (String)"getBinaryOutputStream", (Class[])new Class[0], (Object[])new Object[0]);
            if (null == os) {
                throw new PendingOperationSerializationException("Failed to serialize object from pendingOperation=" + this.m_id + ": cannot get blob output stream");
            }
            try {
                FileTool.copyFile((OutputStream)os, (InputStream)is);
                os.close();
            }
            catch (Exception x) {
                throw new PendingOperationSerializationException("Failed to serialize object from pendingOperation=" + this.m_id + ": " + x, x);
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveSerialized(Connection dbc) throws SQLException {
        dbc.setAutoCommit(false);
        if (this.m_id == -1L) {
            throw new IllegalStateException("Cannot store a LOB in a record that is not stored");
        }
        Statement ps = null;
        ResultSet rs = null;
        OutputStream os = null;
        try {
            ps = dbc.prepareStatement("update sys_pending_operations set spo_serialized=" + (this.m_serializedObject == null ? "null" : "empty_blob()") + " where spo_id=?");
            ps.setLong(1, this.m_id);
            int rc = ps.executeUpdate();
            if (rc != 1) {
                throw new SQLException("Update count <> 1: " + rc);
            }
            if (this.m_serializedObject == null) {
                return;
            }
            ps.close();
            ps = dbc.prepareStatement("select spo_serialized from sys_pending_operations where spo_id=? for update of spo_serialized");
            ps.setLong(1, this.m_id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Cannot re-find sys_pending_operations.id=" + this.m_id);
            }
            Blob tb = rs.getBlob(1);
            os = (OutputStream)ClassUtil.callObjectMethod((Object)tb, (String)"getBinaryOutputStream", (Class[])new Class[0], (Object[])new Object[0]);
            try {
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(this.m_serializedObject);
                oos.close();
            }
            catch (Exception x) {
                throw new PendingOperationSerializationException("Failed to serialize object from pendingOperation=" + this.m_id + ": " + x, x);
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setError(PendingOperationState rtry, String string) {
        this.m_state = rtry;
        this.m_lastError = StringTool.strTrunc((String)string, (int)250);
    }

    static {
        StringBuilder sb = new StringBuilder(512);
        sb.append("begin ");
        StringTool.createInsertStatement((StringBuilder)sb, (String)"sys_pending_operations", (String)"spo_id", (String)"sys_spo_seq.nextval", (String[])FLDAR);
        sb.append(" returning spo_id into ?; end;");
        m_insertSQL = sb.toString();
        sb.setLength(0);
        StringTool.createUpdateStatement((StringBuilder)sb, (String)"sys_pending_operations", (String)"spo_id", (String[])FLDAR);
        m_updateSQL = sb.toString();
    }
}

