/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.pendingoperations;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.ILogSink;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.webapp.pendingoperations.IPendingOperationExecutor;
import to.etc.webapp.pendingoperations.IPendingOperationExecutor2;
import to.etc.webapp.pendingoperations.IPendingOperationListener;
import to.etc.webapp.pendingoperations.PendingOperation;
import to.etc.webapp.pendingoperations.PendingOperationState;
import to.etc.webapp.pendingoperations.PendingOperationTaskProvider;

public final class PendingOperationTask
implements Runnable,
ILogSink {
    private final PendingOperationTaskProvider m_provider;
    private final List<PendingOperation> m_list;
    private StringWriter m_logWriter;
    private PrintWriter m_errorWriter;

    public PendingOperationTask(PendingOperationTaskProvider provider, List<PendingOperation> list) {
        this.m_provider = provider;
        this.m_list = list;
    }

    @Override
    public void run() {
        int lsz = this.m_list.size() + 1;
        try {
            while (this.m_list.size() > 0) {
                HashSet<PendingOperation> upset = new HashSet<PendingOperation>();
                if (lsz == this.m_list.size()) {
                    throw new IllegalStateException("LOOP DETECT");
                }
                lsz = this.m_list.size();
                PendingOperation op = this.m_list.remove(0);
                upset.add(op);
                this.runOperation(op);
                if (op.getState() == PendingOperationState.EXEC) {
                    throw new IllegalStateException("Still in state EXEC after run");
                }
                if (op.getLastExecutionEnd() == null) {
                    op.setLastExecutionEnd(new Date());
                }
                op.setExecutesOnServerID(null);
                if (op.getErrorLog() != null) {
                    op.setErrorLog(op.getErrorLog() + "\n" + this.m_logWriter.getBuffer().toString());
                } else {
                    op.setErrorLog(this.m_logWriter.getBuffer().toString());
                }
                PendingOperation deleteme = null;
                if (op.getState() != PendingOperationState.DONE) {
                    boolean fail = true;
                    try {
                        IPendingOperationExecutor2 px2;
                        IPendingOperationExecutor pox = this.m_provider.findExecutor(op);
                        if (null != pox && pox instanceof IPendingOperationExecutor2 && (px2 = (IPendingOperationExecutor2)pox).isSkipFailedAllowed(op)) {
                            fail = false;
                            deleteme = op;
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    if (fail) {
                        for (PendingOperation opo : this.m_list) {
                            opo.setState(op.getState());
                            opo.setNextTryTime(op.getNextTryTime());
                            opo.setExecutesOnServerID(null);
                            upset.add(opo);
                        }
                        this.handleDatabaseUpdate(upset, null);
                        return;
                    }
                }
                PendingOperation nextop = null;
                if (this.m_list.size() > 0) {
                    nextop = this.m_list.get(0);
                    nextop.setLastExecutionStart(new Date());
                    nextop.setLastExecutionEnd(null);
                    nextop.setState(PendingOperationState.EXEC);
                    nextop.setLastError(null);
                    if (!this.m_provider.getServerID().equals(nextop.getExecutesOnServerID())) {
                        throw new IllegalStateException("Next pendingOp not allocated to run on THIS server!?");
                    }
                    upset.add(nextop);
                }
                this.handleDatabaseUpdate(upset, deleteme);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDatabaseUpdate(@Nonnull Set<PendingOperation> updateset, @Nullable PendingOperation deleteme) throws Exception {
        if (updateset.size() == 0) {
            return;
        }
        Connection dbc = this.m_provider.allocateConnection();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuilder sb = new StringBuilder(128);
            sb.append("select * from sys_pending_operations where spo_id in (");
            int ct = 0;
            for (PendingOperation po : updateset) {
                if (ct++ > 0) {
                    sb.append(",");
                }
                sb.append(po.getId());
            }
            sb.append(") for update");
            ps = dbc.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            rs.close();
            if (deleteme != null) {
                deleteme.delete(dbc);
            }
            updateset.remove(deleteme);
            for (PendingOperation po : updateset) {
                po.save(dbc);
            }
            dbc.commit();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                dbc.close();
            }
            catch (Exception exception) {}
        }
    }

    public void exception(@Nonnull Throwable t, @Nonnull String msg) {
        this.m_errorWriter.println("[exception] " + msg);
        t.printStackTrace(this.m_errorWriter);
        System.err.println("[pending task exception] " + msg);
    }

    public void log(@Nonnull String msg) {
        this.m_errorWriter.println("[log] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOperation(PendingOperation po) {
        if (this.m_logWriter == null) {
            this.m_logWriter = new StringWriter(8192);
        } else {
            this.m_logWriter.getBuffer().setLength(0);
        }
        this.m_errorWriter = new PrintWriter(this.m_logWriter);
        po.setDS(this.m_provider.getDataSource());
        po.setState(PendingOperationState.EXEC);
        Throwable errx = null;
        try {
            this.m_errorWriter.println("Execute #" + po.getRetries() + " starting, at " + po.getLastExecutionStart() + " on server " + po.getExecutesOnServerID());
            IPendingOperationExecutor pox = this.m_provider.findExecutor(po);
            if (pox == null) {
                String msg = "Internal error: cannot find an executor for operation=" + po.getId() + ", type=" + po.getType() + ", arg1=" + po.getArg1();
                this.m_errorWriter.println(msg);
                po.setLastError(StringTool.strTrunc((String)msg, (int)250));
                po.setState(PendingOperationState.BOOT);
                po.setExecutesOnServerID(null);
                return;
            }
            for (IPendingOperationListener pol : this.m_provider.getListeners()) {
                pol.beforeOperation(po);
            }
            po.setNextTryTime(null);
            pox.executePendingOperation(po, this);
            if (po.getState() == PendingOperationState.EXEC) {
                this.m_errorWriter.println("*warning: the pending operation did not clear the run state - assuming the execution was succesful");
                po.setState(PendingOperationState.DONE);
            } else if (po.getState() == PendingOperationState.RTRY && po.getNextTryTime() == null) {
                po.setNextTryTime(new Date(System.currentTimeMillis() + this.waitTimeFor(po.getRetries())));
            }
        }
        catch (Exception inx) {
            Throwable x;
            errx = x = inx instanceof WrappedException ? inx.getCause() : inx;
            if (po.getState() == PendingOperationState.EXEC) {
                po.setState(PendingOperationState.FATL);
            }
            if (po.getState() == PendingOperationState.RTRY) {
                po.setNextTryTime(new Date(System.currentTimeMillis() + this.waitTimeFor(po.getRetries())));
            }
            this.m_errorWriter.println("Unexpected EXCEPTION: " + x);
            x.printStackTrace(this.m_errorWriter);
            this.m_errorWriter.println("Execution completed UNSUCCESFULLY with state=" + (Object)((Object)po.getState()));
            po.setLastError(StringTool.strTrunc((String)x.toString(), (int)250));
        }
        finally {
            for (IPendingOperationListener pol : this.m_provider.getListeners()) {
                try {
                    pol.afterOperation(po, errx);
                }
                catch (Exception x) {
                    this.m_errorWriter.println("Listener " + pol + " failed with " + x);
                    x.printStackTrace(this.m_errorWriter);
                }
            }
        }
        for (IPendingOperationListener pol : this.m_provider.getListeners()) {
            try {
                pol.afterOperation(po, errx);
            }
            catch (Exception x) {
                this.m_errorWriter.println("Listener " + pol + " failed with " + x);
                x.printStackTrace(this.m_errorWriter);
            }
        }
    }

    private long waitTimeFor(int runtimes) {
        if (runtimes < 4) {
            return 60000L;
        }
        if (runtimes < 8) {
            return 600000L;
        }
        if (runtimes < 12) {
            return 3600000L;
        }
        if (runtimes < 20) {
            return 86400000L;
        }
        return Long.MAX_VALUE;
    }
}

