/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.pendingoperations;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.util.StringInputStream;
import to.etc.webapp.pendingoperations.IPendingOperationExecutor;
import to.etc.webapp.pendingoperations.IPendingOperationExecutor2;
import to.etc.webapp.pendingoperations.IPendingOperationListener;
import to.etc.webapp.pendingoperations.IPollQueueTaskProvider;
import to.etc.webapp.pendingoperations.PendingJobProgressInfo;
import to.etc.webapp.pendingoperations.PendingOperation;
import to.etc.webapp.pendingoperations.PendingOperationState;
import to.etc.webapp.pendingoperations.PendingOperationTask;
import to.etc.webapp.pendingoperations.PollingWorkerQueue;

public class PendingOperationTaskProvider
implements IPollQueueTaskProvider {
    private static PendingOperationTaskProvider m_instance = new PendingOperationTaskProvider();
    private PollingWorkerQueue m_executor;
    private DataSource m_ds;
    private String m_serverID;
    private boolean m_inUse;
    private int m_lastSelectedIndex;
    private long m_tsNextCheck;
    private long m_tsNextCleanup;
    private List<IPendingOperationListener> m_listeners = Collections.EMPTY_LIST;
    private final Map<String, IPendingOperationExecutor> m_typeMap = new HashMap<String, IPendingOperationExecutor>();

    private PendingOperationTaskProvider() {
    }

    public static void initialize(DataSource ds, String serverID) {
        m_instance.internalInitialize(ds, serverID);
    }

    private synchronized void internalInitialize(DataSource ds, String serverID) {
        if (this.m_executor != null) {
            throw new IllegalStateException("Attempt to re-initialize");
        }
        this.m_serverID = serverID;
        this.m_ds = ds;
        PollingWorkerQueue.getInstance().registerProvider(this);
        this.m_executor = PollingWorkerQueue.getInstance();
    }

    public static PendingOperationTaskProvider getInstance() {
        return m_instance;
    }

    public synchronized void addListener(IPendingOperationListener l) {
        this.m_listeners = new ArrayList<IPendingOperationListener>(this.m_listeners);
        this.m_listeners.add(l);
    }

    public synchronized void removeListener(IPendingOperationListener l) {
        this.m_listeners = new ArrayList<IPendingOperationListener>(this.m_listeners);
        this.m_listeners.remove(l);
    }

    synchronized List<IPendingOperationListener> getListeners() {
        return this.m_listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeOnRegistration(PollingWorkerQueue pwq) throws Exception {
        this.m_executor = pwq;
        Connection dbc = this.m_ds.getConnection();
        PreparedStatement ps = null;
        try {
            ps = dbc.prepareStatement("update sys_pending_operations set spo_executing_server=null,spo_state='RTRY',spo_retries=spo_retries+1,spo_lasterror='Server has died' where spo_executing_server=?");
            ps.setString(1, this.m_serverID);
            ps.executeUpdate();
            ps.close();
            dbc.commit();
            ps = dbc.prepareStatement("update sys_pending_operations set spo_executing_server=null,spo_state='RTRY',spo_retries=spo_retries+1 where spo_state='BOOT'");
            ps.executeUpdate();
            ps.close();
            dbc.commit();
            ps = dbc.prepareStatement("update sys_pending_operations set spo_executing_server=null where spo_executing_server is not null and spo_state='RTRY'");
            int rc = ps.executeUpdate();
            if (rc != 0) {
                System.out.println("pwq: ERROR: found " + rc + " pending operations in RTRY state with executing_server set to non-null!???");
            }
            ps.close();
            dbc.commit();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable getRunnableTask() throws Exception {
        long cts = System.currentTimeMillis();
        boolean cleanup = false;
        PendingOperationTaskProvider pendingOperationTaskProvider = this;
        synchronized (pendingOperationTaskProvider) {
            if (this.m_inUse || cts < this.m_tsNextCheck) {
                return null;
            }
            this.m_inUse = true;
            if (cts >= this.m_tsNextCleanup) {
                cleanup = true;
                this.m_tsNextCleanup = 14400000L;
            }
        }
        if (cleanup) {
            this.cleanupDatabase();
        }
        try {
            Runnable task = this.findBestTask();
            if (task != null) {
                this.m_executor.checkProvider(this);
            }
            Runnable runnable = task;
            return runnable;
        }
        finally {
            PendingOperationTaskProvider pendingOperationTaskProvider2 = this;
            synchronized (pendingOperationTaskProvider2) {
                this.m_inUse = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDatabase() {
        Connection dbc = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            dbc = this.m_ds.getConnection();
            Timestamp ts1 = new Timestamp(System.currentTimeMillis() - 86400000L);
            Timestamp ts2 = new Timestamp(System.currentTimeMillis() - 604800000L);
            ps = dbc.prepareStatement("delete from sys_pending_operations where (spo_date_created < ?) or (spo_date_created < ? and spo_state = 'DONE')");
            ps.setTimestamp(1, ts2);
            ps.setTimestamp(2, ts1);
            ps.executeUpdate();
            dbc.commit();
        }
        catch (Exception x) {
            System.err.println("PendingOperations: EXCEPTION while cleaning up the database: " + x);
            x.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.rollback();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable findBestTask() throws Exception {
        Object object;
        List<PendingOperation> resultlist;
        ResultSet rs;
        Statement ps;
        Connection dbc;
        block38: {
            PendingOperation po;
            List<PendingOperation> grouplist;
            dbc = this.m_ds.getConnection();
            ps = null;
            rs = null;
            Date now = new Date();
            dbc.setAutoCommit(false);
            ps = dbc.prepareStatement("select spo_id,spo_xident,spo_issuing_server,spo_date_created,spo_must_execute_on_server,spo_executing_server,spo_last_execute_started,spo_last_execute_completed,spo_state,spo_retries,spo_date_next_try,spo_order_groupname,spo_order_timestamp,spo_order_sub,spo_type,spo_arg1,spo_arg2,spo_lasterror, spo_errorlog, spo_userid,spo_description,spo_submitsource,progress_path,progress_percentage from sys_pending_operations where spo_executing_server is null and (spo_must_execute_on_server is null or spo_must_execute_on_server=?) and spo_state='RTRY' and (spo_date_next_try is null or spo_date_next_try <= ?) order by spo_id for update");
            ps.setString(1, this.m_serverID);
            ps.setTimestamp(2, new Timestamp(now.getTime()));
            rs = ps.executeQuery();
            ArrayList<PendingOperation> ack = new ArrayList<PendingOperation>();
            while (rs.next()) {
                PendingOperation po2 = new PendingOperation();
                po2.initFromRS(rs);
                ack.add(po2);
            }
            rs.close();
            int todo = ack.size();
            resultlist = null;
            do {
                if (todo-- <= 0) {
                    object = this;
                    synchronized (object) {
                        this.m_tsNextCheck = System.currentTimeMillis() + 60000L;
                    }
                    dbc.commit();
                    object = null;
                    return object;
                }
                ++this.m_lastSelectedIndex;
                if (this.m_lastSelectedIndex >= ack.size()) {
                    this.m_lastSelectedIndex = 0;
                }
                if ((po = (PendingOperation)ack.get(this.m_lastSelectedIndex)).getOrderGroup() != null) continue;
                resultlist = new ArrayList<PendingOperation>();
                resultlist.add(po);
                break block38;
            } while ((grouplist = this.loadGroup(dbc, po)) == null || grouplist.size() <= 0);
            resultlist = grouplist;
        }
        this.markTasksExecuting(dbc, resultlist);
        dbc.commit();
        object = new PendingOperationTask(this, resultlist);
        return object;
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                dbc.rollback();
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void markTasksExecuting(Connection dbc, List<PendingOperation> polist) throws SQLException {
        int ix = 0;
        for (PendingOperation po : polist) {
            po.setState(PendingOperationState.EXEC);
            po.setExecutesOnServerID(this.m_serverID);
            if (ix++ == 0) {
                po.setLastExecutionStart(new Date());
                po.setLastExecutionEnd(null);
                po.setRetries(po.getRetries() + 1);
                po.setLastError(null);
            }
            po.save(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private List<PendingOperation> loadGroup(Connection dbc, PendingOperation inpo) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ArrayList<PendingOperation> arrayList;
            PendingOperation op;
            PendingOperation po;
            ps = dbc.prepareStatement("select spo_id,spo_xident,spo_issuing_server,spo_date_created,spo_must_execute_on_server,spo_executing_server,spo_last_execute_started,spo_last_execute_completed,spo_state,spo_retries,spo_date_next_try,spo_order_groupname,spo_order_timestamp,spo_order_sub,spo_type,spo_arg1,spo_arg2,spo_lasterror, spo_errorlog, spo_userid,spo_description,spo_submitsource,progress_path,progress_percentage from sys_pending_operations where spo_order_groupname=? and spo_state in ('RTRY','EXEC','FATL','BOOT')  order by spo_order_timestamp, spo_order_sub for update");
            ps.setString(1, inpo.getOrderGroup());
            rs = ps.executeQuery();
            ArrayList<PendingOperation> res = new ArrayList<PendingOperation>();
            while (rs.next()) {
                po = new PendingOperation();
                po.initFromRS(rs);
                res.add(po);
            }
            while (true) {
                List<PendingOperation> list;
                if (res.size() == 0) {
                    po = null;
                    return po;
                }
                op = (PendingOperation)res.get(0);
                if (op.getState() == PendingOperationState.EXEC) {
                    arrayList = null;
                    return arrayList;
                }
                if (op.getState() != PendingOperationState.BOOT && op.getState() != PendingOperationState.FATL) break;
                IPendingOperationExecutor pox = this.findExecutor(op);
                if (null == pox) {
                    list = null;
                    return list;
                }
                if (!(pox instanceof IPendingOperationExecutor2)) {
                    list = null;
                    return list;
                }
                IPendingOperationExecutor2 px2 = (IPendingOperationExecutor2)pox;
                if (!px2.isSkipFailedAllowed(op)) {
                    List<PendingOperation> list2 = null;
                    return list2;
                }
                op.delete(dbc);
                res.remove(0);
            }
            if (op.getMustExecuteOnServerID() != null && !op.getMustExecuteOnServerID().equals(this.m_serverID)) {
                arrayList = null;
                return arrayList;
            }
            if (op.getExecutesOnServerID() != null) {
                arrayList = null;
                return arrayList;
            }
            if (op.getNextTryTime() != null && op.getNextTryTime().getTime() < new Date().getTime()) {
                arrayList = null;
                return arrayList;
            }
            arrayList = res;
            return arrayList;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    Connection allocateConnection() throws SQLException {
        Connection dbc = this.m_ds.getConnection();
        dbc.setAutoCommit(false);
        return dbc;
    }

    DataSource getDataSource() {
        return this.m_ds;
    }

    String getServerID() {
        return this.m_serverID;
    }

    public void registerPendingOperationType(String type, IPendingOperationExecutor pox) {
        if (null != this.m_typeMap.put(type.toLowerCase(), pox)) {
            throw new IllegalStateException("Duplicate PendingOperation.type=" + type);
        }
    }

    public IPendingOperationExecutor findExecutor(PendingOperation po) {
        return this.m_typeMap.get(po.getType().toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOperation(PendingOperation po, StringInputStream sis) throws Exception {
        Connection dbc = this.allocateConnection();
        try {
            po.setSourceServerID(this.m_serverID);
            dbc.setAutoCommit(false);
            po.save(dbc);
            po.saveStream(dbc, (InputStream)sis);
            dbc.commit();
            PendingOperationTaskProvider pendingOperationTaskProvider = this;
            synchronized (pendingOperationTaskProvider) {
                this.m_tsNextCheck = 0L;
                this.notify();
            }
        }
        finally {
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOperation(PendingOperation po, Serializable object) throws Exception {
        Connection dbc = this.allocateConnection();
        try {
            po.setSourceServerID(this.m_serverID);
            if (DeveloperOptions.getBool((String)"domui.developer", (boolean)false)) {
                po.setMustExecuteOnServerID(this.m_serverID);
            }
            dbc.setAutoCommit(false);
            po.save(dbc);
            po.setSerializedObject(object);
            po.saveSerialized(dbc);
            dbc.commit();
            PendingOperationTaskProvider pendingOperationTaskProvider = this;
            synchronized (pendingOperationTaskProvider) {
                this.m_tsNextCheck = 0L;
                this.notify();
            }
        }
        finally {
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void updateProgress(PendingOperation po) throws SQLException {
        Connection dbc = this.allocateConnection();
        try {
            po.save(dbc);
            dbc.commit();
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{dbc});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{dbc});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingJobProgressInfo getCurrentProgress(String externalId) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        Connection dbc;
        block3: {
            PendingJobProgressInfo pendingJobProgressInfo;
            dbc = this.allocateConnection();
            ps = null;
            rs = null;
            try {
                PendingJobProgressInfo pi;
                ps = dbc.prepareStatement("select progress_path, progress_percentage from sys_pending_operations where spo_xident=? and (spo_state = ? or spo_state = ?)");
                ps.setString(1, externalId);
                ps.setString(2, PendingOperationState.RTRY.name());
                ps.setString(3, PendingOperationState.EXEC.name());
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                pendingJobProgressInfo = pi = new PendingJobProgressInfo(rs.getString(1), rs.getInt(2));
            }
            catch (Throwable throwable) {
                FileTool.closeAll((Object[])new Object[]{rs, ps, dbc});
                throw throwable;
            }
            FileTool.closeAll((Object[])new Object[]{rs, ps, dbc});
            return pendingJobProgressInfo;
        }
        PendingJobProgressInfo pendingJobProgressInfo = null;
        FileTool.closeAll((Object[])new Object[]{rs, ps, dbc});
        return pendingJobProgressInfo;
    }

    public boolean isBusyWithJob(String externalId) throws SQLException {
        return this.getCurrentProgress(externalId) != null;
    }
}

