/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.pendingoperations;

import java.util.ArrayList;
import java.util.List;
import to.etc.webapp.pendingoperations.IPollQueueTaskProvider;
import to.etc.webapp.pendingoperations.PolledActionQueue;

public class PollingWorkerQueue {
    private static PollingWorkerQueue m_instance = new PollingWorkerQueue();
    private boolean m_initialized;
    private boolean m_terminating;
    private int m_runningThreads;
    private int m_threadsExecutingTasks;
    private int m_minThreads = 5;
    private int m_maxThreads;
    private final List<IPollQueueTaskProvider> m_providerList = new ArrayList<IPollQueueTaskProvider>();
    private int m_nextProviderIndex;
    private long m_tsLastCheck;
    private long m_tsLastBlock;
    private final long m_checkInterval = 10000L;
    private final PolledActionQueue m_actionQueue = new PolledActionQueue();

    public static void initialize() throws Exception {
        m_instance.init();
    }

    public static PollingWorkerQueue getInstance() {
        m_instance.checkInit();
        return m_instance;
    }

    private synchronized void checkInit() {
        if (!this.m_initialized) {
            throw new IllegalStateException("PollingWorkerQueue has not been initialized");
        }
    }

    private synchronized void init() throws Exception {
        if (this.m_minThreads <= 0) {
            this.m_minThreads = 2;
        }
        if (this.m_maxThreads < this.m_minThreads) {
            this.m_maxThreads = this.m_minThreads + 5;
        }
        for (int i = 0; i < this.m_minThreads; ++i) {
            this.startThread();
        }
        this.m_initialized = true;
        this.registerProvider(this.m_actionQueue);
    }

    private void startThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PollingWorkerQueue.this.handlerThreadMain();
            }
        });
        t.setDaemon(true);
        t.setPriority(5);
        t.setName("PollExecutor");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProvider(IPollQueueTaskProvider provider) {
        PollingWorkerQueue pollingWorkerQueue = this;
        synchronized (pollingWorkerQueue) {
            if (this.m_providerList.contains(provider)) {
                throw new IllegalStateException("Duplicate registration of provider=" + provider);
            }
            this.m_providerList.add(provider);
            this.notifyAll();
            try {
                provider.initializeOnRegistration(this);
            }
            catch (Exception x) {
                System.out.println("pwq: initialization of " + provider + " failed with " + x);
                x.printStackTrace();
            }
        }
    }

    public synchronized void checkProvider(IPollQueueTaskProvider provider) {
        if (this.m_runningThreads == 0 || this.m_terminating) {
            throw new IllegalStateException("The PollingExecutor service is NOT RUNNING");
        }
        this.notify();
    }

    public synchronized void terminate() {
        if (this.m_initialized && !this.m_terminating) {
            this.m_terminating = true;
            this.notifyAll();
        }
    }

    public void addWork(Runnable run) {
        this.m_actionQueue.schedule(run);
    }

    public long getTsLastBlock() {
        return this.m_tsLastBlock;
    }

    public long getTsLastCheck() {
        return this.m_tsLastCheck;
    }

    public synchronized int getRunningThreads() {
        return this.m_runningThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlerThreadMain() {
        PollingWorkerQueue pollingWorkerQueue = this;
        synchronized (pollingWorkerQueue) {
            ++this.m_runningThreads;
        }
        Throwable error = null;
        try {
            this.protectedMain();
        }
        catch (Throwable t) {
            error = t;
        }
        finally {
            PollingWorkerQueue pollingWorkerQueue2 = this;
            synchronized (pollingWorkerQueue2) {
                --this.m_runningThreads;
                if (this.m_terminating) {
                    error = null;
                }
            }
            if (error != null) {
                System.err.println("PollingExecutor: worker thread TERMINATED with error=" + error);
                error.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void protectedMain() {
        int ntodo = -1;
        while (true) {
            IPollQueueTaskProvider provider;
            long cts = System.currentTimeMillis();
            PollingWorkerQueue pollingWorkerQueue = this;
            synchronized (pollingWorkerQueue) {
                if (this.m_terminating) {
                    return;
                }
                if (ntodo == -1) {
                    ntodo = this.m_providerList.size();
                }
                if (ntodo == 0) {
                    try {
                        this.m_tsLastBlock = cts;
                        this.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    cts = System.currentTimeMillis();
                }
                this.m_tsLastCheck = cts;
                int pls = this.m_providerList.size();
                if (pls == 0) {
                    ntodo = 0;
                    continue;
                }
                if (this.m_nextProviderIndex >= pls) {
                    this.m_nextProviderIndex = 0;
                }
                provider = this.m_providerList.get(this.m_nextProviderIndex++);
            }
            Runnable task = null;
            try {
                task = provider.getRunnableTask();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            if (task == null) {
                --ntodo;
                continue;
            }
            PollingWorkerQueue x = this;
            synchronized (x) {
                ++this.m_threadsExecutingTasks;
                if (this.m_threadsExecutingTasks >= this.m_runningThreads && this.m_runningThreads < this.m_maxThreads) {
                    this.startThread();
                }
            }
            try {
                task.run();
                continue;
            }
            catch (Exception x2) {
                x2.printStackTrace();
                continue;
            }
            finally {
                PollingWorkerQueue pollingWorkerQueue2 = this;
                synchronized (pollingWorkerQueue2) {
                    --this.m_threadsExecutingTasks;
                }
                continue;
            }
            break;
        }
    }
}

