/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcPropertyMeta;

public class BigDecimalType
implements IJdbcType,
IJdbcTypeFactory {
    @Override
    public int accept(JdbcPropertyMeta pm) {
        return pm.getActualClass() == BigDecimal.class ? 10 : -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) {
        return this;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta pm, Object value) throws Exception {
        if (value == null) {
            ps.setNull(index, 3);
            return;
        }
        BigDecimal bigDecimalValue = RuntimeConversions.convertToBigDecimal((Object)value);
        ps.setBigDecimal(index, bigDecimalValue);
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pm) throws Exception {
        BigDecimal val = rs.getBigDecimal(index);
        if (rs.wasNull()) {
            return null;
        }
        return val;
    }
}

