/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcPropertyMeta;

public class BooleanType
implements IJdbcType,
IJdbcTypeFactory {
    @Override
    public int accept(JdbcPropertyMeta pm) {
        return pm.getActualClass() == Boolean.TYPE || pm.getActualClass() == Boolean.class ? 10 : -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) {
        return this;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pm) throws Exception {
        boolean val = rs.getBoolean(index);
        if (rs.wasNull()) {
            return null;
        }
        return val;
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta pm, Object value) throws Exception {
        boolean nv;
        Boolean iv = value instanceof Boolean ? (Boolean)value : RuntimeConversions.convertToBooleanWrapper((Object)value);
        if (pm.isNullable() && pm.getActualClass().isPrimitive() && pm.getNullValue() != null && (nv = Boolean.parseBoolean(pm.getNullValue())) == iv) {
            ps.setNull(index, 16);
            return;
        }
        ps.setBoolean(index, iv);
    }
}

