/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import to.etc.webapp.qsql.JdbcUtil;

public final class BundleStatement {
    @Nonnull
    private String m_stmt;
    private int[][] m_parameterar;

    private BundleStatement(String stmt, int[][] nar) {
        this.m_stmt = stmt;
        this.m_parameterar = nar;
    }

    @Nonnull
    static BundleStatement create(@Nonnull String sql) {
        int[] ixar;
        StringBuilder sb = new StringBuilder();
        int ix = 0;
        int len = sql.length();
        int sqlindex = 1;
        int[][] paramar = new int[100][];
        int[] indexar = new int[paramar.length];
        int topnum = -1;
        while (ix < len) {
            int index;
            char c;
            int pos = sql.indexOf(36, ix);
            if (pos == -1) {
                if (ix >= len) break;
                sb.append(sql.substring(ix));
                break;
            }
            if (ix < pos) {
                sb.append(sql, ix, pos);
                ix = pos;
            }
            if (pos > 0 && sql.charAt(pos - 1) == '\\') {
                sb.setLength(sb.length() - 1);
                sb.append('$');
                ++ix;
                continue;
            }
            int num = 0;
            ++ix;
            while (ix < len && Character.isDigit(c = sql.charAt(ix))) {
                num = num * 10 + (c - 48);
                ++ix;
            }
            if (num >= paramar.length) {
                throw new IllegalArgumentException("Parameter number $" + num + " is too high, only 0.." + (paramar.length - 1) + " allowed");
            }
            if (num > topnum) {
                topnum = num;
            }
            if ((ixar = paramar[num]) == null) {
                paramar[num] = ixar = new int[30];
            }
            int n = num;
            indexar[n] = indexar[n] + 1;
            if (index >= ixar.length) {
                throw new IllegalArgumentException("Parameter number $" + num + " has too many occurrences, only " + (ixar.length - 1) + " allowed");
            }
            ixar[index] = sqlindex++;
            sb.append("?");
        }
        int[][] nar = new int[topnum + 1][];
        for (int i = 0; i < nar.length; ++i) {
            ixar = paramar[i];
            if (ixar == null) continue;
            int[] nixar = new int[indexar[i]];
            System.arraycopy(ixar, 0, nixar, 0, indexar[i]);
            nar[i] = nixar;
        }
        return new BundleStatement(sb.toString(), nar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepare(Connection dbc, Object ... parameters) throws SQLException {
        PreparedStatement ps = dbc.prepareStatement(this.m_stmt);
        boolean ok = false;
        try {
            if (parameters != null && parameters.length > 0) {
                this.assignParameters(ps, parameters);
            }
            ok = true;
            PreparedStatement preparedStatement = ps;
            return preparedStatement;
        }
        finally {
            try {
                if (!ok) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void assignParameters(PreparedStatement ps, Object ... parameters) throws SQLException {
        if (parameters.length < this.m_parameterar.length) {
            throw new SQLException("Incorrect parameter count: you provided " + parameters.length + " but the statement needs " + this.m_parameterar.length);
        }
        for (int i = 0; i < this.m_parameterar.length; ++i) {
            int[] ixar = this.m_parameterar[i];
            if (ixar == null) continue;
            Object val = parameters[i];
            int j = ixar.length;
            while (--j >= 0) {
                JdbcUtil.setParameter(ps, val, ixar[j]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(Connection dbc, Object ... parameters) throws SQLException {
        PreparedStatement ps = this.prepare(dbc, parameters);
        try {
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception exception) {}
        }
    }
}

