/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcPropertyMeta;

public class DoubleType
implements IJdbcType,
IJdbcTypeFactory {
    @Override
    public int accept(JdbcPropertyMeta pm) {
        return pm.getActualClass() == Double.TYPE || pm.getActualClass() == Double.class ? 10 : -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) {
        return this;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta pm, Object value) throws Exception {
        double nullValue;
        Double doubleValue = value instanceof Double ? (Double)value : RuntimeConversions.convertToDoubleWrapper((Object)value);
        if (pm.isNullable() && pm.getActualClass().isPrimitive() && pm.getNullValue() != null && (nullValue = Double.parseDouble(pm.getNullValue())) == doubleValue) {
            ps.setNull(index, 8);
            return;
        }
        ps.setDouble(index, doubleValue);
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pm) throws Exception {
        double val = rs.getDouble(index);
        if (rs.wasNull()) {
            return null;
        }
        return val;
    }
}

