/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcConversionException;
import to.etc.webapp.qsql.JdbcPropertyMeta;

public class EnumAsStringType
implements IJdbcType,
IJdbcTypeFactory {
    @Override
    public int accept(JdbcPropertyMeta pm) {
        if (Enum.class.isAssignableFrom(pm.getActualClass())) {
            return 10;
        }
        return -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) {
        return this;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta pm, Object value) throws Exception {
        Enum env = (Enum)value;
        String str = env.name();
        ps.setString(index, str);
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pm) throws Exception {
        String val = rs.getString(index);
        if (null == val) {
            return null;
        }
        Class<?> clz = pm.getActualClass();
        for (Enum en : (Enum[])clz.getEnumConstants()) {
            if (!en.name().equals(val)) continue;
            return en;
        }
        throw new JdbcConversionException("Could not convert property " + pm + ": value '" + val + "' is not a valid enum value for enum " + pm.getActualClass().getName());
    }
}

