/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcPropertyMeta;

public class IntegerType
implements IJdbcType,
IJdbcTypeFactory {
    @Override
    public int accept(JdbcPropertyMeta pm) {
        return pm.getActualClass() == Integer.TYPE || pm.getActualClass() == Integer.class ? 10 : -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) {
        return this;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pm) throws Exception {
        int val = rs.getInt(index);
        if (rs.wasNull()) {
            return null;
        }
        return val;
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta pm, Object value) throws Exception {
        int nv;
        Integer iv = value instanceof Integer ? (Integer)value : RuntimeConversions.convertToIntegerWrapper((Object)value);
        if (pm.isNullable() && pm.getActualClass().isPrimitive() && pm.getNullValue() != null && (nv = Integer.parseInt(pm.getNullValue())) == iv) {
            ps.setNull(index, 2);
            return;
        }
        ps.setInt(index, iv);
    }
}

