/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.util.RuntimeConversions;

public class JdbcAnyRecord {
    private static final Object NULL_VAL = new Object();
    private Map<String, Object> m_valueMap = new HashMap<String, Object>();

    public void initFromRS(String tablename, ResultSetMetaData rsm, @Nonnull ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new IllegalStateException("Null rs not allowed");
        }
        this.m_valueMap.clear();
        int len = rsm.getColumnCount();
        block7: for (int i = 1; i <= len; ++i) {
            int type = rsm.getColumnType(i);
            String name = rsm.getColumnName(i);
            switch (type) {
                default: {
                    throw new IllegalStateException("Cannot handle SQLType=" + type + " for column " + tablename + "." + name);
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    BigDecimal bd = rs.getBigDecimal(i);
                    this.set(name, bd);
                    continue block7;
                }
                case 1: 
                case 12: {
                    this.set(name, rs.getString(i));
                    continue block7;
                }
                case -8: {
                    this.set(name, rs.getString(i));
                    continue block7;
                }
                case 91: 
                case 93: {
                    Timestamp ts = rs.getTimestamp(i);
                    if (ts == null) {
                        this.set(name, NULL_VAL);
                        continue block7;
                    }
                    this.set(name, new Date(ts.getTime()));
                    continue block7;
                }
                case 2005: {
                    Clob clob = rs.getClob(i);
                    if (clob == null) {
                        this.set(name, NULL_VAL);
                        continue block7;
                    }
                    this.set(name, clob);
                }
            }
        }
    }

    public void set(String name, Object bd) {
        if (bd == null) {
            this.m_valueMap.put(name.toLowerCase(), NULL_VAL);
        } else {
            this.m_valueMap.put(name.toLowerCase(), bd);
        }
    }

    public Object get(String name) {
        Object v = this.m_valueMap.get(name.toLowerCase());
        if (v == NULL_VAL) {
            return null;
        }
        return v;
    }

    public <T> T getValue(Class<T> type, String name) {
        return this.getValue(type, name, null);
    }

    public <T> T getValue(Class<T> type, String name, T defaultValue) {
        Object v = this.get(name);
        if (v == NULL_VAL) {
            return defaultValue;
        }
        if (v == null) {
            return defaultValue;
        }
        return (T)RuntimeConversions.convertTo((Object)v, type);
    }
}

