/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.JdbcMetaManager;
import to.etc.webapp.qsql.JdbcPropertyMeta;
import to.etc.webapp.qsql.QJdbcColumn;
import to.etc.webapp.qsql.QJdbcCompound;
import to.etc.webapp.qsql.QJdbcId;
import to.etc.webapp.qsql.QJdbcTable;

public class JdbcClassMeta {
    private Class<?> m_dataClass;
    private String m_tableName;
    private Map<String, JdbcPropertyMeta> m_propertyMap;
    private Map<String, JdbcPropertyMeta> m_columnMap;
    private List<JdbcPropertyMeta> m_propertyList;
    private List<String> m_columnNames;
    private JdbcPropertyMeta m_primaryKey;
    private boolean m_compound;
    private static final Comparator<JdbcPropertyMeta> C_PROP = new Comparator<JdbcPropertyMeta>(){

        @Override
        public int compare(JdbcPropertyMeta a, JdbcPropertyMeta b) {
            if (a.isPrimaryKey() != b.isPrimaryKey()) {
                return a.isPrimaryKey() ? -1 : 1;
            }
            return a.getName().compareTo(b.getName());
        }
    };

    public JdbcClassMeta() {
    }

    public JdbcClassMeta(Class<?> cm) {
        this.m_dataClass = cm;
    }

    protected synchronized void initialize() throws Exception {
        QJdbcCompound co;
        if (this.m_columnMap != null) {
            return;
        }
        if (this.m_dataClass == null) {
            throw new IllegalStateException("The POJO class cannot be null");
        }
        QJdbcTable tbl = this.m_dataClass.getAnnotation(QJdbcTable.class);
        if (tbl != null) {
            this.m_tableName = tbl.table();
        }
        if ((co = this.m_dataClass.getAnnotation(QJdbcCompound.class)) != null) {
            this.m_compound = true;
        }
        if (this.m_compound && this.m_tableName != null) {
            throw new IllegalStateException(this.m_dataClass + ": A table cannot also be a compound");
        }
        List pilist = ClassUtil.getProperties(this.m_dataClass);
        if (pilist.size() == 0) {
            throw new IllegalStateException("No properties on data class!?");
        }
        HashMap<String, JdbcPropertyMeta> map = new HashMap<String, JdbcPropertyMeta>();
        HashMap<String, JdbcPropertyMeta> colmap = new HashMap<String, JdbcPropertyMeta>();
        for (PropertyInfo pi : pilist) {
            JdbcPropertyMeta pm = this.evaluateProperty(pi);
            if (pm == null || null == map.put(pm.getName(), pm)) continue;
            throw new IllegalStateException(this.m_dataClass + ": duplicate property name " + pm.getName());
        }
        this.m_propertyMap = map;
        this.m_columnMap = colmap;
        ArrayList<JdbcPropertyMeta> res = new ArrayList<JdbcPropertyMeta>(this.m_propertyMap.values());
        Collections.sort(res, C_PROP);
        this.m_propertyList = Collections.unmodifiableList(new ArrayList<JdbcPropertyMeta>(res));
        ArrayList<String> colnames = new ArrayList<String>();
        for (JdbcPropertyMeta pm : res) {
            if (pm.isTransient()) continue;
            for (String cn : pm.getColumnNames()) {
                if (null != colmap.put(cn, pm)) {
                    throw new IllegalStateException(this.m_dataClass + ": duplicate column name " + cn);
                }
                colnames.add(cn);
            }
        }
        this.m_columnNames = Collections.unmodifiableList(colnames);
    }

    private JdbcPropertyMeta evaluateProperty(PropertyInfo pi) throws Exception {
        if (pi.getGetter() == null) {
            return null;
        }
        if (pi.getSetter() == null) {
            return null;
        }
        JdbcPropertyMeta pm = new JdbcPropertyMeta(this, pi);
        pm.setActualClass(pi.getGetter().getReturnType());
        QJdbcColumn col = pi.getGetter().getAnnotation(QJdbcColumn.class);
        if (col != null) {
            pm.setColumnName(col.name());
            pm.setNullable(col.nullable());
            pm.setTransient(col.istransient());
            pm.setLength(col.length());
            pm.setScale(col.scale());
            if (col.columnConverter() != IJdbcType.class) {
                pm.setTypeConverter(col.columnConverter().newInstance());
            }
        }
        if (!JdbcMetaManager.isSimpleType(pm.getActualClass()) && !pm.isTransient()) {
            Class<?> clz = pm.getActualClass();
            if (clz.getAnnotation(QJdbcCompound.class) == null) {
                throw new IllegalStateException(this.m_dataClass + ": property " + pi.getName() + " has complex type " + pm.getActualClass() + ", but it is not marked as a compound type with @QJdbcCompound");
            }
            JdbcClassMeta pcm = JdbcMetaManager.getMeta(clz);
            if (!pcm.isCompound()) {
                throw new IllegalStateException(this.m_dataClass + ": property " + pi.getName() + " has complex type " + pm.getActualClass() + ", but it is not marked as a compound type with @QJdbcCompound");
            }
            pm.setCompound(true);
            ArrayList<String> cols = new ArrayList<String>();
            for (JdbcPropertyMeta cpm : pcm.getPropertyList()) {
                for (String s : cpm.getColumnNames()) {
                    cols.add(s);
                }
            }
            pm.setColumnNames(cols.toArray(new String[cols.size()]));
        }
        if (null != pi.getGetter().getAnnotation(QJdbcId.class)) {
            if (this.m_primaryKey != null) {
                throw new IllegalStateException("Duplicate PK: " + pi.getName() + " and " + this.m_primaryKey.getName());
            }
            this.m_primaryKey = pm;
        }
        if (!pm.isTransient() && !pm.isCompound() && pm.getColumnName() == null) {
            throw new IllegalStateException(this.m_dataClass + ": property " + pi.getName() + " has no name for it's JDBC column name");
        }
        if (null == pm.getTypeConverter()) {
            pm.setTypeConverter(JdbcMetaManager.createConverter(pm));
        }
        return pm;
    }

    public Class<?> getDataClass() {
        return this.m_dataClass;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public void setTableName(String tableName) {
        this.m_tableName = tableName;
    }

    public List<JdbcPropertyMeta> getPropertyList() {
        return this.m_propertyList;
    }

    public JdbcPropertyMeta findProperty(String pname) {
        return this.m_propertyMap.get(pname);
    }

    public JdbcPropertyMeta getPrimaryKey() {
        return this.m_primaryKey;
    }

    public void setPrimaryKey(JdbcPropertyMeta primaryKey) {
        this.m_primaryKey = primaryKey;
    }

    public boolean isCompound() {
        return this.m_compound;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public List<String> getColumnNames() {
        return this.m_columnNames;
    }
}

