/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcClassMeta;
import to.etc.webapp.qsql.JdbcConversionException;
import to.etc.webapp.qsql.JdbcMetaManager;
import to.etc.webapp.qsql.JdbcPropertyMeta;

class JdbcCompoundType
implements IJdbcType,
IJdbcTypeFactory {
    private JdbcClassMeta m_compoundMeta;

    public JdbcCompoundType(JdbcClassMeta compoundcm) {
        this.m_compoundMeta = compoundcm;
    }

    JdbcCompoundType() {
    }

    @Override
    public int accept(JdbcPropertyMeta pm) {
        if (pm.isCompound()) {
            return 10;
        }
        return -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) throws Exception {
        JdbcClassMeta cm = JdbcMetaManager.getMeta(pm.getActualClass());
        if (!cm.isCompound()) {
            throw new IllegalStateException("Property " + pm + " has complex type " + pm.getActualClass() + ", but it is not marked as a compound type with @QJdbcCompound");
        }
        return new JdbcCompoundType(cm);
    }

    @Override
    public int columnCount() {
        return this.m_compoundMeta.getColumnCount();
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta srcpm, Object inst) throws Exception {
        int rix = index;
        for (JdbcPropertyMeta pm : this.m_compoundMeta.getPropertyList()) {
            if (pm.isTransient()) continue;
            IJdbcType type = pm.getTypeConverter();
            Object pvalue = inst == null ? null : pm.getPropertyValue(inst);
            type.assignParameter(ps, rix, pm, pvalue);
            rix += type.columnCount();
        }
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pmsource) throws Exception {
        Object inst = this.m_compoundMeta.getDataClass().newInstance();
        boolean nonnull = false;
        int rix = index;
        for (JdbcPropertyMeta pm : this.m_compoundMeta.getPropertyList()) {
            Object pvalue;
            if (pm.isTransient()) continue;
            IJdbcType type = pm.getTypeConverter();
            try {
                pvalue = type.convertToInstance(rs, rix, pm);
            }
            catch (JdbcConversionException x) {
                throw x;
            }
            catch (Exception x) {
                throw JdbcConversionException.create(x, rs, pm, rix);
            }
            if (pvalue != null) {
                nonnull = true;
            } else if (pm.getActualClass().isPrimitive()) {
                String s = pm.getNullValue();
                if (s == null) {
                    s = "0";
                }
                pvalue = RuntimeConversions.convertTo((Object)s, pm.getActualClass());
            }
            if (pvalue != null) {
                Method setter = pm.getPi().getSetter();
                if (null == setter) {
                    throw new IllegalArgumentException("Property " + pm + " is read-only");
                }
                setter.invoke(inst, pvalue);
            }
            rix += pm.getColumnNames().length;
        }
        return nonnull ? inst : null;
    }
}

