/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.core.IRunnable;
import to.etc.webapp.qsql.JdbcQuery;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.IQDataContextListener;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;
import to.etc.webapp.query.QNotFoundException;
import to.etc.webapp.query.QQueryUtils;
import to.etc.webapp.query.QSelection;

public class JdbcDataContext
implements QDataContext {
    private final QDataContextFactory m_factory;
    private Connection m_dbc;
    private boolean m_ignoreClose;
    @Nonnull
    private List<IRunnable> m_commitHandlerList = Collections.EMPTY_LIST;

    public JdbcDataContext(QDataContextFactory factory, Connection dbc) {
        this.m_factory = factory;
        this.internalSetConnection(dbc);
    }

    protected void internalSetConnection(Connection dbc) {
        this.m_dbc = dbc;
    }

    protected Connection internalGetConnection() throws Exception {
        return this.m_dbc;
    }

    protected void unclosed() throws Exception {
        if (this.internalGetConnection() == null) {
            throw new IllegalStateException("This JDBC Data Context has been closed.");
        }
    }

    private void unsupported() {
        throw new IllegalStateException("Unsupported call for JdbcDataContext");
    }

    @Override
    public void attach(@Nonnull Object o) throws Exception {
    }

    @Override
    public void close() {
        if (this.m_ignoreClose) {
            return;
        }
        if (this.m_dbc != null) {
            try {
                this.m_dbc.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.m_dbc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_dbc = null;
        }
    }

    @Override
    public void commit() throws Exception {
        this.unclosed();
        this.internalGetConnection().commit();
        Exception firstx = null;
        for (IRunnable r : this.m_commitHandlerList) {
            try {
                r.run();
            }
            catch (Exception x) {
                if (null == firstx) {
                    firstx = x;
                    continue;
                }
                x.printStackTrace();
            }
        }
        this.m_commitHandlerList.clear();
        if (null != firstx) {
            throw firstx;
        }
    }

    @Override
    public void delete(@Nonnull Object o) throws Exception {
        this.unsupported();
    }

    @Override
    public <T> T find(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        this.unclosed();
        return JdbcQuery.find(this, clz, pk);
    }

    @Override
    @Nonnull
    public <T> T get(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        T res = this.find(clz, pk);
        if (res == null) {
            throw new QNotFoundException(clz, pk);
        }
        return res;
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        this.unclosed();
        return JdbcQuery.getInstance(this, clz, pk);
    }

    @Override
    @Nonnull
    public Connection getConnection() throws Exception {
        this.unclosed();
        return this.internalGetConnection();
    }

    @Override
    @Nonnull
    public QDataContextFactory getFactory() {
        return this.m_factory;
    }

    @Override
    public boolean inTransaction() throws Exception {
        return false;
    }

    @Override
    @Nonnull
    public <T> List<T> query(@Nonnull QCriteria<T> q) throws Exception {
        this.unclosed();
        return JdbcQuery.query((QDataContext)this, q);
    }

    @Override
    @Nonnull
    public List<Object[]> query(@Nonnull QSelection<?> sel) throws Exception {
        this.unclosed();
        return JdbcQuery.query((QDataContext)this, sel);
    }

    @Override
    public <T> T queryOne(@Nonnull QCriteria<T> q) throws Exception {
        this.unclosed();
        return JdbcQuery.queryOne((QDataContext)this, q);
    }

    @Override
    public Object[] queryOne(@Nonnull QSelection<?> q) throws Exception {
        this.unclosed();
        return JdbcQuery.queryOne((QDataContext)this, q);
    }

    @Override
    public <T> T find(@Nonnull ICriteriaTableDef<T> metatable, @Nonnull Object pk) throws Exception {
        throw new IllegalStateException("Inapplicable call for JdbcDataContext");
    }

    @Override
    @Nonnull
    public <R> List<R> query(@Nonnull Class<R> resultInterface, @Nonnull QSelection<?> sel) throws Exception {
        return QQueryUtils.mapSelectionQuery(this, resultInterface, sel);
    }

    @Override
    @Nullable
    public <R> R queryOne(@Nonnull Class<R> resultInterface, @Nonnull QSelection<?> sel) throws Exception {
        return QQueryUtils.mapSelectionOneQuery(this, resultInterface, sel);
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull ICriteriaTableDef<T> clz, @Nonnull Object pk) throws Exception {
        throw new IllegalStateException("Inapplicable call for JdbcDataContext");
    }

    @Override
    public void refresh(@Nonnull Object o) throws Exception {
        this.unsupported();
    }

    @Override
    public void rollback() throws Exception {
        this.unclosed();
        this.internalGetConnection().rollback();
    }

    @Override
    public void save(@Nonnull Object o) throws Exception {
        this.unsupported();
    }

    @Override
    public void setIgnoreClose(boolean on) {
        this.m_ignoreClose = on;
    }

    @Override
    public void startTransaction() throws Exception {
        this.unclosed();
    }

    @Override
    public void addCommitAction(@Nonnull IRunnable cx) {
        if (this.m_commitHandlerList == Collections.EMPTY_LIST) {
            this.m_commitHandlerList = new ArrayList<IRunnable>();
        }
        this.m_commitHandlerList.add(cx);
    }

    @Override
    public void addListener(@Nonnull IQDataContextListener qDataContextListener) {
    }

    @Override
    public <T> T original(@Nonnull T copy) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void setKeepOriginals() {
        throw new IllegalStateException("Not implemented");
    }
}

