/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import to.etc.webapp.qsql.BigDecimalType;
import to.etc.webapp.qsql.BooleanType;
import to.etc.webapp.qsql.DoubleType;
import to.etc.webapp.qsql.EnumAsStringType;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.IntegerType;
import to.etc.webapp.qsql.JdbcClassMeta;
import to.etc.webapp.qsql.JdbcCompoundType;
import to.etc.webapp.qsql.JdbcPropertyMeta;
import to.etc.webapp.qsql.LongType;
import to.etc.webapp.qsql.StringType;
import to.etc.webapp.qsql.TimestampType;

public class JdbcMetaManager {
    private static final Map<Class<?>, JdbcClassMeta> m_classMap = new HashMap();
    private static List<IJdbcTypeFactory> m_factoryList = new ArrayList<IJdbcTypeFactory>();
    private static Set<Class<?>> SIMPLE = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcClassMeta getMeta(Class<?> jdbcClass) throws Exception {
        JdbcClassMeta cm;
        Map<Class<?>, JdbcClassMeta> map = m_classMap;
        synchronized (map) {
            cm = m_classMap.get(jdbcClass);
            if (cm == null) {
                cm = new JdbcClassMeta(jdbcClass);
                m_classMap.put(jdbcClass, cm);
            }
        }
        cm.initialize();
        return cm;
    }

    public static synchronized void register(IJdbcTypeFactory f) {
        m_factoryList = new ArrayList<IJdbcTypeFactory>(m_factoryList);
        m_factoryList.add(f);
    }

    private static synchronized List<IJdbcTypeFactory> getFactoryList() {
        return m_factoryList;
    }

    public static IJdbcType createConverter(JdbcPropertyMeta pm) throws Exception {
        IJdbcTypeFactory best = null;
        int bestscore = 0;
        for (IJdbcTypeFactory f : JdbcMetaManager.getFactoryList()) {
            int score = f.accept(pm);
            if (score <= bestscore) continue;
            best = f;
            bestscore = score;
        }
        if (best == null) {
            if (pm.isTransient()) {
                return null;
            }
            throw new IllegalStateException("I cannot determine a JDBC converter type for " + pm + " of type=" + pm.getActualClass());
        }
        return best.createType(pm);
    }

    public static boolean isSimpleType(Class<?> clz) {
        return SIMPLE.contains(clz) || Enum.class.isAssignableFrom(clz);
    }

    static {
        SIMPLE = new HashSet();
        SIMPLE.add(Integer.class);
        SIMPLE.add(Integer.TYPE);
        SIMPLE.add(Long.class);
        SIMPLE.add(Long.TYPE);
        SIMPLE.add(Character.class);
        SIMPLE.add(Character.TYPE);
        SIMPLE.add(Short.class);
        SIMPLE.add(Short.TYPE);
        SIMPLE.add(Byte.class);
        SIMPLE.add(Byte.TYPE);
        SIMPLE.add(Double.class);
        SIMPLE.add(Double.TYPE);
        SIMPLE.add(Float.class);
        SIMPLE.add(Float.TYPE);
        SIMPLE.add(Boolean.class);
        SIMPLE.add(Boolean.TYPE);
        SIMPLE.add(BigDecimal.class);
        SIMPLE.add(String.class);
        SIMPLE.add(BigInteger.class);
        SIMPLE.add(Date.class);
        JdbcMetaManager.register(new StringType());
        JdbcMetaManager.register(new DoubleType());
        JdbcMetaManager.register(new BigDecimalType());
        JdbcMetaManager.register(new IntegerType());
        JdbcMetaManager.register(new LongType());
        JdbcMetaManager.register(new TimestampType());
        JdbcMetaManager.register(new JdbcCompoundType());
        JdbcMetaManager.register(new TimestampType());
        JdbcMetaManager.register(new BooleanType());
        JdbcMetaManager.register(new EnumAsStringType());
    }
}

