/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.PropertyInfo;
import to.etc.util.WrappedException;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.JdbcClassMeta;

public class JdbcPropertyMeta {
    private JdbcClassMeta m_classMeta;
    private String m_columnName;
    private String[] m_columnNames;
    private PropertyInfo m_pi;
    private Class<?> m_actualClass;
    private int m_length = -1;
    private int m_scale = -1;
    private boolean m_nullable;
    private boolean m_transient;
    private String m_nullValue;
    private IJdbcType m_typeConverter;
    private boolean m_compound;

    public JdbcPropertyMeta() {
    }

    public JdbcPropertyMeta(JdbcClassMeta jdbcClassMeta, PropertyInfo pi) {
        this.m_classMeta = jdbcClassMeta;
        this.m_pi = pi;
    }

    public JdbcClassMeta getClassMeta() {
        return this.m_classMeta;
    }

    public void setClassMeta(JdbcClassMeta classMeta) {
        this.m_classMeta = classMeta;
    }

    public String getColumnName() {
        if (this.isCompound()) {
            throw new IllegalStateException("Illegal reference to getColumnName for compound property " + this.m_classMeta.getDataClass().getName() + "." + this.getName());
        }
        return this.m_columnName;
    }

    public String getName() {
        return this.m_pi.getName();
    }

    public void setColumnName(String columnName) {
        this.m_columnName = columnName;
        this.m_columnNames = new String[]{columnName};
    }

    public PropertyInfo getPi() {
        return this.m_pi;
    }

    public void setPi(PropertyInfo pi) {
        this.m_pi = pi;
    }

    public Class<?> getActualClass() {
        return this.m_actualClass;
    }

    public void setActualClass(Class<?> actualClass) {
        this.m_actualClass = actualClass;
    }

    public int getLength() {
        return this.m_length;
    }

    public void setLength(int length) {
        this.m_length = length;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int scale) {
        this.m_scale = scale;
    }

    public boolean isNullable() {
        return this.m_nullable;
    }

    public void setNullable(boolean nullable) {
        this.m_nullable = nullable;
    }

    public boolean isTransient() {
        return this.m_transient;
    }

    public void setTransient(boolean calculated) {
        this.m_transient = calculated;
    }

    public String getNullValue() {
        return this.m_nullValue;
    }

    public void setNullValue(String nullValue) {
        this.m_nullValue = nullValue;
    }

    public IJdbcType getTypeConverter() {
        return this.m_typeConverter;
    }

    public void setTypeConverter(IJdbcType typeConverter) {
        this.m_typeConverter = typeConverter;
    }

    public boolean isPrimaryKey() {
        return this == this.m_classMeta.getPrimaryKey();
    }

    public String toString() {
        return this.m_classMeta.getDataClass().getName() + "." + this.getName() + " (row " + this.m_classMeta.getTableName() + "." + this.m_columnName + "): " + this.getActualClass();
    }

    public boolean isCompound() {
        return this.m_compound;
    }

    public void setCompound(boolean compound) {
        this.m_compound = compound;
    }

    public String[] getColumnNames() {
        return this.m_columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.m_columnNames = columnNames;
    }

    @Nullable
    public Object getPropertyValue(@Nonnull Object inst) throws Exception {
        if (inst == null) {
            throw new IllegalArgumentException("Null instance not allowed");
        }
        try {
            return this.m_pi.getGetter().invoke(inst, new Object[0]);
        }
        catch (InvocationTargetException itx) {
            throw WrappedException.unwrap((Exception)itx);
        }
    }

    public void setPropertyValue(@Nonnull Object inst, @Nullable Object value) throws Exception {
        if (inst == null) {
            throw new IllegalArgumentException("Null instance not allowed");
        }
        try {
            Method setter = this.m_pi.getSetter();
            if (null == setter) {
                throw new IllegalArgumentException("Property " + this.m_pi + " is read-only");
            }
            setter.invoke(inst, value);
        }
        catch (InvocationTargetException itx) {
            throw WrappedException.unwrap((Exception)itx);
        }
    }
}

