/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import to.etc.util.DeveloperOptions;
import to.etc.webapp.qsql.IInstanceMaker;
import to.etc.webapp.qsql.IQValueSetter;
import to.etc.webapp.qsql.JdbcClassMeta;
import to.etc.webapp.qsql.JdbcMetaManager;
import to.etc.webapp.qsql.JdbcPropertyMeta;
import to.etc.webapp.qsql.JdbcSQLGenerator;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDbException;
import to.etc.webapp.query.QSelection;

public class JdbcQuery<T> {
    private final String m_sql;
    private final List<IInstanceMaker> m_rowMaker;
    private final List<IQValueSetter> m_valList;
    private final int m_start;
    private final int m_limit;
    private final int m_timeout;
    private static boolean m_showSQL = DeveloperOptions.getBool((String)"domui.jdbc.sql", (boolean)false);

    public JdbcQuery(String sql, List<IInstanceMaker> retrieverList, List<IQValueSetter> vl, int start, int limit, int timeout) {
        this.m_sql = sql;
        this.m_rowMaker = retrieverList;
        this.m_valList = vl;
        this.m_start = start;
        this.m_limit = limit;
        this.m_timeout = timeout;
    }

    public List<?> query(QDataContext dc) throws Exception {
        if (m_showSQL) {
            System.out.println("jdbc: " + this.m_sql);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = dc.getConnection().prepareStatement(this.m_sql);
            for (IQValueSetter vs : this.m_valList) {
                vs.assign(ps);
            }
            if (this.m_timeout > 0) {
                ps.setQueryTimeout(this.m_timeout);
            }
            ArrayList<Object> res = new ArrayList<Object>();
            rs = ps.executeQuery();
            int rownum = 0;
            while (rs.next()) {
                if (rownum >= this.m_start) {
                    if (this.m_limit > 0) {
                        if (res.size() >= this.m_limit) {
                            break;
                        }
                    } else if (res.size() > 10000) {
                        throw new IllegalStateException("Your query result has > 10.000 rows. I aborted to prevent OOM.\nThe query was:\n" + this.m_sql);
                    }
                    if (this.m_rowMaker.size() == 1) {
                        res.add(this.m_rowMaker.get(0).make(dc, rs));
                    } else {
                        Object[] row = new Object[this.m_rowMaker.size()];
                        for (int i = 0; i < this.m_rowMaker.size(); ++i) {
                            row[i] = this.m_rowMaker.get(i).make(dc, rs);
                        }
                        res.add(row);
                    }
                }
                ++rownum;
            }
            ArrayList<Object> arrayList = res;
            return arrayList;
        }
        catch (Exception x) {
            QDbException dx = QDbException.findTranslation(x);
            if (dx != null) {
                throw dx;
            }
            throw x;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static <T> JdbcQuery<T> create(QCriteria<T> q) throws Exception {
        JdbcSQLGenerator qg = new JdbcSQLGenerator();
        qg.visitCriteria(q);
        return qg.getQuery();
    }

    public static <T> JdbcQuery<T> create(QSelection<T> q) throws Exception {
        JdbcSQLGenerator qg = new JdbcSQLGenerator();
        qg.visitSelection(q);
        return qg.getQuery();
    }

    public void dump() {
        System.out.println("SQL: " + this.m_sql);
    }

    public static <T> T find(QDataContext dc, Class<T> clz, Object pk) throws Exception {
        JdbcClassMeta jcm = JdbcMetaManager.getMeta(clz);
        JdbcPropertyMeta pkpm = jcm.getPrimaryKey();
        if (pkpm == null) {
            throw new IllegalStateException("No primary key defined on " + clz);
        }
        QCriteria<T> qc = QCriteria.create(clz);
        qc.eq(pkpm.getName(), pk);
        return JdbcQuery.queryOne(dc, qc);
    }

    public static <T> T getInstance(QDataContext dc, Class<T> clz, Object pk) throws Exception {
        JdbcClassMeta jcm = JdbcMetaManager.getMeta(clz);
        JdbcPropertyMeta pkpm = jcm.getPrimaryKey();
        if (pkpm == null) {
            throw new IllegalStateException("No primary key defined on " + clz);
        }
        QCriteria<T> qc = QCriteria.create(clz);
        qc.eq(pkpm.getName(), pk);
        T v = JdbcQuery.queryOne(dc, qc);
        if (v != null) {
            return v;
        }
        v = clz.newInstance();
        Method setter = pkpm.getPi().getSetter();
        if (null == setter) {
            throw new IllegalArgumentException("Property " + pkpm + " is read-only");
        }
        setter.invoke(v, pk);
        return v;
    }

    public static <T> List<T> query(QDataContext dc, QCriteria<T> q) throws Exception {
        JdbcQuery<T> query = JdbcQuery.create(q);
        return query.query(dc);
    }

    public static List<Object[]> query(QDataContext dc, QSelection<?> sel) throws Exception {
        JdbcQuery<?> query = JdbcQuery.create(sel);
        return query.query(dc);
    }

    public static <T> T queryOne(QDataContext dc, QCriteria<T> q) throws Exception {
        List<T> res = JdbcQuery.query(dc, q);
        if (res.size() == 0) {
            return null;
        }
        if (res.size() == 1) {
            return res.get(0);
        }
        throw new IllegalStateException("The criteria-query " + q + " returns " + res.size() + " results instead of one");
    }

    public static Object[] queryOne(QDataContext dc, QSelection<?> q) throws Exception {
        List<Object[]> res = JdbcQuery.query(dc, q);
        if (res.size() == 0) {
            return null;
        }
        if (res.size() == 1) {
            return res.get(0);
        }
        throw new IllegalStateException("The criteria-query " + q + " returns " + res.size() + " results instead of one");
    }
}

