/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.util.List;
import javax.annotation.Nonnull;
import to.etc.webapp.qsql.JdbcQuery;
import to.etc.webapp.qsql.QJdbcTable;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.IQueryExecutor;
import to.etc.webapp.query.IQueryExecutorFactory;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QSelection;

public class JdbcQueryExecutor
implements IQueryExecutor<QDataContext>,
IQueryExecutorFactory {
    public static final JdbcQueryExecutor FACTORY = new JdbcQueryExecutor();

    protected JdbcQueryExecutor() {
    }

    private static boolean isJdbcQuery(Class<?> clz) {
        return clz.getAnnotation(QJdbcTable.class) != null;
    }

    @Override
    public IQueryExecutor<?> findContextHandler(@Nonnull QDataContext root, @Nonnull Class<?> clz) {
        if (clz != null && JdbcQueryExecutor.isJdbcQuery(clz)) {
            return this;
        }
        return null;
    }

    @Override
    public IQueryExecutor<?> findContextHandler(@Nonnull QDataContext root, @Nonnull ICriteriaTableDef<?> tableMeta) {
        return null;
    }

    @Override
    public IQueryExecutor<?> findContextHandler(@Nonnull QDataContext root, @Nonnull Object recordInstance) {
        if (recordInstance == null || !JdbcQueryExecutor.isJdbcQuery(recordInstance.getClass())) {
            return null;
        }
        return this;
    }

    @Override
    public <T> T find(@Nonnull QDataContext root, @Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        return JdbcQuery.find(root, clz, pk);
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull QDataContext root, @Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        return JdbcQuery.getInstance(root, clz, pk);
    }

    @Override
    public <T> T find(@Nonnull QDataContext root, @Nonnull ICriteriaTableDef<T> metatable, @Nonnull Object pk) throws Exception {
        throw new IllegalStateException("Inapplicable call for " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull QDataContext root, @Nonnull ICriteriaTableDef<T> clz, @Nonnull Object pk) throws Exception {
        throw new IllegalStateException("Inapplicable call for " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public <T> List<T> query(@Nonnull QDataContext root, @Nonnull QCriteria<T> q) throws Exception {
        return JdbcQuery.query(root, q);
    }

    @Override
    @Nonnull
    public List<Object[]> query(@Nonnull QDataContext root, @Nonnull QSelection<?> sel) throws Exception {
        return JdbcQuery.query(root, sel);
    }

    @Override
    public void refresh(@Nonnull QDataContext root, @Nonnull Object o) throws Exception {
    }

    @Override
    public void save(@Nonnull QDataContext root, @Nonnull Object o) throws Exception {
        throw new IllegalStateException("Save operation not implemented for QJdbc classes");
    }

    @Override
    public void delete(@Nonnull QDataContext root, @Nonnull Object o) throws Exception {
        throw new IllegalStateException("delete operation not implemented for QJdbc classes");
    }

    @Override
    public void attach(@Nonnull QDataContext root, @Nonnull Object o) throws Exception {
        throw new IllegalStateException("attach operation not implemented for QJdbc classes");
    }
}

