/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.webapp.qsql.ClassInstanceMaker;
import to.etc.webapp.qsql.IInstanceMaker;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IQValueSetter;
import to.etc.webapp.qsql.JdbcClassMeta;
import to.etc.webapp.qsql.JdbcMetaManager;
import to.etc.webapp.qsql.JdbcPropertyMeta;
import to.etc.webapp.qsql.JdbcQuery;
import to.etc.webapp.qsql.LikeSetter;
import to.etc.webapp.qsql.PClassRef;
import to.etc.webapp.qsql.QQuerySyntaxException;
import to.etc.webapp.qsql.SelectorColumnsResultMaker;
import to.etc.webapp.qsql.ValSetter;
import to.etc.webapp.query.QBetweenNode;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QExistsSubquery;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QOrder;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QPropertyIn;
import to.etc.webapp.query.QPropertyJoinComparison;
import to.etc.webapp.query.QPropertySelection;
import to.etc.webapp.query.QQueryRenderer;
import to.etc.webapp.query.QRenderingVisitorBase;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.query.QSelectionFunction;
import to.etc.webapp.query.QSelectionItem;
import to.etc.webapp.query.QSelectionSubquery;
import to.etc.webapp.query.QSqlRestriction;
import to.etc.webapp.query.QSubQuery;
import to.etc.webapp.query.QUnaryProperty;

public class JdbcSQLGenerator
extends QRenderingVisitorBase {
    private PClassRef m_root;
    private JdbcClassMeta m_rootMeta;
    private Map<String, PClassRef> m_tblMap = new HashMap<String, PClassRef>();
    private StringBuilder m_fields = new StringBuilder();
    private List<IInstanceMaker> m_retrieverList = new ArrayList<IInstanceMaker>();
    private int m_nextFieldIndex = 1;
    private StringBuilder m_where = new StringBuilder();
    private StringBuilder m_order;
    private int m_nextWhereIndex = 1;
    private List<IQValueSetter> m_valList = new ArrayList<IQValueSetter>();
    private boolean m_oracle = true;
    private int m_start;
    private int m_limit;
    private int m_timeout = -1;
    private String m_sql;

    @Override
    public void visitCriteria(@Nonnull QCriteria<?> qc) throws Exception {
        boolean limiting;
        this.m_root = new PClassRef(qc.getBaseClass(), "this_");
        this.m_tblMap.put(this.m_root.getAlias(), this.m_root);
        this.m_rootMeta = JdbcMetaManager.getMeta(qc.getBaseClass());
        this.m_start = qc.getStart();
        this.m_limit = qc.getLimit();
        if (qc.getTimeout() < 0) {
            this.m_timeout = 60;
        } else if (qc.getTimeout() != 0) {
            this.m_timeout = qc.getTimeout();
        }
        this.generateClassGetter(this.m_root);
        super.visitCriteria(qc);
        StringBuilder sb = new StringBuilder(256);
        boolean bl = limiting = qc.getLimit() > 0 || qc.getStart() > 0;
        if (this.m_oracle && limiting) {
            sb.append("select * from (");
        }
        sb.append("select ");
        sb.append((CharSequence)this.m_fields);
        sb.append(" from ");
        JdbcClassMeta cm = JdbcMetaManager.getMeta(this.m_root.getDataClass());
        sb.append(cm.getTableName());
        sb.append(" ");
        sb.append(this.m_root.getAlias());
        if (this.m_where.length() > 0) {
            sb.append(" where ");
            sb.append((CharSequence)this.m_where);
        }
        if (this.m_order != null) {
            sb.append(" order by ");
            sb.append((CharSequence)this.m_order);
        }
        if (this.m_oracle && limiting) {
            sb.append(") where");
            if (qc.getStart() > 0) {
                sb.append(" rownum >= ").append(qc.getStart());
            }
            if (qc.getLimit() > 0) {
                if (qc.getStart() > 0) {
                    sb.append(" and");
                }
                sb.append(" rownum <= ").append(qc.getLimit());
            }
        }
        this.m_sql = sb.toString();
    }

    @Override
    public void visitSelection(@Nonnull QSelection<?> qc) throws Exception {
        this.m_root = new PClassRef(qc.getBaseClass(), "this_");
        this.m_tblMap.put(this.m_root.getAlias(), this.m_root);
        this.m_rootMeta = JdbcMetaManager.getMeta(qc.getBaseClass());
        this.m_timeout = 60;
        this.m_retrieverList.add(new SelectorColumnsResultMaker(qc));
        this.visitRestrictionsBase(qc);
        this.visitOrderList(qc.getOrder());
        StringBuilder sb = new StringBuilder(256);
        sb.append("select ");
        final JdbcClassMeta cm = JdbcMetaManager.getMeta(this.m_root.getDataClass());
        QQueryRenderer renderer = new QQueryRenderer(){

            @Override
            public void visitPropertySelection(@Nonnull QPropertySelection n) throws Exception {
                int currentColumn = this.getCurrentColumn();
                if (currentColumn > 0) {
                    this.append(",");
                }
                this.setCurrentColumn(currentColumn + 1);
                if (n.getFunction().equals((Object)QSelectionFunction.COUNT_DISTINCT)) {
                    this.append("count ");
                    this.append("(distinct ");
                    this.append(cm.findProperty(n.getProperty()).getColumnName());
                    this.append(")");
                } else if (n.getFunction().equals((Object)QSelectionFunction.PROPERTY)) {
                    this.append(cm.findProperty(n.getProperty()).getColumnName());
                } else {
                    this.append(n.getFunction().name().toLowerCase());
                    this.append("(");
                    this.append(cm.findProperty(n.getProperty()).getColumnName());
                    this.append(")");
                }
            }
        };
        renderer.visitSelectionColumns(qc);
        sb.append(renderer.toString());
        sb.append(" from ");
        sb.append(cm.getTableName());
        sb.append(" ");
        sb.append(this.m_root.getAlias());
        if (this.m_where.length() > 0) {
            sb.append(" where ");
            sb.append((CharSequence)this.m_where);
        }
        if (this.m_order != null) {
            sb.append(" order by ");
            sb.append((CharSequence)this.m_order);
        }
        this.m_sql = sb.toString();
    }

    private String getColumnRef(PClassRef ref, String name) {
        return ref.getAlias() + "." + name;
    }

    private void generateClassGetter(PClassRef root) throws Exception {
        JdbcClassMeta cm = JdbcMetaManager.getMeta(root.getDataClass());
        int startIndex = this.m_nextFieldIndex;
        for (JdbcPropertyMeta pm : cm.getPropertyList()) {
            if (pm.isTransient()) continue;
            this.generatePropertyGetter(root, pm);
        }
        this.m_retrieverList.add(new ClassInstanceMaker(root, startIndex, cm));
    }

    private void addSelectColumn(PClassRef root, String name) {
        if (this.m_fields.length() != 0) {
            this.m_fields.append(",");
        }
        this.m_fields.append(this.getColumnRef(root, name));
        ++this.m_nextFieldIndex;
    }

    private void generatePropertyGetter(PClassRef root, JdbcPropertyMeta pm) throws Exception {
        for (String col : pm.getColumnNames()) {
            this.addSelectColumn(root, col);
        }
    }

    public String getSQL() throws Exception {
        return this.m_sql;
    }

    public List<IQValueSetter> getValList() {
        return this.m_valList;
    }

    public List<IInstanceMaker> getRetrieverList() {
        return this.m_retrieverList;
    }

    public JdbcQuery<?> getQuery() throws Exception {
        return new JdbcQuery(this.getSQL(), this.m_retrieverList, this.m_valList, this.m_start, this.m_limit, this.m_timeout);
    }

    @Override
    public void visitOrder(@Nonnull QOrder o) throws Exception {
        if (this.m_order == null) {
            this.m_order = new StringBuilder();
        }
        JdbcPropertyMeta pm = this.resolveProperty(o.getProperty());
        for (String col : pm.getColumnNames()) {
            if (this.m_order.length() > 0) {
                this.m_order.append(",");
            }
            this.m_order.append(this.getColumnRef(this.m_root, col));
            this.m_order.append(' ').append(this.translateOrder(o));
        }
    }

    @Override
    protected void appendWhere(String s) {
        this.m_where.append(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitPropertyComparison(@Nonnull QPropertyComparison n) throws Exception {
        JdbcPropertyMeta pm = this.resolveProperty(n.getProperty());
        if (pm.isCompound()) {
            if (n.getOperation() != QOperation.EQ && n.getOperation() != QOperation.NE) {
                throw new QQuerySyntaxException("The " + (Object)((Object)n.getOperation()) + " operation is not supported on compound property " + n.getProperty());
            }
            this.generateCompoundComparison(n, pm);
            return;
        }
        int oldprec = this.precedenceOpen(n);
        if (n.getOperation() == QOperation.ILIKE && this.m_oracle) {
            this.appendWhere("upper(");
            this.appendWhere(this.getColumnRef(this.m_root, pm.getColumnName()));
            this.appendWhere(") like upper(");
            if (!(n.getExpr() instanceof QLiteral)) {
                throw new QQuerySyntaxException("Unexpected argument to " + n + ": " + n.getExpr());
            }
            this.appendLikeValueSetter(pm, (QLiteral)n.getExpr());
            this.appendWhere(")");
        } else if (n.getOperation() == QOperation.ILIKE || n.getOperation() == QOperation.LIKE) {
            this.appendWhere(this.getColumnRef(this.m_root, pm.getColumnName()));
            this.appendOperation(n.getOperation());
            if (!(n.getExpr() instanceof QLiteral)) throw new QQuerySyntaxException("Unexpected argument to " + n + ": " + n.getExpr());
            this.appendLikeValueSetter(pm, (QLiteral)n.getExpr());
        } else {
            this.appendWhere(this.getColumnRef(this.m_root, pm.getColumnName()));
            this.appendOperation(n.getOperation());
            if (!(n.getExpr() instanceof QLiteral)) throw new QQuerySyntaxException("Unexpected argument to " + n + ": " + n.getExpr());
            this.appendValueSetter(pm, (QLiteral)n.getExpr());
        }
        this.precedenceClose(oldprec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitPropertyIn(@Nonnull QPropertyIn n) throws Exception {
        JdbcPropertyMeta pm = this.resolveProperty(n.getProperty());
        if (pm.isCompound()) {
            throw new QQuerySyntaxException("The " + (Object)((Object)n.getOperation()) + " operation is not supported on compound property " + n.getProperty());
        }
        int oldprec = this.precedenceOpen(n);
        this.appendWhere(this.getColumnRef(this.m_root, pm.getColumnName()));
        QOperatorNode expr = n.getExpr();
        if (expr instanceof QLiteral) {
            QLiteral lit = (QLiteral)expr;
            Object value = lit.getValue();
            if (!(value instanceof List)) throw new QQuerySyntaxException("Unexpected literal of type " + value + " in 'in' expression for property " + n.getProperty());
            List list = (List)value;
            int ct = 0;
            for (Object o : list) {
                if (ct++ > 0) {
                    this.appendWhere(",");
                }
                this.appendValueSetter(pm, (QLiteral)n.getExpr());
            }
        } else {
            expr.visit(this);
        }
        this.precedenceClose(oldprec);
    }

    private void generateCompoundComparison(QPropertyComparison n, JdbcPropertyMeta pm) {
        if (!(n.getExpr() instanceof QLiteral)) {
            throw new QQuerySyntaxException("Unexpected argument to " + n + ": " + n.getExpr());
        }
        QLiteral ql = (QLiteral)n.getExpr();
        Object inst = ql.getValue();
        if (inst != null && !pm.getActualClass().isAssignableFrom(inst.getClass())) {
            throw new QQuerySyntaxException("The value of type " + inst.getClass() + " is not assignment-compatible with the compound type=" + pm.getActualClass() + " in property " + n.getProperty());
        }
        this.appendWhere("(");
        int ix = 0;
        for (String col : pm.getColumnNames()) {
            if (ix++ > 0) {
                this.appendWhere(" and ");
            }
            this.appendWhere(this.getColumnRef(this.m_root, col));
            this.appendOperation(n.getOperation());
            this.appendWhere("?");
        }
        this.appendWhere(")");
        int index = this.m_nextWhereIndex;
        IJdbcType tc = pm.getTypeConverter();
        this.m_nextWhereIndex += tc.columnCount();
        ValSetter vs = new ValSetter(index, inst, tc, pm);
        this.m_valList.add(vs);
    }

    private void appendValueSetter(JdbcPropertyMeta pm, QLiteral expr) {
        this.appendValueSetter(pm, expr.getValue());
    }

    private void appendValueSetter(JdbcPropertyMeta pm, Object value) {
        this.appendWhere("?");
        int index = this.m_nextWhereIndex++;
        IJdbcType tc = pm.getTypeConverter();
        ValSetter vs = new ValSetter(index, value, tc, pm);
        this.m_valList.add(vs);
    }

    private void appendLikeValueSetter(JdbcPropertyMeta pm, QLiteral expr) {
        if (!(expr.getValue() instanceof String)) {
            throw new QQuerySyntaxException("Invalid value type " + expr.getValue() + " for LIKE operation - expecting string.");
        }
        this.appendWhere("?");
        int index = this.m_nextWhereIndex++;
        LikeSetter vs = new LikeSetter(index, (String)expr.getValue(), pm);
        this.m_valList.add(vs);
    }

    private JdbcPropertyMeta resolveProperty(String pname) throws Exception {
        if (pname.indexOf(46) != -1) {
            String[] segs = pname.split("\\.");
            JdbcClassMeta currclz = this.m_rootMeta;
            JdbcPropertyMeta selpm = null;
            int i = 0;
            while (true) {
                String name;
                if ((selpm = currclz.findProperty(name = segs[i++])) == null) {
                    throw new QQuerySyntaxException("Property '" + name + "' not found in class=" + currclz.getDataClass() + " in property path '" + pname + "'");
                }
                if (i >= segs.length) {
                    return selpm;
                }
                if (!selpm.isCompound()) {
                    throw new QQuerySyntaxException("Property '" + name + "' in class=" + currclz.getDataClass() + " in property path '" + pname + "' is not a compound property");
                }
                currclz = JdbcMetaManager.getMeta(selpm.getActualClass());
            }
        }
        JdbcPropertyMeta pm = this.m_rootMeta.findProperty(pname);
        if (pm == null) {
            throw new IllegalStateException(this.m_rootMeta.getDataClass() + "." + pname + ": unknown property");
        }
        return pm;
    }

    @Override
    public void visitUnaryProperty(@Nonnull QUnaryProperty n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        if (n.getOperation() == QOperation.ISNOTNULL || n.getOperation() == QOperation.ISNULL) {
            JdbcPropertyMeta pm = this.resolveProperty(n.getProperty());
            this.appendWhere(this.getColumnRef(this.m_root, pm.getColumnName()));
            this.appendOperation(n.getOperation());
        } else {
            this.appendOperation(n.getOperation());
            this.appendWhere("(");
            JdbcPropertyMeta pm = this.resolveProperty(n.getProperty());
            this.appendWhere(this.getColumnRef(this.m_root, pm.getColumnName()));
            this.appendWhere(")");
        }
        this.precedenceClose(oldprec);
    }

    @Override
    public void visitBetween(@Nonnull QBetweenNode n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        JdbcPropertyMeta pm = this.resolveProperty(n.getProp());
        this.appendWhere(this.getColumnRef(this.m_root, pm.getColumnName()));
        this.appendWhere(" between ");
        if (!(n.getA() instanceof QLiteral)) {
            throw new IllegalStateException("Unexpected argument to " + n + ": " + n.getA());
        }
        this.appendValueSetter(pm, (QLiteral)n.getA());
        this.appendWhere(" and ");
        if (!(n.getB() instanceof QLiteral)) {
            throw new IllegalStateException("Unexpected argument to " + n + ": " + n.getB());
        }
        this.appendValueSetter(pm, (QLiteral)n.getB());
        this.precedenceClose(oldprec);
    }

    @Override
    public void visitLiteral(@Nonnull QLiteral n) throws Exception {
        throw new IllegalStateException("!!! Trying to generate a naked literal!");
    }

    @Override
    protected void appendOperation(QOperation op) {
        this.appendOperation(this.renderOperation(op));
    }

    private void appendOperation(String renderOperation) {
        if (Character.isLetter(renderOperation.charAt(0))) {
            if (this.m_where.length() > 0 && this.m_where.charAt(this.m_where.length() - 1) != ' ') {
                this.appendWhere(" ");
            }
            this.appendWhere(renderOperation);
            this.appendWhere(" ");
        } else {
            this.appendWhere(renderOperation);
        }
    }

    @Override
    public void visitPropertyJoinComparison(@Nonnull QPropertyJoinComparison qPropertyJoinComparison) {
        throw new IllegalStateException("Correlated subqueries are not supported");
    }

    @Override
    public void visitSqlRestriction(@Nonnull QSqlRestriction v) throws Exception {
        if (v.getParameters().length != 0) {
            throw new QQuerySyntaxException("Parameterized literal SQL not supported");
        }
        this.appendWhere(v.getSql());
    }

    @Override
    @Deprecated
    public void visitSelectionSubquery(@Nonnull QSelectionSubquery qSelectionSubquery) throws Exception {
        throw new IllegalStateException("Subqueries are not supported");
    }

    @Override
    public void visitSubquery(@Nonnull QSubQuery<?, ?> n) throws Exception {
        throw new UnsupportedOperationException("Subqueries are not supported");
    }

    @Override
    public void visitExistsSubquery(@Nonnull QExistsSubquery<?> q) throws Exception {
        throw new UnsupportedOperationException("Subqueries are not supported");
    }

    @Override
    public void visitSelectionItem(@Nonnull QSelectionItem n) throws Exception {
    }

    @Override
    public void visitPropertySelection(@Nonnull QPropertySelection n) throws Exception {
    }
}

