/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.util.DateUtil;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.webapp.qsql.JdbcAnyRecord;
import to.etc.webapp.qsql.JdbcInOutParam;
import to.etc.webapp.qsql.JdbcOutParam;
import to.etc.webapp.query.IIdentifyable;

public class JdbcUtil {
    public static final Logger LOG = LoggerFactory.getLogger(JdbcUtil.class);

    private JdbcUtil() {
    }

    public static void setLong(@Nonnull PreparedStatement ps, int index, Long value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 2);
        } else {
            ps.setLong(index, value);
        }
    }

    public static void setInteger(@Nonnull PreparedStatement ps, int index, Integer value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 2);
        } else {
            ps.setInt(index, value);
        }
    }

    public static void setDouble(@Nonnull PreparedStatement ps, int index, Double value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 8);
        } else {
            ps.setDouble(index, value);
        }
    }

    public static void setTimestamp(@Nonnull PreparedStatement ps, int index, java.util.Date value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 93);
        } else if (value instanceof Timestamp) {
            ps.setTimestamp(index, (Timestamp)value);
        } else {
            ps.setTimestamp(index, new Timestamp(value.getTime()));
        }
    }

    public static void setDateTruncated(@Nonnull PreparedStatement ps, int index, java.util.Date value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 93);
        } else {
            value = DateUtil.truncateDate((java.util.Date)value);
            ps.setDate(index, new Date(value.getTime()));
        }
    }

    public static void setString(@Nonnull PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null || value.trim().length() == 0) {
            ps.setNull(index, 12);
        } else {
            ps.setString(index, value);
        }
    }

    public static void setStringTruncated(@Nonnull PreparedStatement ps, int index, String value, int maxlen) throws SQLException {
        if (value == null || value.trim().length() == 0) {
            ps.setNull(index, 12);
        } else {
            int len = value.length();
            if (len > maxlen) {
                value = value.substring(0, maxlen);
            }
            ps.setString(index, value);
        }
    }

    public static void setYN(@Nonnull PreparedStatement ps, int index, Boolean value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 12);
        } else {
            ps.setString(index, value != false ? "Y" : "N");
        }
    }

    public static void setFK(@Nonnull PreparedStatement ps, int index, @Nullable IIdentifyable<? extends Number> foreigner) throws SQLException {
        if (foreigner == null) {
            ps.setNull(index, 2);
        } else {
            Number id = foreigner.getId();
            if (id == null) {
                throw new IllegalStateException("Reference to foreign object '" + foreigner + "' has a null ID.");
            }
            ps.setLong(index, id.longValue());
        }
    }

    public static <T> T selectOne(@Nonnull Connection connection, @Nonnull Class<T> clz, @Nonnull String select, Object ... params) throws SQLException {
        Comparable<Long> ts;
        Object res;
        ResultSet rs;
        PreparedStatement ps;
        block29: {
            block28: {
                block27: {
                    ps = null;
                    rs = null;
                    ps = connection.prepareStatement(select);
                    JdbcUtil.setParameters(ps, 1, params);
                    JdbcUtil.logDebug("selectOne", select, params);
                    rs = ps.executeQuery();
                    if (rs.next()) break block27;
                    T t = null;
                    FileTool.closeAll((Object[])new Object[]{rs, ps});
                    return t;
                }
                res = null;
                if (clz != String.class) break block28;
                String string = rs.getString(1);
                FileTool.closeAll((Object[])new Object[]{rs, ps});
                return (T)string;
            }
            if (clz == Long.class || clz == Long.TYPE) {
                res = rs.getLong(1);
            } else if (clz == Integer.class || clz == Integer.TYPE) {
                res = rs.getInt(1);
            } else if (clz == Double.class || clz == Double.TYPE) {
                res = rs.getDouble(1);
            } else if (clz == BigDecimal.class) {
                res = rs.getBigDecimal(1);
            } else if (clz == java.util.Date.class) {
                ts = rs.getTimestamp(1);
                if (ts != null) {
                    res = new java.util.Date(((Timestamp)ts).getTime());
                }
            } else if (clz == Boolean.class || clz == Boolean.TYPE) {
                res = rs.getBoolean(1);
            } else if (clz == Blob.class) {
                res = rs.getBlob(1);
            } else if (clz == Clob.class) {
                res = rs.getClob(1);
            } else {
                throw new IllegalStateException("Call error: cannot handle requested return type " + clz);
            }
            if (!rs.wasNull()) break block29;
            ts = null;
            FileTool.closeAll((Object[])new Object[]{rs, ps});
            return (T)ts;
        }
        try {
            ts = res;
        }
        catch (SQLException x) {
            try {
                String msg = x.getMessage();
                if (rs != null && msg != null && msg.contains("internal representation")) {
                    String res2 = "(cannot obtain value)";
                    try {
                        res2 = rs.getString(1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new SQLException("Cannot convert '" + res2 + "' to internal representation " + clz + ": " + x, x);
                }
                throw x;
            }
            catch (Throwable throwable) {
                FileTool.closeAll((Object[])new Object[]{rs, ps});
                throw throwable;
            }
        }
        FileTool.closeAll((Object[])new Object[]{rs, ps});
        return (T)ts;
    }

    public static <T> List<T> selectSingleColumnList(@Nonnull Connection connection, @Nonnull Class<T> clz, @Nonnull String select, Object ... params) throws SQLException {
        Object res;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(select);
            JdbcUtil.setParameters(ps, 1, params);
            JdbcUtil.logDebug("selectSingleColumnList", select, params);
            rs = ps.executeQuery();
            ArrayList<Object> list = new ArrayList<Object>();
            while (rs.next()) {
                res = null;
                if (clz == String.class) {
                    res = rs.getString(1);
                } else if (clz == Long.class || clz == Long.TYPE) {
                    res = rs.getLong(1);
                } else if (clz == Integer.class || clz == Integer.TYPE) {
                    res = rs.getInt(1);
                } else if (clz == java.util.Date.class) {
                    Timestamp ts = rs.getTimestamp(1);
                    if (ts != null) {
                        res = new java.util.Date(ts.getTime());
                    }
                } else if (clz == Boolean.class || clz == Boolean.TYPE) {
                    res = rs.getBoolean(1);
                } else if (clz == Blob.class) {
                    res = rs.getBlob(1);
                } else if (clz == Clob.class) {
                    res = rs.getClob(1);
                } else {
                    throw new IllegalStateException("Call error: cannot handle requested return type " + clz);
                }
                if (rs.wasNull()) {
                    list.add(null);
                    continue;
                }
                list.add(res);
            }
            res = list;
        }
        catch (SQLException x) {
            try {
                String msg = x.getMessage();
                if (rs != null && msg != null && msg.contains("internal representation")) {
                    String res2 = "(cannot obtain value)";
                    try {
                        res2 = rs.getString(1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new SQLException("Cannot convert '" + res2 + "' to internal representation " + clz + ": " + x, x);
                }
                throw x;
            }
            catch (Throwable throwable) {
                FileTool.closeAll((Object[])new Object[]{rs, ps});
                throw throwable;
            }
        }
        FileTool.closeAll((Object[])new Object[]{rs, ps});
        return res;
    }

    public static void setParameters(@Nonnull PreparedStatement ps, int startindex, @Nullable Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            Object val = params[i];
            int px = i + startindex;
            if (val instanceof JdbcOutParam) {
                if (!(ps instanceof CallableStatement)) {
                    throw new IllegalArgumentException("expected CallableStatement instead of PreparedStatement for OUT/IN OUT param function/procedure call!");
                }
                ((CallableStatement)ps).registerOutParameter(px, JdbcUtil.calcSQLTypeFor(((JdbcOutParam)val).getClassType()));
                if (!(val instanceof JdbcInOutParam)) continue;
                JdbcUtil.setParameter(ps, ((JdbcInOutParam)val).getValue(), px);
                continue;
            }
            JdbcUtil.setParameter(ps, val, px);
        }
    }

    public static void setParameter(@Nonnull PreparedStatement ps, @Nullable Object val, int px) throws SQLException {
        if (val == null) {
            ps.setString(px, null);
        } else if (val instanceof String) {
            ps.setString(px, (String)val);
        } else if (val instanceof Long) {
            ps.setLong(px, (Long)val);
        } else if (val instanceof Integer) {
            ps.setInt(px, (Integer)val);
        } else if (val instanceof BigDecimal) {
            ps.setBigDecimal(px, (BigDecimal)val);
        } else if (val instanceof Double) {
            ps.setDouble(px, (Double)val);
        } else if (val instanceof Timestamp) {
            ps.setTimestamp(px, (Timestamp)val);
        } else if (val instanceof java.util.Date) {
            ps.setTimestamp(px, new Timestamp(((java.util.Date)val).getTime()));
        } else if (val instanceof Boolean) {
            ps.setBoolean(px, (Boolean)val);
        } else if (val instanceof RowId) {
            ps.setRowId(px, (RowId)val);
        } else if (val.getClass().getName().endsWith(".ROWID")) {
            ps.setObject(px, val);
        } else if (val instanceof Blob) {
            ps.setBlob(px, (Blob)val);
        } else if (val instanceof Clob) {
            ps.setClob(px, (Clob)val);
        } else {
            throw new IllegalStateException("Call error: unknown SQL parameter of type " + val.getClass());
        }
    }

    public static void readParameters(@Nonnull PreparedStatement ps, int startindex, @Nullable Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            Object val = params[i];
            if (!(val instanceof JdbcOutParam)) continue;
            if (!(ps instanceof CallableStatement)) {
                throw new IllegalArgumentException("expected CallableStatement instead of PreparedStatement for OUT/IN OUT param function/procedure call!");
            }
            JdbcUtil.setOutParamValue((CallableStatement)ps, startindex + i, ((JdbcOutParam)val).getClassType(), (JdbcOutParam)val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JdbcAnyRecord> queryAny(@Nonnull Connection dbc, @Nonnull String select, Object ... parameters) throws SQLException {
        List<JdbcAnyRecord> list;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = dbc.prepareStatement(select);
            JdbcUtil.setParameters(ps, 1, parameters);
            JdbcUtil.logDebug("queryAny", select, parameters);
            rs = ps.executeQuery();
            list = JdbcUtil.queryAny(select, rs);
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{rs, ps});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{rs, ps});
        return list;
    }

    public static List<JdbcAnyRecord> queryAny(String tblname, ResultSet rs) throws SQLException {
        ArrayList<JdbcAnyRecord> l = new ArrayList<JdbcAnyRecord>();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            JdbcAnyRecord a = new JdbcAnyRecord();
            a.initFromRS(tblname, md, rs);
            l.add(a);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcAnyRecord queryAnyOne(@Nonnull Connection dbc, @Nonnull String select, Object ... parameters) throws SQLException {
        JdbcAnyRecord jdbcAnyRecord;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = dbc.prepareStatement(select);
            JdbcUtil.setParameters(ps, 1, parameters);
            JdbcUtil.logDebug("queryAnyOne", select, parameters);
            rs = ps.executeQuery();
            jdbcAnyRecord = JdbcUtil.queryAnyOne(select, rs);
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{rs, ps});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{rs, ps});
        return jdbcAnyRecord;
    }

    public static JdbcAnyRecord queryAnyOne(@Nonnull String tblname, @Nonnull ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        ResultSetMetaData md = rs.getMetaData();
        JdbcAnyRecord a = new JdbcAnyRecord();
        a.initFromRS(tblname, md, rs);
        if (rs.next()) {
            throw new SQLException("Got >1 result for queryAnyOne");
        }
        return a;
    }

    private static int calcSQLTypeFor(@Nonnull Class<?> rt) {
        if (rt == String.class) {
            return 12;
        }
        if (rt == Integer.class || rt == Integer.TYPE || rt == Long.class || rt == Long.TYPE || rt == BigDecimal.class || rt == Double.class || rt == Double.TYPE) {
            return 2;
        }
        if (rt == java.util.Date.class) {
            return 91;
        }
        throw new IllegalStateException("Call error: cannot get SQLType for java type=" + rt);
    }

    private static void appendSPParameters(@Nonnull StringBuilder sb, @Nonnull List<Object> pars, @Nonnull Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object val = args[i];
            if (i > 0) {
                sb.append(',');
            }
            if (val instanceof Boolean) {
                sb.append((Boolean)val != false ? "true" : "false");
                continue;
            }
            sb.append("?");
            pars.add(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeStatement(@Nonnull Connection dbc, @Nonnull String sql, Object ... args) throws SQLException {
        boolean bl;
        PreparedStatement ps = null;
        try {
            ps = dbc.prepareStatement(sql);
            JdbcUtil.setParameters(ps, 1, args);
            JdbcUtil.logDebug("executeStatement", sql, args);
            bl = ps.execute();
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{ps});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{ps});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeUpdatingCallableStatement(@Nonnull Connection dbc, @Nonnull String sql, Object ... args) throws SQLException {
        CallableStatement cs;
        block4: {
            boolean bl;
            if (!StringTool.strStartsWithIgnoreCase((String)(sql = sql.trim()), (String)"begin") || !StringTool.strEndsWithIgnoreCase((String)sql, (String)"end;")) {
                StringBuilder response = new StringBuilder();
                response.append("Expected sql that starts with \"begin\" and ends with \"end;\", for example : begin insert into table1(colA, colB, colC) values (?,?,?) returning colId into ? ; end;\n");
                response.append("Found sql: ").append(sql).append("\n");
                response.append("In case that intention is to just execute CallableStatement that does not explicitly do updates (i.e. to execute stored procedure), please use {@link JdbcUtil#executeStatement} or {@link JdbcUtil#oracleSpCall} methods.");
                throw new IllegalArgumentException(response.toString());
            }
            cs = null;
            try {
                cs = dbc.prepareCall(sql);
                JdbcUtil.setParameters(cs, 1, args);
                JdbcUtil.logDebug("executeUpdatingCallableStatement", sql, args);
                if (cs.executeUpdate() != 1) break block4;
                JdbcUtil.readParameters(cs, 1, args);
                bl = true;
            }
            catch (Throwable throwable) {
                FileTool.closeAll((Object[])new Object[]{cs});
                throw throwable;
            }
            FileTool.closeAll((Object[])new Object[]{cs});
            return bl;
        }
        boolean bl = false;
        FileTool.closeAll((Object[])new Object[]{cs});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T oracleSpCall(@Nonnull Connection con, @Nonnull Class<T> rtype, @Nonnull String sp, Object ... args) throws SQLException {
        CallableStatement ps;
        block6: {
            T t;
            if (rtype == Boolean.class || rtype == Boolean.TYPE) {
                return (T)Boolean.valueOf(JdbcUtil.oracleSpCallReturningBool(con, sp, args));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("begin ");
            int startix = 1;
            if (rtype != null && rtype != Void.class) {
                sb.append("? := ");
                startix = 2;
            }
            ArrayList<Object> pars = new ArrayList<Object>(args.length);
            sb.append(sp).append('(');
            JdbcUtil.appendSPParameters(sb, pars, args);
            sb.append(");");
            sb.append("end;");
            String stmt = sb.toString();
            ps = null;
            try {
                ps = con.prepareCall(stmt);
                if (startix != 1) {
                    ps.registerOutParameter(1, JdbcUtil.calcSQLTypeFor(rtype));
                }
                JdbcUtil.setParameters(ps, startix, pars.toArray());
                JdbcUtil.logDebug("oracleSpCall", stmt, pars);
                ps.execute();
                JdbcUtil.readParameters(ps, startix, args);
                if (startix == 1) break block6;
                t = JdbcUtil.readPsValue(ps, 1, rtype);
            }
            catch (Throwable throwable) {
                FileTool.closeAll((Object[])new Object[]{ps});
                throw throwable;
            }
            FileTool.closeAll((Object[])new Object[]{ps});
            return t;
        }
        T t = null;
        FileTool.closeAll((Object[])new Object[]{ps});
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean oracleSpCallReturningBool(@Nonnull Connection con, @Nonnull String sp, Object ... args) throws SQLException {
        boolean bl;
        StringBuilder sb = new StringBuilder();
        sb.append("declare l_res number; ");
        sb.append("begin if(").append(sp).append("(");
        ArrayList<Object> pars = new ArrayList<Object>(args.length);
        JdbcUtil.appendSPParameters(sb, pars, args);
        sb.append(")) then l_res := 1; else l_res := 0; end if; ? := l_res;");
        sb.append("end;");
        String stmt = sb.toString();
        CallableStatement ps = null;
        try {
            ps = con.prepareCall(stmt);
            JdbcUtil.setParameters(ps, 1, pars.toArray());
            ps.registerOutParameter(pars.size() + 1, 2);
            JdbcUtil.logDebug("oracleSpCallReturningBool", stmt, pars);
            ps.execute();
            JdbcUtil.readParameters(ps, 1, pars.toArray());
            int res = ps.getInt(pars.size() + 1);
            bl = res != 0;
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{ps});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{ps});
        return bl;
    }

    private static <T> void setOutParamValue(@Nonnull CallableStatement ps, int index, @Nonnull Class<T> rtype, @Nonnull JdbcOutParam<?> pOutParam) throws SQLException {
        JdbcOutParam<?> outParam = pOutParam;
        outParam.setValue(JdbcUtil.readPsValue(ps, index, rtype));
    }

    private static <T> T readPsValue(@Nonnull CallableStatement ps, int index, @Nonnull Class<T> rtype) throws SQLException {
        if (rtype == String.class) {
            return (T)ps.getString(index);
        }
        if (rtype == Integer.class || rtype == Integer.TYPE) {
            return (T)Integer.valueOf(ps.getInt(index));
        }
        if (rtype == Long.class || rtype == Long.TYPE) {
            return (T)Long.valueOf(ps.getLong(index));
        }
        if (rtype == Double.class || rtype == Double.TYPE) {
            return (T)Double.valueOf(ps.getDouble(index));
        }
        if (rtype == BigDecimal.class) {
            return (T)ps.getBigDecimal(index);
        }
        if (rtype == Blob.class) {
            return (T)ps.getBlob(index);
        }
        if (rtype == Clob.class) {
            return (T)ps.getClob(index);
        }
        if (rtype == java.util.Date.class) {
            Timestamp ts = ps.getTimestamp(index);
            if (ts != null) {
                return (T)new java.util.Date(ts.getTime());
            }
            return null;
        }
        throw new IllegalStateException("Call error: cannot get out parameter for result java type=" + rtype);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String hasChildRecords(@Nonnull Connection dbc, @Nullable String schemaName, @Nonnull String tableName, @Nonnull String primaryKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void logDebug(@Nonnull String sourceMethod, @Nonnull String sql, Object[] params) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(sourceMethod + ": " + sql);
            JdbcUtil.logDebugParams(params);
        }
    }

    private static void logDebug(@Nonnull String sourceMethod, @Nonnull String sql, List<Object> params) {
        if (LOG.isDebugEnabled()) {
            JdbcUtil.logDebug(sourceMethod, sql, params.toArray());
        }
    }

    private static void logDebugParams(Object[] params) {
        int i = 0;
        for (Object val : params) {
            LOG.debug(i + ": " + JdbcUtil.getDebugParamValue(val));
            ++i;
        }
    }

    private static String getDebugParamValue(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof String) {
            return "[String] '" + (String)val + "'";
        }
        if (val instanceof Long) {
            return "[Long] " + (Long)val;
        }
        if (val instanceof Integer) {
            return "[Integer] " + (Integer)val;
        }
        if (val instanceof BigDecimal) {
            return "[BigDecimal] " + ((BigDecimal)val).doubleValue();
        }
        if (val instanceof Double) {
            return "[Double] " + (Double)val;
        }
        if (val instanceof Timestamp) {
            return "[Timestamp] " + val;
        }
        if (val instanceof java.util.Date) {
            return "[Date] " + val;
        }
        if (val instanceof Boolean) {
            return "[Boolean] " + (Boolean)val;
        }
        if (val instanceof RowId) {
            return "[RowId] " + val;
        }
        if (val.getClass().getName().endsWith(".ROWID")) {
            return "[Class.ROWID] " + val;
        }
        if (val instanceof Blob) {
            return "[Blob]";
        }
        if (val instanceof Clob) {
            return "[Clob]";
        }
        if (val instanceof JdbcOutParam) {
            return "[JdbcOutParam] class = " + ((JdbcOutParam)val).getClass();
        }
        if (val instanceof JdbcInOutParam) {
            return "[JdbcInParam] " + JdbcUtil.getDebugParamValue(((JdbcOutParam)val).getValue());
        }
        return "[unknown type!]";
    }

    @Nullable
    public static Long readLong(@Nonnull ResultSet rs, @Nonnull String colName) throws SQLException {
        Long value = rs.getLong(colName);
        if (rs.wasNull()) {
            return null;
        }
        return value;
    }

    @Nullable
    public static Integer readInt(@Nonnull ResultSet rs, @Nonnull String colName) throws SQLException {
        Integer value = rs.getInt(colName);
        if (rs.wasNull()) {
            return null;
        }
        return value;
    }

    @Nullable
    public static java.util.Date readDate(@Nonnull ResultSet rs, @Nonnull String colName) throws SQLException {
        return DateUtil.sqlToUtilDate((Date)rs.getDate(colName));
    }

    @Nullable
    public static java.util.Date readTimestamp(@Nonnull ResultSet rs, int colIndex) throws SQLException {
        Timestamp ts = rs.getTimestamp(colIndex);
        return null == ts ? null : new java.util.Date(ts.getTime());
    }
}

