/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcPropertyMeta;

public class LongType
implements IJdbcType,
IJdbcTypeFactory {
    @Override
    public int accept(JdbcPropertyMeta pm) {
        return pm.getActualClass() == Long.TYPE || pm.getActualClass() == Long.class ? 10 : -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) {
        return this;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pm) throws Exception {
        long val = rs.getLong(index);
        if (rs.wasNull()) {
            return null;
        }
        return val;
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta pm, Object value) throws Exception {
        long nv;
        Long iv = value instanceof Long ? (Long)value : RuntimeConversions.convertToLongWrapper((Object)value);
        if (pm.isNullable() && pm.getActualClass().isPrimitive() && pm.getNullValue() != null && (nv = Long.parseLong(pm.getNullValue())) == iv) {
            ps.setNull(index, 2);
            return;
        }
        ps.setLong(index, iv);
    }
}

