/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.webapp.qsql.BundleStatement;

public final class SQLBundle {
    @Nonnull
    private final String m_name;
    @Nonnull
    private final Map<String, String> m_map;
    @Nonnull
    private final Map<String, BundleStatement> m_stmtMap;
    @Nonnull
    private static final Map<String, Reference<SQLBundle>> m_bundleMap = new HashMap<String, Reference<SQLBundle>>();

    private SQLBundle(@Nonnull String name, @Nonnull Map<String, String> map) {
        this.m_name = name;
        this.m_map = map;
        this.m_stmtMap = new HashMap<String, BundleStatement>(map.size());
    }

    @Nonnull
    public static SQLBundle create(@Nonnull Class<?> base) {
        return SQLBundle.create(base, "sqlbundle.sql");
    }

    @Nonnull
    public static synchronized SQLBundle create(@Nonnull Class<?> base, @Nonnull String name) {
        SQLBundle b;
        String bn = base.getPackage().getName() + "." + name;
        Reference<SQLBundle> ref = m_bundleMap.get(bn);
        if (ref != null && null != (b = ref.get())) {
            return b;
        }
        InputStream is = base.getResourceAsStream(name);
        if (null == is) {
            throw new IllegalArgumentException("No class resource for class=" + base + " and name=" + name);
        }
        try {
            String data = FileTool.readStreamAsString((InputStream)is, (String)"utf-8");
            Map<String, String> map = SQLBundle.split(data);
            SQLBundle b2 = new SQLBundle(bn, map);
            m_bundleMap.put(bn, new WeakReference<SQLBundle>(b2));
            SQLBundle sQLBundle = b2;
            return sQLBundle;
        }
        catch (RuntimeException rx) {
            throw rx;
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    @Nonnull
    private static Map<String, String> split(@Nonnull String data) throws IOException {
        String line;
        LineNumberReader lnr = new LineNumberReader(new StringReader(data));
        StringBuilder sb = new StringBuilder();
        String currname = null;
        HashMap<String, String> res = new HashMap<String, String>();
        while (null != (line = lnr.readLine())) {
            String tl = line.trim();
            if (tl.startsWith("--!")) {
                SQLBundle.addStmt(sb, currname, res);
                currname = tl.substring(3).trim();
                if (StringTool.isValidDottedName((String)currname)) continue;
                throw new IllegalStateException("Invalid name for SQL statement: '" + currname + "'");
            }
            if (tl.startsWith("--")) continue;
            if (tl.startsWith("/")) {
                SQLBundle.addStmt(sb, currname, res);
                currname = null;
                continue;
            }
            sb.append(line).append('\n');
        }
        SQLBundle.addStmt(sb, currname, res);
        return res;
    }

    private static void addStmt(@Nonnull StringBuilder sb, @Nullable String currname, @Nonnull Map<String, String> res) {
        if (null == currname) {
            return;
        }
        String sql = sb.toString().trim();
        if (null != res.put(currname, sql)) {
            throw new IllegalStateException("Duplicate key=" + currname + " in bundle");
        }
        sb.setLength(0);
    }

    @Nonnull
    public String getString(@Nonnull String name) {
        String sql = this.m_map.get(name);
        if (null == sql) {
            throw new MissingResourceException("Missing SQL resource '" + name + "' in SQL bundle " + this, this.m_name, name);
        }
        return sql;
    }

    @Nonnull
    public synchronized BundleStatement getStatement(@Nonnull String key) {
        BundleStatement bs = this.m_stmtMap.get(key);
        if (null == bs) {
            String sql = this.getString(key);
            bs = BundleStatement.create(sql);
            this.m_stmtMap.put(key, bs);
        }
        return bs;
    }
}

